# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory USN-786-1 (apr-util)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
                                                                                
if(description)
{
 script_id(64200);
 script_cve_id("CVE-2009-0023", "CVE-2009-1955", "CVE-2009-1956");
 script_version ("$");
 script_tag(name:"cvss_base", value:"7.8");
 script_tag(name:"risk_factor", value:"High");
 name = "Ubuntu USN-786-1 (apr-util)";
 script_name(name);

 desc = "The remote host is missing an update to apr-util
announced via advisory USN-786-1.

Details follow:

Matthew Palmer discovered an underflow flaw in apr-util. An attacker could
cause a denial of service via application crash in Apache using a crafted
SVNMasterURI directive, .htaccess file, or when using mod_apreq2.
Applications using libapreq2 are also affected. (CVE-2009-0023)

It was discovered that the XML parser did not properly handle entity
expansion. A remote attacker could cause a denial of service via memory
resource consumption by sending a crafted request to an Apache server
configured to use mod_dav or mod_dav_svn. (CVE-2009-1955)

C. Michael Pilato discovered an off-by-one buffer overflow in apr-util when
formatting certain strings. For big-endian machines (powerpc, hppa and
sparc in Ubuntu), a remote attacker could cause a denial of service or
information disclosure leak. All other architectures for Ubuntu are
not considered to be at risk. (CVE-2009-1956)

Solution:
The problem can be corrected by upgrading your system to the
following package versions:

Ubuntu 8.04 LTS:
  libaprutil1                     1.2.12+dfsg-3ubuntu0.1

Ubuntu 8.10:
  libaprutil1                     1.2.12+dfsg-7ubuntu0.1

Ubuntu 9.04:
  libaprutil1                     1.2.12+dfsg-8ubuntu0.1

After a standard system upgrade you need to restart any services that use
apr-util, such as Apache or svnserve, to effect the necessary changes.

https://secure1.securityspace.com/smysecure/catid.html?in=USN-786-1

Risk factor : High";

 script_description(desc);

 summary = "Ubuntu USN-786-1 (apr-util)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family = "Ubuntu Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"libaprutil1-dbg", ver:"1.2.12+dfsg-3ubuntu0.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libaprutil1-dev", ver:"1.2.12+dfsg-3ubuntu0.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libaprutil1", ver:"1.2.12+dfsg-3ubuntu0.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libaprutil1-dbg", ver:"1.2.12+dfsg-7ubuntu0.1", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libaprutil1-dev", ver:"1.2.12+dfsg-7ubuntu0.1", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libaprutil1", ver:"1.2.12+dfsg-7ubuntu0.1", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libaprutil1-dbg", ver:"1.2.12+dfsg-8ubuntu0.1", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libaprutil1-dev", ver:"1.2.12+dfsg-8ubuntu0.1", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libaprutil1", ver:"1.2.12+dfsg-8ubuntu0.1", rls:"UBUNTU9.04")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
