###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_proftpd_server_detect.nasl 1025 2009-08-14 09:44:19Z aug $
#
# ProFTPD Server Remote Version Detection
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Updated to include detect mechanism for single charecter after version
#  - By Antu Sanadi <santu@secpod.com> On 2009/11/1
#
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900815);
  script_version("$Revision: 1.0 $");
  script_tag(name:"risk_factor", value:"None");
  script_name("ProFTPD Server Remote Version Detection");
  desc = "

  Overview : This script detects the installed version of ProFTP Server
  and sets the version in KB.

  Risk factor : None";

  script_description(desc);
  script_summary("Set KB for the Version of ProFTPD Server");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("FTP");
  script_dependencies("find_service.nes");
  script_require_ports("Services/ftp", 21);
  exit(0);
}


include("ftp_func.inc");

ftpPort = get_kb_item("Services/ftp");
if(!ftpPort){
  ftpPort = 21;
}

if(!get_port_state(ftpPort)){
  exit(0);
}

# Get the version from banner
banner = get_ftp_banner(port:ftpPort);

if(banner != NULL)
{
  if("ProFTPD" >< banner)
  {
    set_kb_item(name:"ProFTPD/Intalled", value:TRUE);

    ftpVer = eregmatch(pattern:"ProFTPD ([0-9.]+)([A-Za-z0-9]+)?", string:banner);
    if(ftpVer[1] != NULL)
    {
      if(ftpVer[2] != NULL)
        ftpVer = ftpVer[1] + "." + ftpVer[2];
      else
        ftpVer = ftpVer[1];

      # Set KB for ProFTPD Version
      if(ftpVer != NULL){
        set_kb_item(name:"ProFTPD/Ver", value:ftpVer);
        security_note(data:"ProFTPD version " + ftpVer +
                           " was detected on the host");
      }
    }
  }
}
