###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_ms09-048.nasl 4581 2009-09-09 11:56:09Z sep $
#
# Microsoft Windows TCP/IP Remote Code Execution Vulnerability (967723)
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900838);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"7.8");
  script_tag(name:"risk_factor", value:"High");
  script_cve_id("CVE-2008-4609", "CVE-2009-1926");
  script_bugtraq_id(31545, 36269);
  script_name("Microsoft Windows TCP/IP Remote Code Execution Vulnerability (967723)");
  desc = "
  Overview: This host has critical security update missing according to
  Microsoft Bulletin MS09-048.

  Vulnerability Insight:
  An error in the TCP/IP processing can be exploited to cause connections to
  hang indefinitely in a FIN-WAIT-1 or FIN-WAIT-2 state, and system to stop
  responding to new requests by flooding it using specially crafted packets
  with a TCP receive window size set to a very small value or zero.

  Impact:
  Successful exploitation will let the attacker execute arbitrary code, and it
  may result in Denial of Service condition in an affected system.

  Impact Level: System/Application

  Affected Software/OS:
  Microsoft Windows 2k  Service Pack 4 and prior
  Microsoft Windows 2k3 Service Pack 2 and prior

  Fix:
  Run Windows Update and update the listed hotfixes or download and
  update mentioned hotfixes in the advisory from the below link.
  http://www.microsoft.com/technet/security/bulletin/ms09-048.mspx

  References:
  http://secunia.com/advisories/36602/
  http://secunia.com/advisories/36597/
  http://support.microsoft.com/kb/967723
  http://www.vupen.com/english/advisories/2009/2567
  http://www.microsoft.com/technet/security/bulletin/ms09-048.mspx

  Risk factor: Critical";

  script_description(desc);
  script_summary("Check for the version of Tcpip.sys file");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Windows : Microsoft Bulletins");
  script_dependencies("secpod_reg_enum.nasl");
  script_require_ports(139, 445);
  exit(0);
}


include("smb_nt.inc");
include("secpod_reg.inc");
include("version_func.inc");
include("secpod_smb_func.inc");

# Windows 2K
if(hotfix_check_sp(win2k:5) > 0)
  security_hole(0);

# Windows 2003
if(hotfix_check_sp(win2003:3) > 0)
{
  # MS09-048 Hotfix check
  if(hotfix_missing(name:"967723") == 0)
  {
    exit(0);
  }

  sysPath = registry_get_sz(key:"SOFTWARE\Microsoft\COM3\Setup",
                            item:"Install Path");
  if(!sysPath)
  {
    exit(0);
  }

  share = ereg_replace(pattern:"([A-Z]):.*", replace:"\1$", string:sysPath);
  file = ereg_replace(pattern:"[A-Z]:(.*)", replace:"\1",
                      string:sysPath + "\drivers\Tcpip.sys");

  sysVer = GetVer(file:file, share:share);
  if(!sysVer)
  {
    exit(0);
  }

  # Windows 2003
  if(hotfix_check_sp(win2003:3) > 0)
  {
    SP = get_kb_item("SMB/Win2003/ServicePack");
    if("Service Pack 2" >< SP)
    {
      # Grep for Tcpip.sys version < 5.2.3790.4573
      if(version_is_less(version:sysVer, test_version:"5.2.3790.4573")){
        security_hole(0);
      }
    }
    else
      security_hole(0);
  }
}
