###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_kerberos5_mult_int_underflow_vuln.nasl 6805 2010-01-16 16:30:29Z jan $
#
# Kerberos5 Multiple Integer Underflow Vulnerabilities
#
# Authors:
# Antu Sanadi <santu@secpod.com>
#
# Copyright:
# Copyright (c) 2010 Greenbone Networks GmbH, http://www.greenbone.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800433);
  script_version("$Revision: 7613 $: 1.0");
  script_tag(name:"cvss_base", value:"10.0");
  script_tag(name:"risk_factor", value:"Critical");
  script_cve_id("CVE-2009-4212");
  script_name("Kerberos5 Multiple Integer Underflow Vulnerabilities");
  desc = "
  Overview: This host is installed with Kerberos5 and is prone to multiple
  Integer Underflow vulnerability.

  Vulnerability Insight:
  Multiple Integer Underflow due to errors within the 'AES' and 'RC4'
  decryption functionality in the crypto library in MIT Kerberos when
  proccessing ciphertext with a length that is too short to be valid.

  Impact:
  Successful exploitation will let the attacker to cause a denial of service
  or possibly execute arbitrary code.

  Impact level: Application

  Affected Software/OS:
  kerberos5 version 1.3 to 1.6.3, and 1.7

  Fix: Apply patch from below link,
  http://web.mit.edu/kerberos/advisories/2009-004-patch_1.7.txt
  http://web.mit.edu/kerberos/advisories/2009-004-patch_1.6.3.txt

  *****
  NOTE: Ignore this warning if above mentioned patch is already applied.
  *****

  References:
  https://bugzilla.redhat.com/show_bug.cgi?id=545015
  http://web.mit.edu/kerberos/advisories/MITKRB5-SA-2009-004.txt

  CVSS Score:
    CVSS Base Score      : 10.0 (AV:N/AC:L/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score  : 7.8
  Risk factor : Critical";

  script_description(desc);
  script_summary("Check for the version of Kerberos5");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (c) 2010 Greenbone Networks GmbH");
  script_family("Buffer overflow");
  script_dependencies("gb_kerberos5_detect.nasl");
  script_require_keys("Kerberos5/Ver");
  exit(0);
}


include("version_func.inc");

krbVer = get_kb_item("Kerberos5/Ver");
if(!krbVer){
  exit(0);
}

# Grep for Kerberos5 version 1.3 to 1.6.3 and 1.7
if(version_is_equal(version:krbVer, test_version:"1.7") ||
   version_in_range(version:krbVer, test_version:"1.3", test_version2:"1.6.3")){
  security_hole(0);
}

