###############################################################################
# OpenVAS Vulnerability Test
#
# HP-UX Update for Java VM (J2SE) or Java Secure Socket Extension (JSSE) Software HPSBUX00280
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(835068);
  script_version("$Revision: 1.0 $");
  script_tag(name:"risk_factor", value:"High");
  script_xref(name: "HPSBUX", value: "00280");
  script_name( "HP-UX Update for Java VM (J2SE) or Java Secure Socket Extension (JSSE) Software HPSBUX00280");
  desc = "

  Vulnerability Insight:
  A potential security vulnerability has been identifiedwith HP-UX running 
  Java VM (J2SE) andJava Secure Socket Extension (JSSE) software, that may 
  resultin arbitrary code execution and an information leak. 

  Impact:
  Arbitrary code execution.

  Affected Software/OS:
  Java VM (J2SE) or Java Secure Socket Extension (JSSE) Software on
  HP-UX B.11.00, B.11.11, B.11.22 and B.11.23 running Java VM (J2SE) and 
  HP9000 Servers running HP-UX release B.11.00 and B.11.11, with the following 
  versions of 

  Fix: Please Install the Updated Packages.

  References:
  http://www11.itrc.hp.com/service/cki/docDisplay.do?docId=emr_na-c00954663-1

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of Java VM (J2SE) or Java Secure Socket Extension (JSSE) Software");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("HP-UX Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-hpux.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "HPUX11.00")
{

  if(ishpuxpkgvuln(pkg:"are listed in this bulletin.", revision:"B.03.00.04", rls:"HPUX11.00"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"for Servicecontrol Manager", revision:"B.03.00.04", rls:"HPUX11.00"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"SysMgmtAgent.MX-AGENT", revision:"B.03.00.04", rls:"HPUX11.00"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"SysMgmtAgent.MX-ENG-MAN", revision:"B.03.00.04", rls:"HPUX11.00"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"SysMgmtServer.MX-CMS", revision:"B.03.00.04", rls:"HPUX11.00"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"SysMgmtServer.MX-PORTAL", revision:"B.03.00.04", rls:"HPUX11.00"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"SysMgmtServer.MX-REPO", revision:"B.03.00.04", rls:"HPUX11.00"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"SysMgmtServer.MX-TOOLS", revision:"B.03.00.04", rls:"HPUX11.00"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"are listed in this bulletin.", revision:"B.03.00.04", rls:"HPUX11.00"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"for Servicecontrol Manager", revision:"B.03.00.04", rls:"HPUX11.00"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"SysMgmtAgent.MX-AGENT", revision:"B.03.00.04", rls:"HPUX11.00"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"SysMgmtAgent.MX-ENG-MAN", revision:"B.03.00.04", rls:"HPUX11.00"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"SysMgmtServer.MX-CMS", revision:"B.03.00.04", rls:"HPUX11.00"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"SysMgmtServer.MX-PORTAL", revision:"B.03.00.04", rls:"HPUX11.00"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"SysMgmtServer.MX-REPO", revision:"B.03.00.04", rls:"HPUX11.00"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"SysMgmtServer.MX-TOOLS", revision:"B.03.00.04", rls:"HPUX11.00"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "HPUX11.22")
{

  if(ishpuxpkgvuln(pkg:"are listed in this bulletin.", revision:"B.03.00.04", rls:"HPUX11.22"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"for Servicecontrol Manager", revision:"B.03.00.04", rls:"HPUX11.22"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"SysMgmtAgent.MX-AGENT", revision:"B.03.00.04", rls:"HPUX11.22"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"SysMgmtAgent.MX-ENG-MAN", revision:"B.03.00.04", rls:"HPUX11.22"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"SysMgmtServer.MX-CMS", revision:"B.03.00.04", rls:"HPUX11.22"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"SysMgmtServer.MX-PORTAL", revision:"B.03.00.04", rls:"HPUX11.22"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"SysMgmtServer.MX-REPO", revision:"B.03.00.04", rls:"HPUX11.22"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"SysMgmtServer.MX-TOOLS", revision:"B.03.00.04", rls:"HPUX11.22"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "HPUX11.11")
{

  if(ishpuxpkgvuln(pkg:"are listed in this bulletin.", revision:"B.03.00.04", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"for Servicecontrol Manager", revision:"B.03.00.04", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"SysMgmtAgent.MX-AGENT", revision:"B.03.00.04", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"SysMgmtAgent.MX-ENG-MAN", revision:"B.03.00.04", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"SysMgmtServer.MX-CMS", revision:"B.03.00.04", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"SysMgmtServer.MX-PORTAL", revision:"B.03.00.04", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"SysMgmtServer.MX-REPO", revision:"B.03.00.04", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"SysMgmtServer.MX-TOOLS", revision:"B.03.00.04", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"are listed in this bulletin.", revision:"B.03.00.04", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"for Servicecontrol Manager", revision:"B.03.00.04", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"SysMgmtAgent.MX-AGENT", revision:"B.03.00.04", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"SysMgmtAgent.MX-ENG-MAN", revision:"B.03.00.04", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"SysMgmtServer.MX-CMS", revision:"B.03.00.04", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"SysMgmtServer.MX-PORTAL", revision:"B.03.00.04", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"SysMgmtServer.MX-REPO", revision:"B.03.00.04", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"SysMgmtServer.MX-TOOLS", revision:"B.03.00.04", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}
