###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_drupal_xss_n_code_inj_vuln.nasl 3364 2009-07-14 10:26:22Z jul $
#
# Drupal XSS and Code Injection Vulnerability
#
# Authors:
# Nikita MR <rnikita@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800908);
  script_version("$Revision: 1.0$");
  script_tag(name:"cvss_base", value:"7.5");
  script_tag(name:"risk_factor", value:"High");
  script_cve_id("CVE-2009-2372", "CVE-2009-2373");
  script_bugtraq_id(35548);
  script_name("Drupal XSS and Code Injection Vulnerability");
  desc = "

  Overview:
  The host is installed with Drupal and is prone to Cross Site Scripting and
  Remote Code Injection vulnerabilities.

  Vulnerability Insight:
  Multiple flaws arise because,
  - The users can modify user signatures after the associated comment format is
    changed to an administrator-controlled input format, which allows remote
    authenticated users to inject arbitrary code via a crafted user signature.
  - When input passed into the unspecified vectors in the Forum module is not
    properly sanitised before being returned to the user.

  Impact:
  Attackers can exploit this issue to conduct script insertion attacks and
  inject and execute arbitrary PHP, HTML and script code.

  Impact Level: Application

  Affected Software/OS:
  Drupal version 6.x before 6.13 on all platforms.

  Fix: Upgrade to Drupal 6.13 or later
  http://drupal.org

  References:
  http://drupal.org/node/507572
  http://secunia.com/advisories/35681
  http://securitytracker.com/alerts/2009/Jul/1022497.html

  CVSS Score:
    CVSS Base Score     : 7.5 (AV:N/AC:L/Au:NR/C:P/I:P/A:P)
    CVSS Temporal Score : 5.5
  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of Drupal");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Web application abuses");
  script_dependencies("drupal_detect.nasl");
  exit(0);
}


include("http_func.inc");
include("version_func.inc");

drPort = get_http_port(default:80);
if(!drPort){
  exit(0);
}

drupalVer = get_kb_item(string("www/", drPort, "/drupal"));
drupalVer = eregmatch(pattern:"^(.+) under (/.*)$", string:drupalVer);

if(!drupalVer[1]){
  exit(0);
}

# Check for Drupal Version 6.0 < 6.13
if(version_in_range(version:drupalVer[1], test_version:"6.0", test_version2:"6.12")){
  security_hole(drPort);
}
