# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory FEDORA-2009-1824 (jhead)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(63491);
 script_cve_id("CVE-2008-4640", "CVE-2008-4641");
 script_version ("$");
 script_tag(name:"cvss_base", value:"10.0");
 script_tag(name:"risk_factor", value:"Critical");
 name = "Fedora Core 10 FEDORA-2009-1824 (jhead)";
 script_name(name);

 desc = "The remote host is missing an update to jhead
announced via advisory FEDORA-2009-1824.

Update Information:

* fixes CVE-2008-4640 jhead: arbitrary file deletion (#468056)    * fixes
CVE-2008-4641 jhead: command exection caused by incorrect handling of the shell
escapes (#468057)

ChangeLog:

* Mon Feb 16 2009 Adrian Reber  - 2.86-1
- updated to 2.86
- fixes CVE-2008-4640 jhead: arbitrary file deletion (#468056)
- fixes CVE-2008-4641 jhead: command exection caused by
incorrect handling of the shell escapes (#468057)
- fixes build ignores optflags (#485697)

References:

[ 1 ] Bug #468056 - CVE-2008-4640 jhead: arbitrary file deletion
https://bugzilla.redhat.com/show_bug.cgi?id=468056
[ 2 ] Bug #468057 - CVE-2008-4641 jhead: command exection caused by incorrect handling of the shell escapes
https://bugzilla.redhat.com/show_bug.cgi?id=468057

Solution: Apply the appropriate updates.

This update can be installed with the yum update program.  Use 
su -c 'yum update jhead' at the command line.
For more information, refer to Managing Software with yum,
available at http://docs.fedoraproject.org/yum/.

https://secure1.securityspace.com/smysecure/catid.html?in=FEDORA-2009-1824

Risk factor : High";

 script_description(desc);

 summary = "Fedora Core 10 FEDORA-2009-1824 (jhead)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family = "Fedora Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"jhead", rpm:"jhead~2.86~1.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"jhead-debuginfo", rpm:"jhead-debuginfo~2.86~1.fc10", rls:"FC10")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
