# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1716-1 (vnc4)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(63303);
 script_cve_id("CVE-2008-4770");
 script_version ("$");
 script_tag(name:"cvss_base", value:"10.0");
 script_tag(name:"risk_factor", value:"Critical");
 name = "Debian Security Advisory DSA 1716-1 (vnc4)";
 script_name(name);

 desc = "The remote host is missing an update to vnc4
announced via advisory DSA 1716-1.

It was discovered that xvnc4viewer, a virtual network computing client
software for X, is prone to an integer overflow via a malicious
encoding value that could lead to arbitrary code execution.

For the stable distribution (etch) this problem has been fixed in
version 4.1.1+X4.3.0-21+etch1.

For the unstable (sid) distribution this problem has been fixed in
version 4.1.1+X4.3.0-31.

For the testing (lenny) distribution this problem will be fixed soon.

We recommend that you upgrade your vnc4 packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201716-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 1716-1 (vnc4)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"vnc4-common", ver:"4.1.1+X4.3.0-21+etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"xvnc4viewer", ver:"4.1.1+X4.3.0-21+etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"vnc4server", ver:"4.1.1+X4.3.0-21+etch1", rls:"DEB4.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
