!***********************************************************************
! This file is part of OpenMolcas.                                     *
!                                                                      *
! OpenMolcas is free software; you can redistribute it and/or modify   *
! it under the terms of the GNU Lesser General Public License, v. 2.1. *
! OpenMolcas is distributed in the hope that it will be useful, but it *
! is provided "as is" and without any express or implied warranties.   *
! For more details see the full text of the license in the file        *
! LICENSE or in <http://www.gnu.org/licenses/>.                        *
!                                                                      *
! Copyright (C) 1987, Bjorn O. Roos                                    *
!               1992, Per Ake Malmqvist                                *
!               1998, Jun-ya Hasegawa                                  *
!***********************************************************************
!--------------------------------------------*
! 1987  B. O. ROOS                           *
! DEPARTMENT OF THEORETICAL CHEMISTRY        *
! UNIVERSITY OF LUND                         *
! SWEDEN                                     *
!--------------------------------------------*

subroutine TRACTL(iPart)
!  SECOND ORDER TWO-ELECTRON TRANFORMATION PROGRAM. CONTROL SECTION
!
!  THIS SUBROUTINE SETS UP THE MEMORY ALLOCATIONS FOR TRA2 AND LOOPS
!  OVER THE SYMMETRY BLOCKS. TRA2 IS CALLED ONCE FOR EACH SYMMETRY
!  BLOCK OF INTEGRALS. SYMMETRY BLOCKED AO INTEGRALS MUST HAVE BEEN
!  GENERATED BY INTSORT ON UNIT LUINTA=40.
!
! WRITTEN IN GARCHING IN SEPTEMBER 1987
! AUTHOR: BYOERN ROOS
!         DEPARTMENT OF THEORETICAL CHEMISTRY
!         CHEMICAL CENTRE
!         P.O.B. 124
!         S-221 00 LUND SWEDEN     TEL: 46-10 82 51
!     ********** IBM-3090 RELEASE 87 09 14 **********
! 92-12-04 P-AA M: Changed for use with CASPT2 MOLCAS-3 version.
! Also transforms 1-el integrals. -> Actually that part is commented out
!
! 98-09-02 J.Hasegawa Modified for non-squared integrals.

use stdalloc, only: mma_allocate, mma_deallocate
use Constants, only: Half
use Definitions, only: wp, iwp, u6

implicit none
integer(kind=iwp), intent(in) :: iPart
integer(kind=iwp) :: I, IERR, iiPart, IRC, ISYM, Keep(8), KEEPP, KEEPQ, KEEPR, KEEPS, KEEPT, L2, L2M, LATRU, LATUS, lBuf, LIADUT, &
                     LMOP1, LMOQ1, LMOR1, LMOS1, LPQRS, LPQTU, LRS, LRSmx, LRUPQM, LTARU, LTAUS, LTUPQM, LTUPQX, LTURS, LTURSM, &
                     LURPQM, LW1, LW2, LW2B, LW3, LW3B, LW4, LW4B, LW5, LW6, MaxRS, MEMLFT, MEMT, MEMX, Mxx1, Mxx2, Mxx3, &
                     nBasXX(8), NCHAIN, NOCCT, NOTU, Nread, Nrest, NSP, NSPQ, NSPQR, NSQ, NSR, NSS, NSymR, NSymS, nSymXX, NX
real(kind=wp) :: XLPQRS, XMEMT
logical(kind=iwp) :: DoCholesky, IFTEST, iSquar
real(kind=wp), allocatable :: W1(:)
#include "rasdim.fh"
#include "caspt2.fh"
#include "intgrl.fh"
#include "trafo.fh"
#include "WrkSpc.fh"
#include "warnings.h"

IFTEST = .false.
#ifdef _DEBUGPRINT_
IfTest = .true.
#endif

! Copy data to common ERI.
NSYMZ = NSYM
do I=1,NSYM
  NORBZ(I) = NORB(I)
  NOSHZ(I) = NOSH(I)
  LUINTMZ = LUINTM
end do

! Open temporary files for half-transformed integrals.
! They are closed at end of TRACTL.

! The MO coefficients were allocated and read in STINI. They are
! available at WORK(LCMO).

! RETRIEVE BASE DATA FROM UNIT LUINTA

!*JHsta
call GetOrd(IRC,iSquar,nSymXX,nBasXX,Keep)
if (OUTFMT == 'LONG    ') then
  if (iSquar) write(u6,*) 'TRACTL OrdInt status: squared'
  if (.not. iSquar) write(u6,*) 'TRACTL OrdInt status: non-squared'
end if
!*JHend
if (IRC /= 0) then
  write(u6,*) ' TRACTL, called to transform the two-electron'
  write(u6,*) ' integrals, got non-zero return code from'
  write(u6,*) ' subroutine GETORD. The return code is IRC=',IRC
  write(u6,*) ' Do you have a valid ORDINT file? If you do,'
  write(u6,*) ' please inform the MOLCAS group -- this may be'
  write(u6,*) ' a bug. Anyway, the calculations must stop, sorry.'
  call QUIT(_RC_IO_ERROR_READ_)
end if
!* PAM2007: For unknown reasons, one extra word is needed.
!      lBuf = 1+MAX(255*255,NBMX**2)
! but note that tractl, being a utility, can be called from other
! programs and should not take the value NBMX from caspt2.fh...
! hence correction by AJS below.

! Correction by AJS, Jan. 12, 2009. Defines the value of NBMX
! -----------------------------------------------------------

NBMX = 1
do I=1,NSYM
  !write(u6,'(a,i2,a,i5)') 'ISYM=',I,'   nBas(ISYM)=',nBasXX(I)
  NBMX = max(NBMX,nBasXX(i))
end do

!lBuf = MAX(255*255,NBMX**2)
lBuf = 1+NBMX**2
!write(u6,'(2(A,I10))') 'NBMX=',NBMX,'   lBuf=',lBuf
!
! COMPARE CONTENT OF 1EL and 2EL INTEGRAL FILE
IERR = 0
if (NSYMXX /= NSYM) then
  IERR = 1
else
  do ISYM=1,NSYM
    if (NBAS(ISYM) /= NBASXX(ISYM)) IERR = 1
  end do
end if
if (IERR /= 0) then
  write(u6,*) '     *** ERROR IN SUBROUTINE TRACTL ***'
  write(u6,*) '          INCOMPATIBLE BASIS DATA'
  write(u6,*)
  write(u6,*) ' JOBIPH NR OF SYMM:',NSYM
  write(u6,*) ' JOBIPH NR OF BASIS FUNCTIONS/SYMM:'
  write(u6,'(1x,8I5)') (NBAS(I),I=1,NSYM)
  write(u6,*)
  write(u6,*) ' ORDINT NR OF SYMM:',NSYMXX
  write(u6,*) ' ORDINT NR OF BASIS FUNCTIONS/SYMM:'
  write(u6,'(1x,8I5)') (NBASXX(I),I=1,NSYMXX)
  call ERRTRA()
  call SYSHALT('TRACTL')
end if

! SET ADDRESS FIELD FOR OUTPUT INTEGRAL FILE

LIADUT = 3*36*36
do I=1,36*36
  IAD2M(1,I) = 0
  IAD2M(2,I) = 0
  IAD2M(3,I) = 0
end do
IAD13 = 0
call iDAFILE(LUINTM,1,IAD2M,LIADUT,IAD13)

! LOOP OVER QUADRUPLES OF SYMMETRIES (NSP,NSQ,NSR,NSS)
! NOTE THAT THE INTEGRALS ON LUINTA HAVE TO BE SORTED IN THE SAME
! ORDER AS THE LOOP STRUCTURE BELOW (USE PROGRAM INTSORT)

! Allocate largest possible array as work space:
if (IFTEST) then
  write(u6,*) ' Symmetry  Basis functions   total orbitals    active orbitals'
  write(u6,*) ' -------------------------------------------------------------'
end if
call mma_maxDBLE(MEMX)
MEMX = max(MEMX-1*MEMX/6,0)

! Reserve space for Integral generation from Cholesky vectors
call DecideOnCholesky(DoCholesky)
if (DoCholesky) then
  MEMX = max(MEMX-MEMX/10,0)
  write(6,*) 'Memx= ',MEMX
end if

call mma_allocate(W1,MEMX,Label='W1')
LW1 = 1
NCHAIN = 0
LMOP1 = 1
ITP = 0
do NSP=1,NSYM
  if (NSP /= 1) ITP = ITP+NASH(NSP-1)
  NBP = NBAS(NSP)
  if (NSP /= 1) LMOP1 = LMOP1+NBAS(NSP-1)**2
  LMOP = LMOP1+NBP*NFRO(NSP)
  LMOP2 = LMOP
  NOP = NORB(NSP)
  NOCP = NOSH(NSP)
  KEEPP = KEEP(NSP)
  ISP = NSP
  LMOQ1 = 1
  ITQ = 0
  do NSQ=1,NSP
    if (NSQ /= 1) ITQ = ITQ+NASH(NSQ-1)
    NBQ = NBAS(NSQ)
    if (NSQ /= 1) LMOQ1 = LMOQ1+NBAS(NSQ-1)**2
    LMOQ = LMOQ1+NBQ*NFRO(NSQ)
    LMOQ2 = LMOQ
    KEEPQ = KEEP(NSQ)
    NOQ = NORB(NSQ)
    NOCQ = NOSH(NSQ)
    ISQ = NSQ
    NSPQ = MUL(NSP,NSQ)
    LMOR1 = 1
    ITR = 0
    !*JHsta
    NSymR = NSP
    if (iSquar) NSymR = NSYM
    do NSR=1,NSymR
    !*JHend
      if (NSR /= 1) ITR = ITR+NASH(NSR-1)
      NBR = NBAS(NSR)
      if (NSR /= 1) LMOR1 = LMOR1+NBAS(NSR-1)**2
      LMOR = LMOR1+NBR*NFRO(NSR)
      LMOR2 = LMOR
      KEEPR = KEEP(NSR)
      NOR = NORB(NSR)
      NOCR = NOSH(NSR)
      NSPQR = MUL(NSPQ,NSR)
      ISR = NSR
      LMOS1 = 1
      ITS = 0
      !*JHsta
      NSymS = NSR
      if (NSP == NSR) NSymS = NSQ
      if (iSquar) NSymS = NSR
      do NSS=1,NSymS
      !*JHend
        if (NSS /= 1) ITS = ITS+NASH(NSS-1)
        NBS = NBAS(NSS)
        if (NSS /= 1) LMOS1 = LMOS1+NBAS(NSS-1)**2
        LMOS = LMOS1+NBS*NFRO(NSS)
        LMOS2 = LMOS
        if (NSPQR /= NSS) cycle
        NOS = NORB(NSS)
        NOCS = NOSH(NSS)
        KEEPS = KEEP(NSS)
        ISS = NSS

        KEEPT = KEEPP+KEEPQ+KEEPR+KEEPS
        NOCCT = NOCP*NOCQ*NOCR*NOCS
        if ((NOCCT /= 0) .and. (KEEPT /= 0)) call Error(1)
        if (KEEPT == 0) NCHAIN = NCHAIN+1
        if (NOP*NOQ*NOR*NOS == 0) cycle

        ! CALLING SEQUENCE FOR SECOND ORDER TRANSFORMATION TRA2
        ! FIRST ALLOCATE AND CHECK MEMORY

        NBPQ = NBP*NBQ
        if (ISP == ISQ) NBPQ = (NBP**2+NBP)/2
        NBRS = NBR*NBS
        if (ISR == ISS) NBRS = (NBR**2+NBR)/2
        NOTU = NOCR*NOCS
        if (ISR == ISS) NOTU = (NOCR**2+NOCR)/2

        if (IFTEST) then
          write(u6,'(1X,4I2,2X,4I4,2X,4I4,2X,4I4)') NSP,NSQ,NSR,NSS,NBP,NBQ,NBR,NBS,NOP,NOQ,NOR,NOS,NOCP,NOCQ,NOCR,NOCS
        end if

        !JHsta
        Mxx1 = max(lBuf,NOP*NBQ,NBP*NOCQ,NOCP*NBQ)
        Mxx2 = max(NBR*NBS,NBP*NBQ,NOP*NOR,NOP*NOS,NOQ*NOR,NOQ*NOS)
        Mxx3 = max(NOCR*NBS,NBR*NOCS)
        LW2 = LW1+Mxx1
        LW3 = LW2+Mxx2
        LW4 = LW3+Mxx3
        LRUPQ = NBP*NBQ*NBR*NOCS
        LURPQ = NBP*NBQ*NOCR*NBS
        MEMLFT = MEMX-LW4+LW1
        ! I.E. MEMLFT = MEMX-MXX1-MXX2-MXX3, possibly negative...
        LPQTU = NBP*NBQ*NOCR*NOCS
        LATRU = NOP*NOCQ*NBR*NOCS
        LTARU = NOCP*NOQ*NBR*NOCS
        LATUS = NOP*NOCQ*NOCR*NBS
        LTAUS = NOCP*NOQ*NOCR*NBS
        LTUPQ = max(LPQTU,LATRU,LTARU)
        MEMT = LRUPQ+LURPQ+LTUPQ
        L2 = max(LATUS,LTAUS)

        LRUPQM = NBR*NOCS
        if (LRUPQM /= 0) LRUPQM = max(NBR*NOCS,NBPQ)
        LURPQM = NBS*NOCR
        if (LURPQM /= 0) LURPQM = max(NBS*NOCR,NBPQ)
        LTUPQM = max(NOTU,NOCQ*NOCS*NOP,NOCP*NOCS*NOQ)
        if (LTUPQM /= 0) LTUPQM = max(LTUPQM,NBPQ,NBR*NOP,NBR*NOQ)
        L2M = max(NOCQ*NOCR*NOP,NOCP*NOCR*NOQ)
        if (L2M /= 0) L2M = max(NOP*NBS,NOQ*NBS)

        if ((MEMT > MEMLFT) .or. (L2 > MEMLFT-LURPQ)) then
          !LRUPQ = INT((One*MEMLFT*LRUPQ+MEMT-1)/MEMT)
          !LURPQ = INT((One*MEMLFT*LURPQ+MEMT-1)/MEMT)
          NX = MEMLFT/(LRUPQM+LURPQM+LTUPQM)
          iiPart = 1
          if (iPart > 0) then
            iiPart = iPart
          end if
          LRUPQ = NX*LRUPQM*iiPart
          LURPQ = NX*LURPQM*iiPart
        end if
        LTUPQ = max(0,MEMLFT-LRUPQ-LURPQ)
        !write(u6,*) 'LRUPQ=',LRUPQ
        !write(u6,*) 'LURPQ=',LURPQ
        !write(u6,*) 'LTUPQ=',LTUPQ

        if (LRUPQ < LRUPQM) call Error(2)
        if (LURPQ < LURPQM) call Error(2)
        if (LTUPQ < LTUPQM) call Error(2)
        if (LRUPQ+LTUPQ < L2M) call Error(2)
        LW5 = LW4+LURPQ
        LW6 = LW5+LRUPQ

        if (.not. iSquar) then
          ! Keep addresses LW2, LW3, LW4, and save LTUPQ (in common /TRAFO/),
          ! for use in the calls to tr2Sq or to tr2NsA.
          LTUPQX = LTUPQ

          ! Recompute memory requirements, now for the tr2NsB call.
          Mxx1 = max(lBuf,NBP*NOCQ,NBR*NOS,NOR*NBS)
          Mxx2 = max(NBP*NBQ,NBR*NBS)
          ! LPQRS, MEMT integers, changed to Re*8. Defined and used in the
          ! following section only. Named XLPQRS, XMEMT, +small local changes.
          XLPQRS = real(NBRS,kind=wp)
          XLPQRS = XLPQRS*real(NBP*NBQ,kind=wp)
          LTURS = NOCP*NOCQ*NBR*NBS
          ! Mxx1 words needed...
          LW2B = LW1+Mxx1
          ! Another Mxx2 words needed...
          LW3B = LW2B+Mxx2
          ! The next line can also be written ''MEMLFT = MEMX-MXX1-MXX2''
          ! This could possibly be small or negative.
          MEMLFT = max(0,MEMX-LW3+LW1)
          XMEMT = XLPQRS+real(LTURS,kind=wp)
          ! XMEMT is NBRS*NBP*NBQ + NOCP*NOCQ*NBR*NBS
          if (XMEMT > real(MEMLFT,kind=wp)) then
            LPQRS = int((real(MEMLFT,kind=wp)*XLPQRS)/XMEMT+Half)
          else
            LPQRS = int(XLPQRS)
          end if
          ! XLPQRS, XMEMT not used after this.
          LRSmx = LPQRS/NBPQ
          if (LRSmx > NBRS) LRSmx = NBRS
          Nread = NBRS/LRSmx
          Nrest = mod(NBRS,LRSmx)
          if (Nrest /= 0) Nread = Nread+1
          LRS = NBRS/Nread
          Nrest = mod(NBRS,Nread)
          if (Nrest /= 0) LRS = LRS+1
          LPQRS = LRS*NBPQ
          MaxRS = LRS
          LTURS = MEMLFT-LPQRS
          if (LPQRS < NBPQ) call Error(3)
          LTURSM = NOCP*NOCQ
          if (LTURSM /= 0) LTURSM = max(LTURSM,NBRS)
          if (LTURS < LTURSM) call Error(3)
          LW4B = LW3B+LPQRS
          LTUPQ = LTURS
        end if
        if (iSquar) then
          ! TR2Sq(CMO,X1,X2,X3,URPQ,RUPQ,TUPQ,lBuf)
          call tr2Sq(Work(LCMO),W1(LW1),W1(LW2),W1(LW3),W1(LW4),W1(LW5),W1(LW6),lBuf)
        else
          ! tr2NsA(CMO,X1,X2,X3,pqUs,pqrU,pqTU,lBuf)
          !LW2 = LW1+Mxx1
          !LW3 = LW2+Mxx2
          !LW4 = LW3+Mxx3
          !LW5 = LW4+LURPQ
          !LW6 = LW5+LRUPQ

          if (IFTEST) then
            write(u6,*) 'Calling tr2Nsa'
            write(u6,*) 'MEMX=',MEMX
            write(u6,*) 'lLW1=',LW2-LW1
            write(u6,*) 'lLW2=',LW3-LW2
            write(u6,*) 'lLW3=',LW4-LW3
            write(u6,*) 'lLW4=',LW5-LW4
            write(u6,*) 'lLW5=',LW6-LW5
            write(u6,*) 'lLW6=',MEMX-(LW6-LW1)
            write(u6,*)
          end if

          LTUPQ = LTUPQX
          call tr2NsA1(Work(LCMO),W1(LW1),LW2-LW1,W1(LW2),LW3-LW2,W1(LW3),LW4-LW3,W1(LW4),LW5-LW4,W1(LW5),LW6-LW5,W1(LW6), &
                       MEMX-(LW6-LW1),lBuf)
          call tr2NsA2(Work(LCMO),W1(LW1),LW2-LW1,W1(LW2),LW3-LW2,W1(LW5),LW6-LW5,W1(LW6),MEMX-(LW6-LW1))
          call tr2NsA3(Work(LCMO),W1(LW1),LW2-LW1,W1(LW2),LW3-LW2,W1(LW4),LW5-LW4,W1(LW5),MEMX-(LW5-LW1))
          LTUPQ = LTURS
          ! tr2NsB(CMO,X1,X2,pqrs,TUrs,lBuf,MAXRS)
          call tr2NsB(Work(LCMO),W1(LW1),W1(LW2B),W1(LW3B),W1(LW4B),lBuf,MaxRS)
        end if
      end do
    end do
  end do
end do
if (IFTEST) then
  write(u6,*) ' --------------------------------------------------------------'
end if
call mma_deallocate(W1)

! FINALLY WRITE OUT THE DAFILE ADDRESS LIST ON UNIT 13

IAD13 = 0
call iDAFILE(LUINTM,1,IAD2M,LIADUT,IAD13)

!PAM01 Also transform 1-electron integrals, and put CMOs on LUONEM.
!PAM01 call TRAONE(WORK(LCMO),KEEP)

return

contains

subroutine Error(code)
  integer(kind=iwp) :: code
  select case (code)
    case (1)
      ! HERE IF INTERPHASE FROM SORT IN ERROR
      write(u6,'(/5X,A,8I6)') 'ERROR IN KEEP PARAMETER FROM INTSORT FILE:  ',KEEP(1:NSYM)
      write(u6,'(/5X,A,8I6)') 'NOT CONSISTENT WITH OCCUPIED ORBITAL SPACE: ',NOSH(1:NSYM)
      write(u6,'(/5X,A)') 'PROGRAM STOP IN SUBROUTINE TRACTL'
    case (2)
      ! HERE IF NOT ENOUGH CORE SPACE
      write(u6,'(/1X,A)') 'NOT ENOUGH CORE SPACE FOR SORTING IN TRA2'
      write(u6,'(/1X,A,I12)') 'TOTAL SORTING SPACE IS',MEMLFT
      write(u6,'(/1X,A,I12,A,I12)') 'STEP1: AVAILABLE IS',LRUPQ,'  NEEDED IS',LRUPQM
      write(u6,'(/1X,A,I12,A,I12)') 'STEP2:    ''''         ',LTUPQ,'  NEEDED IS',LTUPQM
      write(u6,'(/1X,A,I12,A,I12)') 'STEP3:    ''''         ',LRUPQ+LTUPQ,'  NEEDED IS',L2M
    case (3)
      write(u6,'(/1X,A)') 'NOT ENOUGH CORE SPACE FOR SORTING IN TRATWO2'
      write(u6,'(/1X,A,I12)') 'TOTAL SORTING SPACE IS',MEMLFT
      write(u6,'(/1X,A,I12,A,I12)') 'STEP1: AVAILABLE IS',LPQRS,'  NEEDED IS',NBPQ
      write(u6,'(/1X,A,I12,A,I12)') 'STEP1:     ''''        ',LTURS,'   ''''        ',LTURSM
  end select
  call Abend()
end subroutine Error

end subroutine TRACTL
