/*
 *  Copyright (c) 2009 Cyrille Berger <cberger@cberger.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation;
 * either version 2, or (at your option) any later version of the License.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#include "GTLCore/ProgressReport.h"
#include "GTLCore/Type.h"

class TestProgressReport : public GTLCore::ProgressReport {
  public:
    TestProgressReport(bool interrupted) : m_row(0), m_pixel(0), m_interrupted(interrupted)
    {
    }
    void nextRow() { ++m_row; }
    void nextPixel() { ++m_pixel; }
    bool interrupted() const { return m_interrupted; }
    int m_row, m_pixel;
    bool m_interrupted;
};

class TestKernelProgressReport : public GTLTest::Case {
  public:
    TestKernelProgressReport() : GTLTest::Case("KernelProgressReport")
    {
    }
    virtual void runTest()
    {
      OpenShiva::Kernel k;
      k.setSource(
"kernel PlainGenerator \
{ \
  void evaluatePixel(out pixel result) \
  { \
  } \
}" );
      k.compile();
      GTLTEST_CHECK_REQUIRED(k.isCompiled());
      TestProgressReport tpr(false);
      GTLCore::Image img(100, 50, GTLCore::PixelDescription(GTLCore::Type::Integer8, 4));
      k.evaluatePixels( GTLCore::RegionI(0,0,100,50), std::list< const GTLCore::AbstractImage* >(), &img, &tpr);
      GTLTEST_CHECK_EQUAL(tpr.m_pixel, 5000);
      GTLTEST_CHECK_EQUAL(tpr.m_row, 50);
      TestProgressReport tpr2(true);
      k.evaluatePixels( GTLCore::RegionI(0,0,100,50), std::list< const GTLCore::AbstractImage* >(), &img, &tpr2);
      GTLTEST_CHECK_EQUAL(tpr2.m_pixel, 1);
      GTLTEST_CHECK_EQUAL(tpr2.m_row, 0);
    }
};
