# 4/7/2021

### Attending:

* Alban Fichet
* Cary Phillips
* Christina Tempelaar-Lietz
* Eskil Steenberg
* Joseph Goldstone
* Kimball Thurston
* Larry Gritz
* Peter Hillman
* Nick Porcino

### Discussion:

* Spectral Images:

  * Alban Fichet joined to discuss a method for storing spectral data
    in OpenEXR images, described in an openexr-dev discussion post and
    an upcoming JCGT publication available here:

      https://drive.google.com/file/d/1qSM7wnhhEGGx6NRIY2KcA3CYbyHj8mNe/view?usp=sharing

   * A convention in CG for spectral rendering. EXR is convenient
     standard. It would be helpful if OpenEXR is willing to publicize
     it.

  * Peter: Just now reading the email and seeing the pdf. But in
    general, it looks good.
  
  * Would a custom attribute type work better? If the types are
    standard, backwards compatibility is easier, but a custom type
    could make the API easier to use.
  
  * An array of floats would be great. But that would require two
    arrays of float per spectra.
  
  * The values are wavelengths and values.

  * Eskil: somebody asked about layer names. ACES has some conventions
    (“left eye”, “right eye”). The best naming matches what people are
    already using, so it should come from studios. Joseph: we’ve had a
    hard time getting even attribute names out of studios.  “That’s
    our secret sauce”

  * Alban: it's a hierarchy of layers. Typically, RGB plus 8
    additional layers for a typical rendered image.

  * Alban: we want two things:

  * Joseph: should there be accompanying metadata: low end, high end,
    and band width? In attribute names, or in metadata?

  * Eskil: you want the response curve.

  * Joseph: remember how we stored chromaticities. Carry around pairs
    of floats and have to remember which is which, or a special type.

  * Joseph: if spectral curves were a thing, I would use them in a heartbeat.

  * Need to be clear: either the name defines the frequency or the
    metadata defines it.

  * Peter: What happens if you have multiple layers within an
    image. A dirt layer and a underlying (macbeth layer and dirt on
    top) layer. What happens with a spectral version of each of those
    layers?  What happens if you’re trying to combine two spectral
    images with different spectral channels. You might have layers
    that are quite different. Separate layers for ambient and diffuse,
    for example.
    
  * A vote for putting the spectrum names in the layer name.


  * Peter: your example has spaces in attribute names (“Camera
    response”) but typically they don’t so they’ll look like variable
    names.

  * ES: I would vote to not have the frequency in the name. 

  * Joseph: do we have examples of compound types that consist of
    compound types? Not that anyone is aware of.
  
  * Peter: the ID manifest is an example of complicated data.

  * Peter: it's a good idea to keep the header size small.

  * The attribute itself is a list of spectra so it’s only stored once.

  * Kimball: there is a vector of float.

  * Joseph: there's difference between the reference and in SMPTE
    2064-4 standard.

  * Kimball:
  
    * Manuka has a model of the spectral response of the camera.

    * We record some aspects in the exr.

    * In terms of exr, we store what camera definition.

    * We’re not storing specific spectral information.

    * We have this range and these nm buckets, maybe 20 buckets within
      that, that’s the approximation of the curve. But we don’t output
      the accumulation buffers. Nor do we have spectral exrs.

* 3.1 release

  * Kimball: I’ve redone the half so there’s a C version of
    conversion. Added a performance test. Several configuration options. 

  * I’ve asked Anders and the rust folks to look at the API.
  
  * Larry: What scheduling constraints do the two projects have? They
    have their tool that produces bindings, but is OpenEXR depending
    on them?
  
  * Should we make a 4th repo for bindings? Does OIIO? Larry: No, all
    in one.  Nick: OTIO has a separate one. Larry: does the core OTIO
    repo trigger the other repo to validate? Nick: No, other way
    around.

  * Kimball: should have the main API checked in within the next week.
  
  * I’m not confident that I’ve written enough tests. I’ve written
    attribute tests, but for the file IO I’ve only picked some tests.
    Just duplicate the tests?

  * Set July 1 as a beta release target date, then early August for
    the official release.

  * Should we set up a wiki page for our roadmap? Yes.
  
