# 11/17/2020

### Attending:

* Cary Phillips
* Christina Tempelaar-Lietz
* Joseph Goldstone
* Kimball Thurston
* Larry Gritz
* Nick Porcino
* Peter Hillman
* Rod Bogart
* Michael B Johnson
* David Aguilar
* Robin Lowe

### Discussion:

* Wave: Lead of ASWF Assets working group

  * Example question we're dealing with: “How can we get a bunch of
    USD asets with MaterialX materials?”

  * Instead, why don’t we approach the projects and ask them what they
    would want, in the space that they care about?

  * At Apple we have some example EXR's we're trying to get clearance
    to send, mostly illustrating bugs.
  
  * Larry: We already have openexr-images, covers the basic.

  * Two examples that frequently come up with OIIO:

    * Test cases for all crazy things with metadata, range of data formats.

    * openexr-images has a couple of deep images, but they’re very
      simple caes, they aren’t indicative. We need hairy production
      images that would, say, confirm an application isn't going to
      run out of memory.

  * Kimball: could generate some AOV’s from the Moana scene.

  * Wave: Could we hire an intern to generate images from Moana?

  * Kimball: We don’t have a good version history. But then, backwards
    compatibility isn't that much of an issues, since we don't change
    the file format very often.
  
  * Wave: "Would like to be able to say there are 17 AOV’s in that
    image." Larry: "I'd would pay so much for anyone at my studio to
    use less than 50!"
  
  * Cary: maybe the project CII badge should include entries for
    example data. Project should be encouraged to provide
    representative example data.
  
  * Larry: OSL has a huge shader library, but everything’s
    interconnected, nothing public that is representatives of
    production use.
  
  * New features added to the library need corresponding test images.
  
  * Joseph: None of the compression methods are documented. Could we
    get an intern to document them? Not a Google Summer of Code
    intern, the project have to involve actual code. But it would be
    good to get it standardized.
  
  * Joseph: Maybe the Academy Sci-Tech intern? Speak to Alex
    Forstythe, there have been some great interns with the Academy.

* Robin Lowe: I’m participating in the discussions on the 16-bit float
  type with the C++ standards committee.

  * The C++ proposal is still active.

  * One of the key differences with 16 bit floats is how they do
    rounding.  C++ allows for severa kinds of rounding. OpenEXR only
    does one. We don’t allow the other kinds of rounding.
  
  * Whatever is in hardware is going to be stamped into standards.

  * Joseph: compatibility with existing code, will it be a templated type?

  * Robin: standard type should be the native type on the
    hardware. Or, these are three separate things.

  * OpenEXR is largely compatible with the Nvidia type.
  
  * Could typedef half to fp16.

  * “Call it half”, be done.

  * Larry: Will a standardized C++ 16-bit float be the same data
    layout as our half (what IEEE 754-2008 calls "binary16", and
    others call "half", "fp16", or "s10e5")? I imagine that it will,
    or that one of several fp16 types will be this one -- it kinda has
    to be because it's implemented already in so much hardware,
    including NVIDIA, AMD, and Intel chips for quite some time. I
    think there are two issues wrapped up here:

    1. If they do have the same data layout but there is some minor
       variation in operational semantics (some subtlety about
       rounding modes, etc), should we change our software
       implementation to match what other conforming implementations
       or hardware do? I think, yes, we should. There is no merit to
       doing something that's extremely subtly different from the rest
       of the world for what is obviously supposed to be the same data
       type. Even if we did the nonstandard thing before the standard
       arrived.
    
    2. If C++ defines multiple different 16 bit floating-point formats
       (e.g., bfloat16) should we extend the OpenEXR file format to
       accept pixels of that type? Maybe, it probably depends on how
       widely it's adopted, implemented in HW, and whether it's
       important to people who use OpenEXR. I know that bfloat16 is
       finding favor in ML circles, but I have not investigated
       whether it's a good choice for color or other things we tend to
       store in images. IIRC, bfloat16 has the full range of float,
       but even more limited precision than half. I don't know if it
       loses so much precision that it can't represent perceptual JND,
       and therefore would be a bad choice for storing color images.

* Continue C++11 support? 

  * Cary: ILM still has code that needs that requires C++11.

  * Kimball: So does Weta.

  * Larry: Then that's it, we maintain compatibility with C++11 for now.

* Imath PR #72: Eliminate normalize and length methods for Vec<inttype>

  * Cary: I recommend dropping the wonky integer methods. Better to
    have missing functions that functions that do weird things.

  * Larry: This is a part of the bigger thing of trying to put
    noexcept on everything. The integer methods throw exceptions, even
    the ones that aren't supposed to.
  