/*###############################################################################
# Linux Management Providers (LMP), SSH provider package
# Copyright (C) 2010 Feng Zhanlei, REDFLAG <fengzhanlei@redflag-linux.com>
# 
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
# 
# Modified by Guillaume BOTTEX <guillaumebottex@uxsystem.net>, UXSystem, 2010
###############################################################################*/

#include "OpenDRIM_RegisteredSSHProfileAccess.h"

const string InstanceID = "OpenDRIM:SSHService:1.0.0";

int SSH_OpenDRIM_RegisteredSSHProfile_load(const CMPIBroker* broker, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return OK;
}

int SSH_OpenDRIM_RegisteredSSHProfile_unload(string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return OK;
}

int SSH_OpenDRIM_RegisteredSSHProfile_retrieve(const CMPIBroker* broker, const CMPIContext* ctx, vector<OpenDRIM_RegisteredSSHProfile>& result, const char** properties, string& errorMessage, const string& discriminant) {
	_E_;
	OpenDRIM_RegisteredSSHProfile instance;
	instance.setInstanceID(InstanceID);
	
	if (discriminant == "ei")
		CF_assert(SSH_OpenDRIM_RegisteredSSHProfile_populate(instance, errorMessage));
	
	result.push_back(instance);
	_L_;
	return OK;
}

int SSH_OpenDRIM_RegisteredSSHProfile_getInstance(const CMPIBroker* broker, const CMPIContext* ctx, OpenDRIM_RegisteredSSHProfile& instance, const char** properties, string& errorMessage) {
	_E_;
	if (instance.InstanceID != InstanceID)
	{
		errorMessage = "No instance";
		return NOT_FOUND;
	}
	
	CF_assert(SSH_OpenDRIM_RegisteredSSHProfile_populate(instance, errorMessage));
	_L_;
	return OK;
}

int SSH_OpenDRIM_RegisteredSSHProfile_setInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_RegisteredSSHProfile& newInstance, const OpenDRIM_RegisteredSSHProfile& oldInstance, const char** properties, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int SSH_OpenDRIM_RegisteredSSHProfile_createInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_RegisteredSSHProfile& instance, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int SSH_OpenDRIM_RegisteredSSHProfile_deleteInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_RegisteredSSHProfile& instance, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int SSH_OpenDRIM_RegisteredSSHProfile_CloseConformantInstances(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_RegisteredSSHProfile& instance, unsigned int& returnValue, const OpenDRIM_RegisteredSSHProfile_CloseConformantInstances_In& in, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return OK;
}

int SSH_OpenDRIM_RegisteredSSHProfile_OpenConformantInstances(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_RegisteredSSHProfile& instance, unsigned int& returnValue, const OpenDRIM_RegisteredSSHProfile_OpenConformantInstances_In& in, OpenDRIM_RegisteredSSHProfile_OpenConformantInstances_Out& out, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return OK;
}

int SSH_OpenDRIM_RegisteredSSHProfile_PullConformantInstances(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_RegisteredSSHProfile& instance, unsigned int& returnValue, const OpenDRIM_RegisteredSSHProfile_PullConformantInstances_In& in, OpenDRIM_RegisteredSSHProfile_PullConformantInstances_Out& out, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return OK;
}

int SSH_OpenDRIM_RegisteredSSHProfile_populate(OpenDRIM_RegisteredSSHProfile& instance, string& errorMessage) {
	_E_;
	vector<unsigned short> advertiseTypes;
	
	instance.setRegisteredName("SSH Service");
	instance.setRegisteredVersion("1.0.0");
	instance.setRegisteredOrganization(2); // DMTF
	
	advertiseTypes.push_back(2);           // Not Advertised
	instance.setAdvertiseTypes(advertiseTypes);
	_L_;
	return OK;
}

