/*###############################################################################
# Linux Management Providers (LMP), OS provider package
# Copyright (C) 2007 Ilsoo Byun, ETRI <widepis@etri.re.kr ,widepis@empal.com>
# 
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
# 
# Modified by 2009 Khahramon NURIDDINOV, TUIT <qahramon0786@gmail.com>
# Modified by 2009 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr, guillaumebottex@gmail.com>
###############################################################################*/

#include "cmpiOpenDRIM_OperatingSystem.h"
#include "OpenDRIM_OperatingSystemAccess.h"

#include <iostream>

#define ToString(name, value, condition) os << (string) "      " + name + (string) "="; instance.condition ? os << "NULL" : os << instance.value; os << endl
#define ToStringInt(name, value, condition) os << (string) "      " + name + (string) "="; instance.condition ? os << "NULL" : os << (long) instance.value; os << endl
#define ToStringRef(name, value, condition) os << (string) "      " + name + (string) "="; instance.condition ? os << "NULL" : os << instance.value.toString(); os << endl
#define ToStringArray(name, value, condition) os << (string) "      " + name + (string) "=["; for (size_t i = 0; i < instance.value.size(); i++) { os << instance.value[i]; if (i < instance.value.size()-1) os << ","; } os << "]" << endl
#define ToStringArrayInt(name, value, condition) os << (string) "      " + name + (string) "=["; for (size_t i = 0; i < instance.value.size(); i++) { os << (long) instance.value[i]; if (i < instance.value.size()-1) os << ","; } os << "]" << endl
#define ToStringRefArray(name, value, condition) os << (string) "      " + name + (string) "=["; for (size_t i = 0; i < instance.value.size(); i++) { os << instance.value[i].toString(); if (i < instance.value.size()-1) os << ","; } os << "]" << endl

ostream& operator<<(ostream& os, OpenDRIM_OperatingSystem& instance) {
	os << "   [OpenDRIM_OperatingSystem]" << endl;
	ToString("InstanceID", InstanceID, InstanceID_isNULL);
	ToString("Caption", Caption, Caption_isNULL);
	ToString("Description", Description, Description_isNULL);
	ToString("ElementName", ElementName, ElementName_isNULL);
	ToString("InstallDate", InstallDate, InstallDate_isNULL);
	ToStringArrayInt("OperationalStatus", OperationalStatus, OperationalStatus_isNULL);
	ToStringArray("StatusDescriptions", StatusDescriptions, StatusDescriptions_isNULL);
	ToString("Status", Status, Status_isNULL);
	ToStringInt("HealthState", HealthState, HealthState_isNULL);
	ToStringInt("CommunicationStatus", CommunicationStatus, CommunicationStatus_isNULL);
	ToStringInt("DetailedStatus", DetailedStatus, DetailedStatus_isNULL);
	ToStringInt("OperatingStatus", OperatingStatus, OperatingStatus_isNULL);
	ToStringInt("PrimaryStatus", PrimaryStatus, PrimaryStatus_isNULL);
	ToStringInt("EnabledState", EnabledState, EnabledState_isNULL);
	ToString("OtherEnabledState", OtherEnabledState, OtherEnabledState_isNULL);
	ToStringInt("RequestedState", RequestedState, RequestedState_isNULL);
	ToStringInt("EnabledDefault", EnabledDefault, EnabledDefault_isNULL);
	ToString("TimeOfLastStateChange", TimeOfLastStateChange, TimeOfLastStateChange_isNULL);
	ToStringArrayInt("AvailableRequestedStates", AvailableRequestedStates, AvailableRequestedStates_isNULL);
	ToStringInt("TransitioningToState", TransitioningToState, TransitioningToState_isNULL);
	ToString("CSCreationClassName", CSCreationClassName, CSCreationClassName_isNULL);
	ToString("CSName", CSName, CSName_isNULL);
	ToString("CreationClassName", CreationClassName, CreationClassName_isNULL);
	ToString("Name", Name, Name_isNULL);
	ToStringInt("OSType", OSType, OSType_isNULL);
	ToString("OtherTypeDescription", OtherTypeDescription, OtherTypeDescription_isNULL);
	ToString("Version", Version, Version_isNULL);
	ToString("LastBootUpTime", LastBootUpTime, LastBootUpTime_isNULL);
	ToString("LocalDateTime", LocalDateTime, LocalDateTime_isNULL);
	ToStringInt("CurrentTimeZone", CurrentTimeZone, CurrentTimeZone_isNULL);
	ToString("NumberOfLicensedUsers", NumberOfLicensedUsers, NumberOfLicensedUsers_isNULL);
	ToString("NumberOfUsers", NumberOfUsers, NumberOfUsers_isNULL);
	ToString("NumberOfProcesses", NumberOfProcesses, NumberOfProcesses_isNULL);
	ToString("MaxNumberOfProcesses", MaxNumberOfProcesses, MaxNumberOfProcesses_isNULL);
	ToString("TotalSwapSpaceSize", TotalSwapSpaceSize, TotalSwapSpaceSize_isNULL);
	ToString("TotalVirtualMemorySize", TotalVirtualMemorySize, TotalVirtualMemorySize_isNULL);
	ToString("FreeVirtualMemory", FreeVirtualMemory, FreeVirtualMemory_isNULL);
	ToString("FreePhysicalMemory", FreePhysicalMemory, FreePhysicalMemory_isNULL);
	ToString("TotalVisibleMemorySize", TotalVisibleMemorySize, TotalVisibleMemorySize_isNULL);
	ToString("SizeStoredInPagingFiles", SizeStoredInPagingFiles, SizeStoredInPagingFiles_isNULL);
	ToString("FreeSpaceInPagingFiles", FreeSpaceInPagingFiles, FreeSpaceInPagingFiles_isNULL);
	ToString("MaxProcessMemorySize", MaxProcessMemorySize, MaxProcessMemorySize_isNULL);
	ToString("Distributed", Distributed, Distributed_isNULL);
	ToString("MaxProcessesPerUser", MaxProcessesPerUser, MaxProcessesPerUser_isNULL);
	os << "   [\\OpenDRIM_OperatingSystem]" << endl;
	return os;
}

int main() {
	
	string errorMessage;

	int errorCode = OS_OpenDRIM_OperatingSystem_load(NULL, errorMessage);
	if (errorCode != OK) {
		cout << "ERROR " << errorCode << ": " << errorMessage << endl;
		return -1;
	}

	cout << endl << "[enumInstances]" << endl;
	vector<OpenDRIM_OperatingSystem> instances;
	
	errorCode = OS_OpenDRIM_OperatingSystem_retrieve(NULL, NULL, instances, NULL, errorMessage, "ei");
	if (errorCode != OK) {
		cout << "ERROR " << errorCode << ": " << errorMessage << endl;
		return -1;
	}
	
	vector<OpenDRIM_OperatingSystem>::iterator it = instances.begin();
	for (; it != instances.end(); ++it) {
		cout << *it;
	}
	
	cout << "[\\enumInstances]" << endl;
	cout << endl << "[enumInstanceNames & getInstance]" << endl;
	
	instances.clear();
	errorCode = OS_OpenDRIM_OperatingSystem_retrieve(NULL, NULL, instances, NULL, errorMessage, "ein");
	if (errorCode != OK) {
		cout << "ERROR " << errorCode << ": " << errorMessage << endl;
		return -1;
	}
	
	it = instances.begin();
	for (; it != instances.end(); ++it) {
		errorCode = OS_OpenDRIM_OperatingSystem_getInstance(NULL, NULL, *it, NULL, errorMessage);
		if (errorCode != OK) {
			cout << "ERROR " << errorCode << ": " << errorMessage << endl;
			return -1;
		}
		cout << *it;
	}
	
	cout << "[\\enumInstanceNames & getInstance]" << endl;
	cout << endl;

	errorCode = OS_OpenDRIM_OperatingSystem_unload(errorMessage);
	if (errorCode != OK) {
		cout << "ERROR " << errorCode << ": " << errorMessage << endl;
		return -1;
	}
	return 0;
}
