/*###############################################################################
# Linux Management Providers (LMP), BIOS provider package
# Copyright (C) 2010 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr>
#
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
#
# Modified by <Author(s)>, <Affiliation>, <Year>
###############################################################################*/

#ifndef OPENDRIM_BIOSSERVICECAPABILITIES_H_
#define OPENDRIM_BIOSSERVICECAPABILITIES_H_

#include <Instance.h>

const static char* OpenDRIM_BIOSServiceCapabilities_classnames[] = {"OpenDRIM_BIOSServiceCapabilities"};
static string OpenDRIM_BIOSServiceCapabilities_NAMESPACE = _NAMESPACE;

class OpenDRIM_BIOSServiceCapabilities {

public:
	
	string Caption;
	bool Caption_isNULL;
	
	string Description;
	bool Description_isNULL;
	
	string InstanceID;
	bool InstanceID_isNULL;
	
	string ElementName;
	bool ElementName_isNULL;
	
	vector<unsigned int> MethodsSupported;
	bool MethodsSupported_isNULL;
	
	vector<string> SupportedPasswordAlgorithms;
	bool SupportedPasswordAlgorithms_isNULL;
	
	vector<unsigned int> SupportedPasswordEncodings;
	bool SupportedPasswordEncodings_isNULL;
	
	OpenDRIM_BIOSServiceCapabilities() {
		Caption_isNULL = true;
		Description_isNULL = true;
		InstanceID_isNULL = true;
		ElementName_isNULL = true;
		MethodsSupported_isNULL = true;
		SupportedPasswordAlgorithms_isNULL = true;
		SupportedPasswordEncodings_isNULL = true;
	}
	
	~OpenDRIM_BIOSServiceCapabilities() {}
	
	string getKeys() const {
		return CF_toLowCase(".InstanceID=\"" + CF_quoteString(InstanceID) + "\"");
	}

	int getCaption(string& value) const {
		if (Caption_isNULL==true)
			return NOT_FOUND;
		value = Caption;
		return OK;
	}
	
	int setCaption(const string& newValue) {
		Caption = newValue;
		Caption_isNULL = false;
		return OK;
	}

	int getDescription(string& value) const {
		if (Description_isNULL==true)
			return NOT_FOUND;
		value = Description;
		return OK;
	}
	
	int setDescription(const string& newValue) {
		Description = newValue;
		Description_isNULL = false;
		return OK;
	}

	int getInstanceID(string& value) const {
		if (InstanceID_isNULL==true)
			return NOT_FOUND;
		value = InstanceID;
		return OK;
	}
	
	int setInstanceID(const string& newValue) {
		InstanceID = newValue;
		InstanceID_isNULL = false;
		return OK;
	}

	int getElementName(string& value) const {
		if (ElementName_isNULL==true)
			return NOT_FOUND;
		value = ElementName;
		return OK;
	}
	
	int setElementName(const string& newValue) {
		ElementName = newValue;
		ElementName_isNULL = false;
		return OK;
	}

	int getMethodsSupported(vector<unsigned int>& value) const {
		if (MethodsSupported_isNULL==true)
			return NOT_FOUND;
		value = MethodsSupported;
		return OK;
	}
	
	int setMethodsSupported(const vector<unsigned int>& newValue) {
		MethodsSupported = newValue;
		MethodsSupported_isNULL = false;
		return OK;
	}

	int getSupportedPasswordAlgorithms(vector<string>& value) const {
		if (SupportedPasswordAlgorithms_isNULL==true)
			return NOT_FOUND;
		value = SupportedPasswordAlgorithms;
		return OK;
	}
	
	int setSupportedPasswordAlgorithms(const vector<string>& newValue) {
		SupportedPasswordAlgorithms = newValue;
		SupportedPasswordAlgorithms_isNULL = false;
		return OK;
	}

	int getSupportedPasswordEncodings(vector<unsigned int>& value) const {
		if (SupportedPasswordEncodings_isNULL==true)
			return NOT_FOUND;
		value = SupportedPasswordEncodings;
		return OK;
	}
	
	int setSupportedPasswordEncodings(const vector<unsigned int>& newValue) {
		SupportedPasswordEncodings = newValue;
		SupportedPasswordEncodings_isNULL = false;
		return OK;
	}

};

#endif /*OPENDRIM_BIOSSERVICECAPABILITIES_H_*/
