// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _GeomPlate_PointConstraint_HeaderFile
#define _GeomPlate_PointConstraint_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_DefineHandle_HeaderFile
#include <Standard_DefineHandle.hxx>
#endif
#ifndef _Handle_GeomPlate_PointConstraint_HeaderFile
#include <Handle_GeomPlate_PointConstraint.hxx>
#endif

#ifndef _GeomLProp_SLProps_HeaderFile
#include <GeomLProp_SLProps.hxx>
#endif
#ifndef _gp_Pnt_HeaderFile
#include <gp_Pnt.hxx>
#endif
#ifndef _gp_Pnt2d_HeaderFile
#include <gp_Pnt2d.hxx>
#endif
#ifndef _Handle_Geom_Surface_HeaderFile
#include <Handle_Geom_Surface.hxx>
#endif
#ifndef _gp_Vec_HeaderFile
#include <gp_Vec.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _MMgt_TShared_HeaderFile
#include <MMgt_TShared.hxx>
#endif
class Geom_Surface;
class Standard_ConstructionError;
class gp_Pnt;
class gp_Vec;
class gp_Pnt2d;
class GeomLProp_SLProps;



//! Defines points as constraints to be used to deform a surface. <br>
class GeomPlate_PointConstraint : public MMgt_TShared {

public:

  //! Constructs a point constraint object defined by  Pt, a 3D point <br>
//!   Order gives the order of constraint, one of: <br>
//! -   -1 i.e. none, or 0 i.e.G0 when assigned to Pt <br>
//! -   -1 i.e. none, 0 i.e. G0, 1 i.e. G1, 2 i.e. G2 when <br>
//!   assigned to U, V and Surf. <br>
//! In this constructor, only TolDist is given. <br>
//! Distance tolerance represents the greatest distance <br>
//! allowed between the constraint and the target surface. <br>
//! Angular tolerance represents the largest angle allowed <br>
//! between the constraint and the target surface. Curvature <br>
//! tolerance represents the greatest difference in curvature <br>
//! allowed between the constraint and the target surface. <br>
//! Raises   ConstructionError if Order  is  not  0  or  -1 <br>
  Standard_EXPORT   GeomPlate_PointConstraint(const gp_Pnt& Pt,const Standard_Integer Order,const Standard_Real TolDist = 0.0001);
  //! Constructs a point constraint object defined by <br>
//! the intersection point of U and V on the surface Surf. <br>
//!   Order gives the order of constraint, one of: <br>
//! -   -1 i.e. none, or 0 i.e.G0 when assigned to Pt <br>
//! -   -1 i.e. none, 0 i.e. G0, 1 i.e. G1, 2 i.e. G2 when <br>
//!   assigned to U, V and Surf. <br>
//! In this constructor the surface to be generated must <br>
//! respect several tolerance values only: <br>
//! -   the distance tolerance TolDist <br>
//! -   the angular tolerance TolAng <br>
//! -   the curvature tolerance, TolCurv. <br>
//! Distance tolerance represents the greatest distance <br>
//! allowed between the constraint and the target surface. <br>
//! Angular tolerance represents the largest angle allowed <br>
//! between the constraint and the target surface. Curvature <br>
//! tolerance represents the greatest difference in curvature <br>
//! allowed between the constraint and the target surface.Creates a punctual constraint. <br>
  Standard_EXPORT   GeomPlate_PointConstraint(const Standard_Real U,const Standard_Real V,const Handle(Geom_Surface)& Surf,const Standard_Integer Order,const Standard_Real TolDist = 0.0001,const Standard_Real TolAng = 0.01,const Standard_Real TolCurv = 0.1);
  
  Standard_EXPORT     void SetOrder(const Standard_Integer Order) ;
  
//! Returns the order of constraint: G0, G1, and G2, <br>
//! controlled respectively by G0Criterion G1Criterion and G2Criterion. <br>
  Standard_EXPORT     Standard_Integer Order() const;
  
//! Allows you to set the G0 criterion. This is the law <br>
//! defining the greatest distance allowed between the <br>
//! constraint and the target surface. If this criterion is not <br>
//! set, {TolDist, the distance tolerance from the constructor, is used <br>
  Standard_EXPORT     void SetG0Criterion(const Standard_Real TolDist) ;
  
//! Allows you to set the G1 criterion. This is the law <br>
//! defining the greatest angle allowed between the <br>
//! constraint and the target surface. If this criterion is not <br>
//! set, TolAng, the angular tolerance from the constructor, is used. <br>
//! Raises   ConstructionError  if  the  point  is  not  on  the  surface <br>
  Standard_EXPORT     void SetG1Criterion(const Standard_Real TolAng) ;
  
//! Allows you to set the G2 criterion. This is the law <br>
//! defining the greatest difference in curvature allowed <br>
//! between the constraint and the target surface. If this <br>
//! criterion is not set, TolCurv, the curvature tolerance from <br>
//! the constructor, is used. <br>
//! Raises   ConstructionError if  the  point  is  not  on  the  surface <br>
  Standard_EXPORT     void SetG2Criterion(const Standard_Real TolCurv) ;
  
//! Returns the G0 criterion. This is the greatest distance <br>
//! allowed between the constraint and the target surface. <br>
  Standard_EXPORT     Standard_Real G0Criterion() const;
  
//! Returns the G1 criterion. This is the greatest angle <br>
//! allowed between the constraint and the target surface. <br>
//! Raises   ConstructionError if  the  point  is  not  on  the  surface. <br>
  Standard_EXPORT     Standard_Real G1Criterion() const;
  
//! Returns the G2 criterion. This is the greatest difference <br>
//! in curvature allowed between the constraint and the target surface. <br>
//! Raises   ConstructionError if  the  point  is  not  on  the  surface <br>
  Standard_EXPORT     Standard_Real G2Criterion() const;
  
  Standard_EXPORT     void D0(gp_Pnt& P) const;
  
  Standard_EXPORT     void D1(gp_Pnt& P,gp_Vec& V1,gp_Vec& V2) const;
  
  Standard_EXPORT     void D2(gp_Pnt& P,gp_Vec& V1,gp_Vec& V2,gp_Vec& V3,gp_Vec& V4,gp_Vec& V5) const;
  
  Standard_EXPORT     Standard_Boolean HasPnt2dOnSurf() const;
  
  Standard_EXPORT     void SetPnt2dOnSurf(const gp_Pnt2d& Pnt) ;
  
  Standard_EXPORT     gp_Pnt2d Pnt2dOnSurf() const;
  
  Standard_EXPORT     GeomLProp_SLProps& LPropSurf() ;




  DEFINE_STANDARD_RTTI(GeomPlate_PointConstraint)

protected:


Standard_Integer myOrder;


private: 


GeomLProp_SLProps myLProp;
gp_Pnt myPoint;
gp_Pnt2d myPt2d;
Handle_Geom_Surface mySurf;
gp_Vec myD11;
gp_Vec myD12;
gp_Vec myD21;
gp_Vec myD22;
gp_Vec myD23;
Standard_Real myU;
Standard_Real myV;
Standard_Real myTolDist;
Standard_Real myTolAng;
Standard_Real myTolCurv;
Standard_Boolean hasPnt2dOnSurf;


};





// other Inline functions and methods (like "C++: function call" methods)


#endif
