/*
 * Decompiled with CFR 0.152.
 */
package org.chefproject.util;

import org.apache.turbine.services.pull.ApplicationTool;
import org.apache.turbine.util.Log;
import org.chefproject.exception.IdInvalidException;
import org.chefproject.util.Blob;
import org.chefproject.util.Reference;

public class Validator
implements ApplicationTool {
    protected static final String INVALID = "/\\%";
    protected static final String INVALID_MSG = " cannot contain any of the following characters: / \\ %";
    protected static final String BLANK_MSG = " cannot be blank";
    protected static final String ESCAPE_URL = "$&+,:;=?@ '\"<>#%{}|\\^~[]`";

    public static void checkResourceId(String id) throws IdInvalidException {
        if (id == null) {
            throw new IdInvalidException(BLANK_MSG);
        }
        if (id.trim().length() == 0) {
            throw new IdInvalidException(BLANK_MSG);
        }
        int i = 0;
        while (i < id.length()) {
            if (INVALID.indexOf(id.charAt(i)) != -1) {
                throw new IdInvalidException(INVALID_MSG);
            }
            ++i;
        }
    }

    public static void checkResourceRef(String ref) throws IdInvalidException {
        Reference r = new Reference(ref);
        String id = r.getId();
        if (id == null) {
            throw new IdInvalidException(BLANK_MSG);
        }
        if (id.trim().length() == 0) {
            throw new IdInvalidException(BLANK_MSG);
        }
        int i = 0;
        while (i < id.length()) {
            if (INVALID.indexOf(id.charAt(i)) != -1) {
                throw new IdInvalidException(INVALID_MSG);
            }
            ++i;
        }
    }

    public static String escapeUrl(String id) {
        if (id == null) {
            return "";
        }
        try {
            byte[] bytes = id.getBytes("UTF-8");
            StringBuffer buf = new StringBuffer();
            int i = 0;
            while (i < bytes.length) {
                byte b = bytes[i];
                if (ESCAPE_URL.indexOf((char)b) != -1 || b <= 31 || b == 127 || b >= 128) {
                    buf.append("%");
                    buf.append(Blob.toHex(b));
                } else {
                    buf.append((char)b);
                }
                ++i;
            }
            String rv = buf.toString();
            return rv;
        }
        catch (Exception e) {
            Log.warn("chef", "Validator.escapeUrl: ", (Throwable)e);
            return id;
        }
    }

    public static String escapeResourceName(String id) {
        if (id == null) {
            return "";
        }
        try {
            StringBuffer buf = new StringBuffer();
            int i = 0;
            while (i < id.length()) {
                char c = id.charAt(i);
                if (INVALID.indexOf(c) != -1) {
                    buf.append('_');
                } else {
                    buf.append(c);
                }
                ++i;
            }
            String rv = buf.toString();
            return rv;
        }
        catch (Exception e) {
            Log.warn("chef", "Validator.escapeResourceName: ", (Throwable)e);
            return id;
        }
    }

    public static String escapeSql(String value) {
        if (value == null) {
            return "";
        }
        try {
            StringBuffer buf = new StringBuffer();
            int i = 0;
            while (i < value.length()) {
                char c = value.charAt(i);
                if (c == '\'') {
                    buf.append("''");
                } else {
                    buf.append(c);
                }
                ++i;
            }
            String rv = buf.toString();
            return rv;
        }
        catch (Exception e) {
            Log.warn("chef", "Validator.escapeSql: ", (Throwable)e);
            return value;
        }
    }

    public static String escapeHtml(String value) {
        if (value == null) {
            return "";
        }
        try {
            StringBuffer buf = new StringBuffer();
            int i = 0;
            while (i < value.length()) {
                char c = value.charAt(i);
                switch (c) {
                    case '<': {
                        buf.append("&lt;");
                        break;
                    }
                    case '>': {
                        buf.append("&gt;");
                        break;
                    }
                    case '&': {
                        buf.append("&amp;");
                        break;
                    }
                    case '\"': {
                        buf.append("&quot;");
                        break;
                    }
                    case '\n': {
                        buf.append("<br/>");
                        break;
                    }
                    default: {
                        buf.append(c);
                    }
                }
                ++i;
            }
            String rv = buf.toString();
            return rv;
        }
        catch (Exception e) {
            Log.warn("chef", "Validator.escapeHtml: ", (Throwable)e);
            return value;
        }
    }

    public static String escapeJavascript(String value) {
        if (value == null) {
            return "";
        }
        try {
            StringBuffer buf = new StringBuffer();
            int i = 0;
            while (i < value.length()) {
                char c = value.charAt(i);
                if (c == '-') {
                    buf.append("x");
                } else {
                    buf.append(c);
                }
                ++i;
            }
            String rv = buf.toString();
            return rv;
        }
        catch (Exception e) {
            Log.warn("chef", "Validator.escapeJavascript: ", (Throwable)e);
            return value;
        }
    }

    public static String getFileName(String fullName) {
        StringBuffer buf = new StringBuffer();
        int index = fullName.length() - 1;
        while (index >= 0) {
            char c;
            if ((c = fullName.charAt(index--)) == '\\' || c == '/' || c == ':') break;
            buf.insert(0, c);
        }
        return buf.toString();
    }

    public static String getFileSizeWithDividor(String size) {
        StringBuffer newSize = new StringBuffer(size);
        int length = size.length();
        int index = size.length();
        while (index > 3) {
            newSize.insert(index -= 3, ",");
        }
        return newSize.toString();
    }

    public static String getFileExtension(String fullName) {
        int index = fullName.lastIndexOf(46);
        if (index == -1) {
            return "";
        }
        return fullName.substring(index + 1);
    }

    public static String limit(String value, Integer length) {
        StringBuffer buf = new StringBuffer(value);
        if (buf.length() > length) {
            buf.setLength(length);
            buf.append("...");
        }
        return buf.toString();
    }

    public void init(Object data) {
    }

    public void refresh() {
    }

    static {
        INVALID = INVALID;
        INVALID_MSG = INVALID_MSG;
        BLANK_MSG = BLANK_MSG;
        ESCAPE_URL = ESCAPE_URL;
    }
}

