/**
* @license Apache-2.0
*
* Copyright (c) 2018 The Stdlib Authors.
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*    http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

'use strict';

// MODULES //

var logger = require( 'debug' );
var objectKeys = require( './../../../../keys' );
var proc = require( './process.js' );
var db = require( './children.js' );


// VARIABLES //

var debug = logger( 'parallel:worker:close' );


// MAIN //

/**
* Closes all child processes.
*
* @private
*/
function close() { // eslint-disable-line stdlib/no-redeclare
	var keys;
	var pid;
	var i;

	debug( 'Killing all child processes...' );
	keys = objectKeys( db );
	for ( i = 0; i < keys.length; i++ ) {
		pid = keys[ i ];
		debug( 'Killing child process (pid: %d)...', pid );
		db[ pid ].kill();
		delete db[ pid ];
	}
	// Disconnect this process from the parent to allow this process to gracefully close:
	debug( 'Disconnecting worker from parent process...' );
	proc.disconnect();
}


// EXPORTS //

module.exports = close;
