---
id: fast-colors.colorxyz
title: ColorXYZ class
hide_title: true
---
<!-- Do not edit this file. It is automatically generated by API Documenter. -->

[@microsoft/fast-colors](./fast-colors.md) &gt; [ColorXYZ](./fast-colors.colorxyz.md)

## ColorXYZ class

[XYZ color space](https://en.wikipedia.org/wiki/CIE_1931_color_space)

This implementation uses the D65 constants for 2 degrees. That determines the constants used for the pure white point of the XYZ space of 0.95047, 1.0, 1.08883. [https://en.wikipedia.org/wiki/Illuminant\_D65](https://en.wikipedia.org/wiki/Illuminant_D65) These constants determine how the XYZ, LCH and LAB colors convert to/from RGB.

<b>Signature:</b>

```typescript
export declare class ColorXYZ 
```

## Constructors

|  Constructor | Modifiers | Description |
|  --- | --- | --- |
|  [(constructor)(x, y, z)](./fast-colors.colorxyz._constructor_.md) |  | Constructs a new instance of the <code>ColorXYZ</code> class |

## Properties

|  Property | Modifiers | Type | Description |
|  --- | --- | --- | --- |
|  [whitePoint](./fast-colors.colorxyz.whitepoint.md) | <code>static</code> | [ColorXYZ](./fast-colors.colorxyz.md) | D65 2 degree white point |
|  [x](./fast-colors.colorxyz.x.md) |  | number |  |
|  [y](./fast-colors.colorxyz.y.md) |  | number |  |
|  [z](./fast-colors.colorxyz.z.md) |  | number |  |

## Methods

|  Method | Modifiers | Description |
|  --- | --- | --- |
|  [equalValue(rhs)](./fast-colors.colorxyz.equalvalue.md) |  | Determines if a color is equal to another |
|  [fromObject(data)](./fast-colors.colorxyz.fromobject.md) | <code>static</code> | Construct a [ColorXYZ](./fast-colors.colorxyz.md) from a config object. |
|  [roundToPrecision(precision)](./fast-colors.colorxyz.roundtoprecision.md) |  | Returns a new [ColorXYZ](./fast-colors.colorxyz.md) rounded to the provided precision |
|  [toObject()](./fast-colors.colorxyz.toobject.md) |  | Returns the [ColorXYZ](./fast-colors.colorxyz.md) formatted as an object. |
