/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.om;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import net.sf.saxon.Controller;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ReversibleIterator;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.AxisIterator;
import net.sf.saxon.om.AxisIteratorImpl;
import net.sf.saxon.om.EmptyIterator;
import net.sf.saxon.om.FastStringBuffer;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NamespaceCodeIterator;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.ReverseNodeArrayIterator;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SiblingCountingNode;
import net.sf.saxon.om.SingleNodeIterator;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.pattern.LocalNameTest;
import net.sf.saxon.pattern.NameTest;
import net.sf.saxon.pattern.NamespaceTest;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.pattern.NodeTestPattern;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.tinytree.TinyNodeImpl;
import net.sf.saxon.trans.XPathException;

public final class Navigator {
    private static int[] nodeCategories = new int[]{-1, 3, 2, 3, -1, -1, -1, 3, 3, 0, -1, -1, -1, 1};

    private Navigator() {
    }

    public static String getAttributeValue(NodeInfo element, String uri, String localName) {
        int fingerprint = element.getNamePool().allocate("", uri, localName);
        return element.getAttributeValue(fingerprint);
    }

    public static NodeTest makeNodeTest(NamePool pool, int nodeKind, String uri, String localName) {
        if (uri == null && localName == null) {
            return NodeKindTest.makeNodeKindTest(nodeKind);
        }
        if (uri == null) {
            return new LocalNameTest(pool, nodeKind, localName);
        }
        if (localName == null) {
            return new NamespaceTest(pool, nodeKind, uri);
        }
        int fp = pool.allocate("", uri, localName);
        return new NameTest(nodeKind, fp, pool);
    }

    public static String getBaseURI(NodeInfo node) {
        String xmlBase = node.getAttributeValue(385);
        if (xmlBase != null) {
            URI baseURI;
            try {
                baseURI = new URI(xmlBase);
                if (!baseURI.isAbsolute()) {
                    String parentSystemId;
                    NodeInfo parent = node.getParent();
                    if (parent == null) {
                        URI base = new URI(node.getSystemId());
                        URI resolved = xmlBase.length() == 0 ? base : base.resolve(baseURI);
                        return resolved.toString();
                    }
                    String startSystemId = node.getSystemId();
                    URI base = new URI(startSystemId.equals(parentSystemId = parent.getSystemId()) ? parent.getBaseURI() : startSystemId);
                    baseURI = xmlBase.length() == 0 ? base : base.resolve(baseURI);
                }
            }
            catch (URISyntaxException e) {
                return xmlBase;
            }
            return baseURI.toString();
        }
        String startSystemId = node.getSystemId();
        NodeInfo parent = node.getParent();
        if (parent == null) {
            return startSystemId;
        }
        String parentSystemId = parent.getSystemId();
        if (startSystemId.equals(parentSystemId)) {
            return parent.getBaseURI();
        }
        return startSystemId;
    }

    public static String getPath(NodeInfo node) {
        return Navigator.getPath(node, null);
    }

    public static String getPath(NodeInfo node, XPathContext context) {
        if (node == null) {
            return "";
        }
        NodeInfo parent = node.getParent();
        switch (node.getNodeKind()) {
            case 9: {
                return "/";
            }
            case 1: {
                if (parent == null) {
                    return node.getDisplayName();
                }
                String pre = Navigator.getPath(parent, context);
                if (pre.equals("/")) {
                    return '/' + node.getDisplayName();
                }
                try {
                    return pre + '/' + node.getDisplayName() + '[' + Navigator.getNumberSimple(node, context) + ']';
                }
                catch (UnsupportedOperationException e) {
                    return pre + '/' + node.getDisplayName();
                }
            }
            case 2: {
                return Navigator.getPath(parent, context) + "/@" + node.getDisplayName();
            }
            case 3: {
                String pre = Navigator.getPath(parent, context);
                return (pre.equals("/") ? "" : pre) + "/text()[" + Navigator.getNumberSimple(node, context) + ']';
            }
            case 8: {
                String pre = Navigator.getPath(parent, context);
                return (pre.equals("/") ? "" : pre) + "/comment()[" + Navigator.getNumberSimple(node, context) + ']';
            }
            case 7: {
                String pre = Navigator.getPath(parent, context);
                return (pre.equals("/") ? "" : pre) + "/processing-instruction()[" + Navigator.getNumberSimple(node, context) + ']';
            }
            case 13: {
                String test = node.getLocalPart();
                if (test.length() == 0) {
                    test = "*[not(local-name()]";
                }
                return Navigator.getPath(parent, context) + "/namespace::" + test;
            }
        }
        return "";
    }

    public static int getNumberSimple(NodeInfo node, XPathContext context) {
        NodeInfo prev;
        int fingerprint = node.getFingerprint();
        NodeTest same = fingerprint == -1 ? NodeKindTest.makeNodeKindTest(node.getNodeKind()) : new NameTest(node);
        Controller controller = context == null ? null : context.getController();
        AxisIterator preceding = node.iterateAxis((byte)11, same);
        int i = 1;
        while ((prev = (NodeInfo)preceding.next()) != null) {
            int memo;
            if (controller != null && (memo = controller.getRememberedNumber(prev)) > 0) {
                controller.setRememberedNumber(node, memo += i);
                return memo;
            }
            ++i;
        }
        if (controller != null) {
            controller.setRememberedNumber(node, i);
        }
        return i;
    }

    public static int getNumberSingle(NodeInfo node, Pattern count, Pattern from, XPathContext context) throws XPathException {
        if (count == null && from == null) {
            return Navigator.getNumberSimple(node, context);
        }
        boolean knownToMatch = false;
        if (count == null) {
            count = node.getFingerprint() == -1 ? new NodeTestPattern(NodeKindTest.makeNodeKindTest(node.getNodeKind())) : new NodeTestPattern(new NameTest(node));
            knownToMatch = true;
        }
        NodeInfo target = node;
        while (!knownToMatch && !count.matches(target, context)) {
            if ((target = target.getParent()) == null) {
                return 0;
            }
            if (from == null || !from.matches(target, context)) continue;
            return 0;
        }
        AxisIterator preceding = target.iterateAxis((byte)11, count.getNodeTest());
        boolean alreadyChecked = count instanceof NodeTestPattern;
        int i = 1;
        NodeInfo p;
        while ((p = (NodeInfo)preceding.next()) != null) {
            if (!alreadyChecked && !count.matches(p, context)) continue;
            ++i;
        }
        return i;
    }

    public static int getNumberAny(Expression inst, NodeInfo node, Pattern count, Pattern from, XPathContext context, boolean hasVariablesInPatterns) throws XPathException {
        NodeInfo prev;
        Object[] memo;
        boolean memoise;
        NodeInfo memoNode = null;
        int memoNumber = 0;
        Controller controller = context.getController();
        boolean bl = memoise = !hasVariablesInPatterns && from == null;
        if (memoise && (memo = (Object[])controller.getUserData(inst, "xsl:number")) != null) {
            memoNode = (NodeInfo)memo[0];
            memoNumber = (Integer)memo[1];
        }
        int num = 0;
        if (count == null) {
            count = node.getFingerprint() == -1 ? new NodeTestPattern(NodeKindTest.makeNodeKindTest(node.getNodeKind())) : new NodeTestPattern(new NameTest(node));
            num = 1;
        } else if (count.matches(node, context)) {
            num = 1;
        }
        NodeTest filter = from == null ? count.getNodeTest() : (from.getNodeKind() == 1 && count.getNodeKind() == 1 ? NodeKindTest.ELEMENT : AnyNodeTest.getInstance());
        if (from != null && from.matches(node, context)) {
            return num;
        }
        AxisIterator preceding = node.iterateAxis((byte)13, filter);
        boolean found = false;
        while ((prev = (NodeInfo)preceding.next()) != null) {
            if (count.matches(prev, context)) {
                if (num == 1 && memoNode != null && prev.isSameNodeInfo(memoNode)) {
                    num = memoNumber + 1;
                    found = true;
                    break;
                }
                ++num;
            }
            if (from == null || !from.matches(prev, context)) continue;
            found = true;
            break;
        }
        if (!found && from != null) {
            return 0;
        }
        if (memoise) {
            Object[] memo2 = new Object[]{node, new Integer(num)};
            controller.setUserData(inst, "xsl:number", memo2);
        }
        return num;
    }

    public static List getNumberMulti(NodeInfo node, Pattern count, Pattern from, XPathContext context) throws XPathException {
        ArrayList<Long> v = new ArrayList<Long>(5);
        if (count == null) {
            count = node.getFingerprint() == -1 ? new NodeTestPattern(NodeKindTest.makeNodeKindTest(node.getNodeKind())) : new NodeTestPattern(new NameTest(node));
        }
        NodeInfo curr = node;
        do {
            if (!count.matches(curr, context)) continue;
            int num = Navigator.getNumberSingle(curr, count, null, context);
            v.add(0, new Long(num));
        } while ((curr = curr.getParent()) != null && (from == null || !from.matches(curr, context)));
        return v;
    }

    public static void copy(NodeInfo node, Receiver out, NamePool namePool, int whichNamespaces, boolean copyAnnotations, int locationId) throws XPathException {
        switch (node.getNodeKind()) {
            case 9: {
                NodeInfo child;
                out.startDocument(0);
                AxisIterator children0 = node.iterateAxis((byte)3, AnyNodeTest.getInstance());
                while ((child = (NodeInfo)children0.next()) != null) {
                    child.copy(out, whichNamespaces, copyAnnotations, locationId);
                }
                out.endDocument();
                break;
            }
            case 1: {
                NodeInfo child;
                NodeInfo att;
                out.startElement(node.getNameCode(), copyAnnotations ? node.getTypeAnnotation() : 630, 0, 0);
                switch (whichNamespaces) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        int ns;
                        int[] localNamespaces = node.getDeclaredNamespaces(null);
                        for (int i = 0; i < localNamespaces.length && (ns = localNamespaces[i]) != -1; ++i) {
                            out.namespace(ns, 0);
                        }
                        break;
                    }
                    case 2: {
                        NamespaceCodeIterator.sendNamespaces(node, out);
                    }
                }
                AxisIterator attributes = node.iterateAxis((byte)2, AnyNodeTest.getInstance());
                while ((att = (NodeInfo)attributes.next()) != null) {
                    att.copy(out, whichNamespaces, copyAnnotations, locationId);
                }
                out.startContent();
                AxisIterator children = node.iterateAxis((byte)3, AnyNodeTest.getInstance());
                while ((child = (NodeInfo)children.next()) != null) {
                    child.copy(out, whichNamespaces, copyAnnotations, locationId);
                }
                out.endElement();
                return;
            }
            case 2: {
                out.attribute(node.getNameCode(), copyAnnotations ? node.getTypeAnnotation() : 631, node.getStringValueCS(), 0, 0);
                return;
            }
            case 3: {
                CharSequence value = node.getStringValueCS();
                if (value.length() != 0) {
                    out.characters(value, 0, 0);
                }
                return;
            }
            case 8: {
                out.comment(node.getStringValueCS(), 0, 0);
                return;
            }
            case 7: {
                out.processingInstruction(node.getLocalPart(), node.getStringValueCS(), 0, 0);
                return;
            }
            case 13: {
                out.namespace(namePool.allocateNamespaceCode(node.getLocalPart(), node.getStringValue()), 0);
                return;
            }
        }
    }

    public static int compareOrder(SiblingCountingNode first, SiblingCountingNode second) {
        NodeInfo p1;
        if (first.isSameNodeInfo(second)) {
            return 0;
        }
        NodeInfo firstParent = first.getParent();
        if (firstParent == null) {
            return -1;
        }
        NodeInfo secondParent = second.getParent();
        if (secondParent == null) {
            return 1;
        }
        if (firstParent.isSameNodeInfo(secondParent)) {
            int cat2;
            int cat1 = nodeCategories[first.getNodeKind()];
            if (cat1 == (cat2 = nodeCategories[second.getNodeKind()])) {
                return first.getSiblingPosition() - second.getSiblingPosition();
            }
            return cat1 - cat2;
        }
        int depth1 = 0;
        int depth2 = 0;
        NodeInfo p2 = second;
        for (p1 = first; p1 != null; p1 = p1.getParent()) {
            ++depth1;
        }
        while (p2 != null) {
            ++depth2;
            p2 = p2.getParent();
        }
        p1 = first;
        while (depth1 > depth2) {
            if ((p1 = p1.getParent()).isSameNodeInfo(second)) {
                return 1;
            }
            --depth1;
        }
        p2 = second;
        while (depth2 > depth1) {
            if ((p2 = p2.getParent()).isSameNodeInfo(first)) {
                return -1;
            }
            --depth2;
        }
        while (true) {
            NodeInfo par1 = p1.getParent();
            NodeInfo par2 = p2.getParent();
            if (par1 == null || par2 == null) {
                throw new NullPointerException("Node order comparison - internal error");
            }
            if (par1.isSameNodeInfo(par2)) {
                if (p1.getNodeKind() == 2 && p2.getNodeKind() != 2) {
                    return -1;
                }
                if (p1.getNodeKind() != 2 && p2.getNodeKind() == 2) {
                    return 1;
                }
                return ((SiblingCountingNode)p1).getSiblingPosition() - ((SiblingCountingNode)p2).getSiblingPosition();
            }
            p1 = par1;
            p2 = par2;
        }
    }

    public static void appendSequentialKey(SiblingCountingNode node, FastStringBuffer sb, boolean addDocNr) {
        NodeInfo parent;
        if (addDocNr) {
            sb.append('w');
            sb.append(Long.toString(node.getDocumentNumber()));
        }
        if (node.getNodeKind() != 9 && (parent = node.getParent()) != null) {
            Navigator.appendSequentialKey((SiblingCountingNode)parent, sb, false);
        }
        sb.append(Navigator.alphaKey(node.getSiblingPosition()));
    }

    public static String alphaKey(int value) {
        if (value < 1) {
            return "a";
        }
        if (value < 10) {
            return "b" + value;
        }
        if (value < 100) {
            return "c" + value;
        }
        if (value < 1000) {
            return "d" + value;
        }
        if (value < 10000) {
            return "e" + value;
        }
        if (value < 100000) {
            return "f" + value;
        }
        if (value < 1000000) {
            return "g" + value;
        }
        if (value < 10000000) {
            return "h" + value;
        }
        if (value < 100000000) {
            return "i" + value;
        }
        if (value < 1000000000) {
            return "j" + value;
        }
        return "k" + value;
    }

    public static boolean isAncestorOrSelf(NodeInfo a, NodeInfo d) {
        if (a instanceof TinyNodeImpl) {
            if (d instanceof TinyNodeImpl) {
                return ((TinyNodeImpl)a).isAncestorOrSelf((TinyNodeImpl)d);
            }
            if (d.getNodeKind() != 13) {
                return false;
            }
        }
        for (NodeInfo p = d; p != null; p = p.getParent()) {
            if (!a.isSameNodeInfo(p)) continue;
            return true;
        }
        return false;
    }

    public static AxisIterator filteredSingleton(NodeInfo node, NodeTest nodeTest) {
        if (node != null && nodeTest.matches(node)) {
            return SingleNodeIterator.makeIterator(node);
        }
        return EmptyIterator.getInstance();
    }

    public static final class PrecedingEnumeration
    extends BaseEnumeration {
        private NodeInfo start;
        private AxisIterator ancestorEnum = null;
        private AxisIterator siblingEnum = null;
        private AxisIterator descendEnum = null;
        private boolean includeAncestors;

        public PrecedingEnumeration(NodeInfo start, boolean includeAncestors) {
            this.start = start;
            this.includeAncestors = includeAncestors;
            this.ancestorEnum = new AncestorEnumeration(start, false);
            switch (start.getNodeKind()) {
                case 1: 
                case 3: 
                case 7: 
                case 8: {
                    this.siblingEnum = start.iterateAxis((byte)11);
                    break;
                }
                default: {
                    this.siblingEnum = EmptyIterator.getInstance();
                }
            }
        }

        public void advance() {
            NodeInfo nexta;
            if (this.descendEnum != null) {
                NodeInfo nextd = (NodeInfo)this.descendEnum.next();
                if (nextd != null) {
                    this.current = nextd;
                    return;
                }
                this.descendEnum = null;
            }
            if (this.siblingEnum != null) {
                NodeInfo nexts = (NodeInfo)this.siblingEnum.next();
                if (nexts != null) {
                    if (nexts.hasChildNodes()) {
                        this.descendEnum = new DescendantEnumeration(nexts, true, false);
                        this.advance();
                    } else {
                        this.descendEnum = null;
                        this.current = nexts;
                    }
                    return;
                }
                this.descendEnum = null;
                this.siblingEnum = null;
            }
            if ((nexta = (NodeInfo)this.ancestorEnum.next()) != null) {
                this.current = nexta;
                NodeInfo n = this.current;
                this.siblingEnum = n.getNodeKind() == 9 ? EmptyIterator.getInstance() : n.iterateAxis((byte)11);
                if (!this.includeAncestors) {
                    this.advance();
                }
            } else {
                this.current = null;
            }
        }

        public SequenceIterator getAnother() {
            return new PrecedingEnumeration(this.start, this.includeAncestors);
        }
    }

    public static final class FollowingEnumeration
    extends BaseEnumeration {
        private NodeInfo start;
        private AxisIterator ancestorEnum = null;
        private AxisIterator siblingEnum = null;
        private AxisIterator descendEnum = null;

        public FollowingEnumeration(NodeInfo start) {
            this.start = start;
            this.ancestorEnum = new AncestorEnumeration(start, false);
            switch (start.getNodeKind()) {
                case 1: 
                case 3: 
                case 7: 
                case 8: {
                    this.siblingEnum = start.iterateAxis((byte)7);
                    break;
                }
                case 2: 
                case 13: {
                    NodeInfo parent = start.getParent();
                    if (parent == null) {
                        this.siblingEnum = EmptyIterator.getInstance();
                        break;
                    }
                    this.siblingEnum = parent.iterateAxis((byte)3);
                    break;
                }
                default: {
                    this.siblingEnum = EmptyIterator.getInstance();
                }
            }
        }

        public void advance() {
            NodeInfo nexta;
            if (this.descendEnum != null) {
                NodeInfo nextd = (NodeInfo)this.descendEnum.next();
                if (nextd != null) {
                    this.current = nextd;
                    return;
                }
                this.descendEnum = null;
            }
            if (this.siblingEnum != null) {
                NodeInfo nexts = (NodeInfo)this.siblingEnum.next();
                if (nexts != null) {
                    this.current = nexts;
                    NodeInfo n = this.current;
                    this.descendEnum = n.hasChildNodes() ? new DescendantEnumeration(n, false, true) : null;
                    return;
                }
                this.descendEnum = null;
                this.siblingEnum = null;
            }
            if ((nexta = (NodeInfo)this.ancestorEnum.next()) != null) {
                this.current = nexta;
                NodeInfo n = this.current;
                this.siblingEnum = n.getNodeKind() == 9 ? EmptyIterator.getInstance() : n.iterateAxis((byte)7);
                this.advance();
            } else {
                this.current = null;
            }
        }

        public SequenceIterator getAnother() {
            return new FollowingEnumeration(this.start);
        }
    }

    public static final class DescendantEnumeration
    extends BaseEnumeration {
        private AxisIterator children = null;
        private AxisIterator descendants = null;
        private NodeInfo start;
        private boolean includeSelf;
        private boolean forwards;
        private boolean atEnd = false;

        public DescendantEnumeration(NodeInfo start, boolean includeSelf, boolean forwards) {
            this.start = start;
            this.includeSelf = includeSelf;
            this.forwards = forwards;
        }

        public void advance() {
            if (this.descendants != null) {
                NodeInfo nextd = (NodeInfo)this.descendants.next();
                if (nextd != null) {
                    this.current = nextd;
                    return;
                }
                this.descendants = null;
            }
            if (this.children != null) {
                NodeInfo n = (NodeInfo)this.children.next();
                if (n != null) {
                    if (n.hasChildNodes()) {
                        if (this.forwards) {
                            this.descendants = new DescendantEnumeration(n, false, this.forwards);
                            this.current = n;
                        } else {
                            this.descendants = new DescendantEnumeration(n, true, this.forwards);
                            this.advance();
                        }
                    } else {
                        this.current = n;
                    }
                } else if (this.forwards || !this.includeSelf) {
                    this.current = null;
                } else {
                    this.atEnd = true;
                    this.children = null;
                    this.current = this.start;
                }
            } else if (this.atEnd) {
                this.current = null;
            } else {
                if (this.start.hasChildNodes()) {
                    this.children = this.start.iterateAxis((byte)3);
                    if (!this.forwards) {
                        if (this.children instanceof ReversibleIterator) {
                            this.children = (AxisIterator)((ReversibleIterator)((Object)this.children)).getReverseIterator();
                        } else {
                            try {
                                Item n;
                                ArrayList<Item> list = new ArrayList<Item>(20);
                                AxisIterator forwards = this.start.iterateAxis((byte)3);
                                while ((n = forwards.next()) != null) {
                                    list.add(n);
                                }
                                Item[] nodes = new NodeInfo[list.size()];
                                nodes = list.toArray(nodes);
                                this.children = new ReverseNodeArrayIterator(nodes, 0, nodes.length);
                            }
                            catch (XPathException e) {
                                throw new AssertionError((Object)("Internal error in Navigator#descendantEnumeration: " + e.getMessage()));
                            }
                        }
                    }
                } else {
                    this.children = EmptyIterator.getInstance();
                }
                if (this.forwards && this.includeSelf) {
                    this.current = this.start;
                } else {
                    this.advance();
                }
            }
        }

        public SequenceIterator getAnother() {
            return new DescendantEnumeration(this.start, this.includeSelf, this.forwards);
        }
    }

    public static final class AncestorEnumeration
    extends BaseEnumeration {
        private boolean includeSelf;
        private boolean atStart;
        private NodeInfo start;

        public AncestorEnumeration(NodeInfo start, boolean includeSelf) {
            this.start = start;
            this.includeSelf = includeSelf;
            this.current = start;
            this.atStart = true;
        }

        public void advance() {
            if (this.atStart) {
                this.atStart = false;
                if (this.includeSelf) {
                    return;
                }
            }
            this.current = this.current == null ? null : this.current.getParent();
        }

        public SequenceIterator getAnother() {
            return new AncestorEnumeration(this.start, this.includeSelf);
        }
    }

    public static abstract class BaseEnumeration
    extends AxisIteratorImpl {
        public final Item next() {
            this.advance();
            this.position = this.current == null ? -1 : ++this.position;
            return this.current;
        }

        public abstract void advance();

        public abstract SequenceIterator getAnother();
    }

    public static class EmptyTextFilter
    extends AxisIteratorImpl {
        private AxisIterator base;

        public EmptyTextFilter(AxisIterator base) {
            this.base = base;
            this.position = 0;
        }

        public Item next() {
            do {
                this.current = (NodeInfo)this.base.next();
                if (this.current != null) continue;
                this.position = -1;
                return null;
            } while (this.current.getNodeKind() == 3 && this.current.getStringValueCS().length() == 0);
            ++this.position;
            return this.current;
        }

        public SequenceIterator getAnother() {
            return new EmptyTextFilter((AxisIterator)this.base.getAnother());
        }
    }

    public static class AxisFilter
    extends AxisIteratorImpl {
        private AxisIterator base;
        private NodeTest nodeTest;

        public AxisFilter(AxisIterator base, NodeTest test) {
            this.base = base;
            this.nodeTest = test;
            this.position = 0;
        }

        public Item next() {
            do {
                this.current = (NodeInfo)this.base.next();
                if (this.current != null) continue;
                this.position = -1;
                return null;
            } while (!this.nodeTest.matches(this.current));
            ++this.position;
            return this.current;
        }

        public SequenceIterator getAnother() {
            return new AxisFilter((AxisIterator)this.base.getAnother(), this.nodeTest);
        }
    }
}

