/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2010 Oracle and/or its affiliates. All rights reserved.
 *
 * Oracle and Java are registered trademarks of Oracle and/or its affiliates.
 * Other names may be trademarks of their respective owners.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */
package org.netbeans.test.j2ee.wizard;

import junit.framework.Test;
import org.netbeans.jellytools.modules.j2ee.J2eeTestCase;
import org.netbeans.junit.NbModuleSuite;
import org.netbeans.junit.NbTestSuite;
import org.netbeans.test.j2ee.libraries.LibraryTest;

/**
 *
 * @author jungi, Jiri Skrivanek
 */
public class MultiSrcRootModsWizardsTest extends J2eeTestCase {

    /** Creates a new instance of MultiSrcRootModsWizardsTest */
    public MultiSrcRootModsWizardsTest(String s) {
        super(s);
    }

    public static Test suite() {
        NbModuleSuite.Configuration conf = NbModuleSuite.emptyConfiguration();
        addServerTests(Server.GLASSFISH, conf);//register server
        if (isRegistered(Server.GLASSFISH)) {
            conf = conf.addTest(Suite.class);
        }
        conf = conf.enableModules(".*").clusters(".*");
        return NbModuleSuite.create(conf);
    }

    public static class Suite extends NbTestSuite {

        public Suite() {
            super();
            addTest(new NewFileWizardsTest("testOpenEjbMultiRootProject", "1.4"));
            addTest(new NewFileWizardsTest("testMultiLocalSessionBean", "1.4"));
            addTest(new NewFileWizardsTest("testMultiRemoteSessionBean", "1.4"));
            addTest(new NewFileWizardsTest("testMultiLocalRemoteSessionBean", "1.4"));
            addTest(new NewFileWizardsTest("testMultiLocalStatefulSessionBean", "1.4"));
            addTest(new NewFileWizardsTest("testMultiRemoteStatefulSessionBean", "1.4"));
            addTest(new NewFileWizardsTest("testMultiLocalRemoteStatefulSessionBean", "1.4"));
            addTest(new NewFileWizardsTest("testMultiLocalEntityBean", "1.4"));
            addTest(new NewFileWizardsTest("testMultiRemoteEntityBean", "1.4"));
            addTest(new NewFileWizardsTest("testMultiLocalRemoteEntityBean", "1.4"));
            addTest(new NewFileWizardsTest("testMultiQueueMdbBean", "1.4"));
            addTest(new NewFileWizardsTest("testMultiTopicMdbBean", "1.4"));
            addTest(new NewFileWizardsTest("testMultiServiceLocatorInEjb", "1.4"));
            addTest(new NewFileWizardsTest("testMultiCachingServiceLocatorInEjb", "1.4"));
            addTest(new NewFileWizardsTest("testBuildEjbMultiRootProject", "1.4"));

            addTest(new NewFileWizardsTest("testOpenWebMultiRootProject", "1.4"));
            addTest(new NewFileWizardsTest("testMultiServletInWeb", "1.4"));
            addTest(new NewFileWizardsTest("testMultiServiceLocatorInWeb", "1.4"));
            addTest(new NewFileWizardsTest("testMultiCachingServiceLocatorInWeb", "1.4"));

            addTest(new NewFileWizardsTest("testBuildWebMultiRootProject", "1.4"));

            addTest(new LibraryTest("testDD"));
            addTest(new LibraryTest("testDDMs"));
        }
    }
}
