"""This module contains the colormap dictionaries for BOP lookup tables taken
from https://github.com/cleterrier/ChrisLUTs. To make it compatible with napari's
colormap classes, all the values in the colormap are normalized (divide by 255).
"""

from napari.utils.translations import trans

bop_blue = [
    [0.0, 0.0, 0.0],
    [0.0, 0.0, 0.0],
    [0.0, 0.00392156862745098, 0.00392156862745098],
    [0.0, 0.00784313725490196, 0.00784313725490196],
    [0.0, 0.00784313725490196, 0.011764705882352941],
    [0.0, 0.011764705882352941, 0.01568627450980392],
    [0.0, 0.01568627450980392, 0.0196078431372549],
    [0.0, 0.01568627450980392, 0.023529411764705882],
    [0.00392156862745098, 0.0196078431372549, 0.027450980392156862],
    [0.00392156862745098, 0.023529411764705882, 0.03137254901960784],
    [0.00392156862745098, 0.023529411764705882, 0.03529411764705882],
    [0.00392156862745098, 0.027450980392156862, 0.0392156862745098],
    [0.00392156862745098, 0.03137254901960784, 0.043137254901960784],
    [0.00392156862745098, 0.03137254901960784, 0.047058823529411764],
    [0.00392156862745098, 0.03529411764705882, 0.050980392156862744],
    [0.00392156862745098, 0.0392156862745098, 0.054901960784313725],
    [0.00784313725490196, 0.0392156862745098, 0.058823529411764705],
    [0.00784313725490196, 0.043137254901960784, 0.06274509803921569],
    [0.00784313725490196, 0.047058823529411764, 0.06666666666666667],
    [0.00784313725490196, 0.047058823529411764, 0.07058823529411765],
    [0.00784313725490196, 0.050980392156862744, 0.07450980392156863],
    [0.00784313725490196, 0.054901960784313725, 0.0784313725490196],
    [0.00784313725490196, 0.054901960784313725, 0.08235294117647059],
    [0.00784313725490196, 0.058823529411764705, 0.08627450980392157],
    [0.011764705882352941, 0.06274509803921569, 0.09019607843137255],
    [0.011764705882352941, 0.06274509803921569, 0.09411764705882353],
    [0.011764705882352941, 0.06666666666666667, 0.09803921568627451],
    [0.011764705882352941, 0.07058823529411765, 0.10196078431372549],
    [0.011764705882352941, 0.07058823529411765, 0.10588235294117647],
    [0.011764705882352941, 0.07450980392156863, 0.10980392156862745],
    [0.011764705882352941, 0.0784313725490196, 0.11372549019607843],
    [0.011764705882352941, 0.0784313725490196, 0.11764705882352941],
    [0.01568627450980392, 0.08235294117647059, 0.12156862745098039],
    [0.01568627450980392, 0.08627450980392157, 0.12156862745098039],
    [0.01568627450980392, 0.08627450980392157, 0.12549019607843137],
    [0.01568627450980392, 0.09019607843137255, 0.12941176470588237],
    [0.01568627450980392, 0.09411764705882353, 0.13333333333333333],
    [0.01568627450980392, 0.09803921568627451, 0.13725490196078433],
    [0.01568627450980392, 0.09803921568627451, 0.1411764705882353],
    [0.01568627450980392, 0.10196078431372549, 0.1450980392156863],
    [0.0196078431372549, 0.10588235294117647, 0.14901960784313725],
    [0.0196078431372549, 0.10588235294117647, 0.15294117647058825],
    [0.0196078431372549, 0.10980392156862745, 0.1568627450980392],
    [0.0196078431372549, 0.11372549019607843, 0.1607843137254902],
    [0.0196078431372549, 0.11372549019607843, 0.16470588235294117],
    [0.0196078431372549, 0.11764705882352941, 0.16862745098039217],
    [0.0196078431372549, 0.12156862745098039, 0.17254901960784313],
    [0.0196078431372549, 0.12156862745098039, 0.17647058823529413],
    [0.023529411764705882, 0.12549019607843137, 0.1803921568627451],
    [0.023529411764705882, 0.12941176470588237, 0.1843137254901961],
    [0.023529411764705882, 0.12941176470588237, 0.18823529411764706],
    [0.023529411764705882, 0.13333333333333333, 0.19215686274509805],
    [0.023529411764705882, 0.13725490196078433, 0.19607843137254902],
    [0.023529411764705882, 0.13725490196078433, 0.2],
    [0.023529411764705882, 0.1411764705882353, 0.20392156862745098],
    [0.023529411764705882, 0.1450980392156863, 0.20784313725490197],
    [0.027450980392156862, 0.1450980392156863, 0.21176470588235294],
    [0.027450980392156862, 0.14901960784313725, 0.21568627450980393],
    [0.027450980392156862, 0.15294117647058825, 0.2196078431372549],
    [0.027450980392156862, 0.15294117647058825, 0.2235294117647059],
    [0.027450980392156862, 0.1568627450980392, 0.22745098039215686],
    [0.027450980392156862, 0.1607843137254902, 0.23137254901960785],
    [0.027450980392156862, 0.1607843137254902, 0.23529411764705882],
    [0.027450980392156862, 0.16470588235294117, 0.23921568627450981],
    [0.03137254901960784, 0.16862745098039217, 0.24313725490196078],
    [0.03137254901960784, 0.16862745098039217, 0.24313725490196078],
    [0.03137254901960784, 0.17254901960784313, 0.24705882352941178],
    [0.03137254901960784, 0.17647058823529413, 0.25098039215686274],
    [0.03137254901960784, 0.17647058823529413, 0.2549019607843137],
    [0.03137254901960784, 0.1803921568627451, 0.25882352941176473],
    [0.03137254901960784, 0.1843137254901961, 0.2627450980392157],
    [0.03137254901960784, 0.1843137254901961, 0.26666666666666666],
    [0.03529411764705882, 0.18823529411764706, 0.27058823529411763],
    [0.03529411764705882, 0.19215686274509805, 0.27450980392156865],
    [0.03529411764705882, 0.19607843137254902, 0.2784313725490196],
    [0.03529411764705882, 0.19607843137254902, 0.2823529411764706],
    [0.03529411764705882, 0.2, 0.28627450980392155],
    [0.03529411764705882, 0.20392156862745098, 0.2901960784313726],
    [0.03529411764705882, 0.20392156862745098, 0.29411764705882354],
    [0.03529411764705882, 0.20784313725490197, 0.2980392156862745],
    [0.0392156862745098, 0.21176470588235294, 0.30196078431372547],
    [0.0392156862745098, 0.21176470588235294, 0.3058823529411765],
    [0.0392156862745098, 0.21568627450980393, 0.30980392156862746],
    [0.0392156862745098, 0.2196078431372549, 0.3137254901960784],
    [0.0392156862745098, 0.2196078431372549, 0.3176470588235294],
    [0.0392156862745098, 0.2235294117647059, 0.3215686274509804],
    [0.0392156862745098, 0.22745098039215686, 0.3254901960784314],
    [0.0392156862745098, 0.22745098039215686, 0.32941176470588235],
    [0.043137254901960784, 0.23137254901960785, 0.3333333333333333],
    [0.043137254901960784, 0.23529411764705882, 0.33725490196078434],
    [0.043137254901960784, 0.23529411764705882, 0.3411764705882353],
    [0.043137254901960784, 0.23921568627450981, 0.34509803921568627],
    [0.043137254901960784, 0.24313725490196078, 0.34901960784313724],
    [0.043137254901960784, 0.24313725490196078, 0.35294117647058826],
    [0.043137254901960784, 0.24705882352941178, 0.3568627450980392],
    [0.043137254901960784, 0.25098039215686274, 0.3607843137254902],
    [0.047058823529411764, 0.25098039215686274, 0.36470588235294116],
    [0.047058823529411764, 0.2549019607843137, 0.36470588235294116],
    [0.047058823529411764, 0.25882352941176473, 0.3686274509803922],
    [0.047058823529411764, 0.25882352941176473, 0.37254901960784315],
    [0.047058823529411764, 0.2627450980392157, 0.3764705882352941],
    [0.047058823529411764, 0.26666666666666666, 0.3803921568627451],
    [0.047058823529411764, 0.26666666666666666, 0.3843137254901961],
    [0.047058823529411764, 0.27058823529411763, 0.38823529411764707],
    [0.050980392156862744, 0.27450980392156865, 0.39215686274509803],
    [0.050980392156862744, 0.27450980392156865, 0.396078431372549],
    [0.050980392156862744, 0.2784313725490196, 0.4],
    [0.050980392156862744, 0.2823529411764706, 0.403921568627451],
    [0.050980392156862744, 0.2823529411764706, 0.40784313725490196],
    [0.050980392156862744, 0.28627450980392155, 0.4117647058823529],
    [0.050980392156862744, 0.2901960784313726, 0.41568627450980394],
    [0.050980392156862744, 0.29411764705882354, 0.4196078431372549],
    [0.054901960784313725, 0.29411764705882354, 0.4235294117647059],
    [0.054901960784313725, 0.2980392156862745, 0.42745098039215684],
    [0.054901960784313725, 0.30196078431372547, 0.43137254901960786],
    [0.054901960784313725, 0.30196078431372547, 0.43529411764705883],
    [0.054901960784313725, 0.3058823529411765, 0.4392156862745098],
    [0.054901960784313725, 0.30980392156862746, 0.44313725490196076],
    [0.054901960784313725, 0.30980392156862746, 0.4470588235294118],
    [0.054901960784313725, 0.3137254901960784, 0.45098039215686275],
    [0.058823529411764705, 0.3176470588235294, 0.4549019607843137],
    [0.058823529411764705, 0.3176470588235294, 0.4588235294117647],
    [0.058823529411764705, 0.3215686274509804, 0.4627450980392157],
    [0.058823529411764705, 0.3254901960784314, 0.4666666666666667],
    [0.058823529411764705, 0.3254901960784314, 0.47058823529411764],
    [0.058823529411764705, 0.32941176470588235, 0.4745098039215686],
    [0.058823529411764705, 0.3333333333333333, 0.47843137254901963],
    [0.058823529411764705, 0.3333333333333333, 0.4823529411764706],
    [0.06274509803921569, 0.33725490196078434, 0.48627450980392156],
    [0.06274509803921569, 0.3411764705882353, 0.48627450980392156],
    [0.06274509803921569, 0.3411764705882353, 0.49019607843137253],
    [0.06274509803921569, 0.34509803921568627, 0.49411764705882355],
    [0.06274509803921569, 0.34901960784313724, 0.4980392156862745],
    [0.06274509803921569, 0.34901960784313724, 0.5019607843137255],
    [0.06274509803921569, 0.35294117647058826, 0.5058823529411764],
    [0.06274509803921569, 0.3568627450980392, 0.5098039215686274],
    [0.06666666666666667, 0.3568627450980392, 0.5137254901960784],
    [0.06666666666666667, 0.3607843137254902, 0.5176470588235295],
    [0.06666666666666667, 0.36470588235294116, 0.5215686274509804],
    [0.06666666666666667, 0.36470588235294116, 0.5254901960784314],
    [0.06666666666666667, 0.3686274509803922, 0.5294117647058824],
    [0.06666666666666667, 0.37254901960784315, 0.5333333333333333],
    [0.06666666666666667, 0.37254901960784315, 0.5372549019607843],
    [0.06666666666666667, 0.3764705882352941, 0.5411764705882353],
    [0.07058823529411765, 0.3803921568627451, 0.5450980392156862],
    [0.07058823529411765, 0.3803921568627451, 0.5490196078431373],
    [0.07058823529411765, 0.3843137254901961, 0.5529411764705883],
    [0.07058823529411765, 0.38823529411764707, 0.5568627450980392],
    [0.07058823529411765, 0.39215686274509803, 0.5607843137254902],
    [0.07058823529411765, 0.39215686274509803, 0.5647058823529412],
    [0.07058823529411765, 0.396078431372549, 0.5686274509803921],
    [0.07058823529411765, 0.4, 0.5725490196078431],
    [0.07450980392156863, 0.4, 0.5764705882352941],
    [0.07450980392156863, 0.403921568627451, 0.5803921568627451],
    [0.07450980392156863, 0.40784313725490196, 0.5843137254901961],
    [0.07450980392156863, 0.40784313725490196, 0.5882352941176471],
    [0.07450980392156863, 0.4117647058823529, 0.592156862745098],
    [0.07450980392156863, 0.41568627450980394, 0.596078431372549],
    [0.07450980392156863, 0.41568627450980394, 0.6],
    [0.07450980392156863, 0.4196078431372549, 0.6039215686274509],
    [0.0784313725490196, 0.4235294117647059, 0.6078431372549019],
    [0.0784313725490196, 0.4235294117647059, 0.6078431372549019],
    [0.0784313725490196, 0.42745098039215684, 0.611764705882353],
    [0.0784313725490196, 0.43137254901960786, 0.615686274509804],
    [0.0784313725490196, 0.43137254901960786, 0.6196078431372549],
    [0.0784313725490196, 0.43529411764705883, 0.6235294117647059],
    [0.0784313725490196, 0.4392156862745098, 0.6274509803921569],
    [0.0784313725490196, 0.4392156862745098, 0.6313725490196078],
    [0.08235294117647059, 0.44313725490196076, 0.6352941176470588],
    [0.08235294117647059, 0.4470588235294118, 0.6392156862745098],
    [0.08235294117647059, 0.4470588235294118, 0.6431372549019608],
    [0.08235294117647059, 0.45098039215686275, 0.6470588235294118],
    [0.08235294117647059, 0.4549019607843137, 0.6509803921568628],
    [0.08235294117647059, 0.4549019607843137, 0.6549019607843137],
    [0.08235294117647059, 0.4588235294117647, 0.6588235294117647],
    [0.08235294117647059, 0.4627450980392157, 0.6627450980392157],
    [0.08627450980392157, 0.4627450980392157, 0.6666666666666666],
    [0.08627450980392157, 0.4666666666666667, 0.6705882352941176],
    [0.08627450980392157, 0.47058823529411764, 0.6745098039215687],
    [0.08627450980392157, 0.47058823529411764, 0.6784313725490196],
    [0.08627450980392157, 0.4745098039215686, 0.6823529411764706],
    [0.08627450980392157, 0.47843137254901963, 0.6862745098039216],
    [0.08627450980392157, 0.47843137254901963, 0.6901960784313725],
    [0.08627450980392157, 0.4823529411764706, 0.6941176470588235],
    [0.09019607843137255, 0.48627450980392156, 0.6980392156862745],
    [0.09019607843137255, 0.49019607843137253, 0.7019607843137254],
    [0.09019607843137255, 0.49019607843137253, 0.7058823529411765],
    [0.09019607843137255, 0.49411764705882355, 0.7098039215686275],
    [0.09019607843137255, 0.4980392156862745, 0.7137254901960784],
    [0.09019607843137255, 0.4980392156862745, 0.7176470588235294],
    [0.09019607843137255, 0.5019607843137255, 0.7215686274509804],
    [0.09019607843137255, 0.5058823529411764, 0.7254901960784313],
    [0.09411764705882353, 0.5058823529411764, 0.7294117647058823],
    [0.09411764705882353, 0.5098039215686274, 0.7294117647058823],
    [0.09411764705882353, 0.5137254901960784, 0.7333333333333333],
    [0.09411764705882353, 0.5137254901960784, 0.7372549019607844],
    [0.09411764705882353, 0.5176470588235295, 0.7411764705882353],
    [0.09411764705882353, 0.5215686274509804, 0.7450980392156863],
    [0.09411764705882353, 0.5215686274509804, 0.7490196078431373],
    [0.09411764705882353, 0.5254901960784314, 0.7529411764705882],
    [0.09803921568627451, 0.5294117647058824, 0.7568627450980392],
    [0.09803921568627451, 0.5294117647058824, 0.7607843137254902],
    [0.09803921568627451, 0.5333333333333333, 0.7647058823529411],
    [0.09803921568627451, 0.5372549019607843, 0.7686274509803922],
    [0.09803921568627451, 0.5372549019607843, 0.7725490196078432],
    [0.09803921568627451, 0.5411764705882353, 0.7764705882352941],
    [0.09803921568627451, 0.5450980392156862, 0.7803921568627451],
    [0.09803921568627451, 0.5450980392156862, 0.7843137254901961],
    [0.10196078431372549, 0.5490196078431373, 0.788235294117647],
    [0.10196078431372549, 0.5529411764705883, 0.792156862745098],
    [0.10196078431372549, 0.5529411764705883, 0.796078431372549],
    [0.10196078431372549, 0.5568627450980392, 0.8],
    [0.10196078431372549, 0.5607843137254902, 0.803921568627451],
    [0.10196078431372549, 0.5607843137254902, 0.807843137254902],
    [0.10196078431372549, 0.5647058823529412, 0.8117647058823529],
    [0.10196078431372549, 0.5686274509803921, 0.8156862745098039],
    [0.10588235294117647, 0.5686274509803921, 0.8196078431372549],
    [0.10588235294117647, 0.5725490196078431, 0.8235294117647058],
    [0.10588235294117647, 0.5764705882352941, 0.8274509803921568],
    [0.10588235294117647, 0.5764705882352941, 0.8313725490196079],
    [0.10588235294117647, 0.5803921568627451, 0.8352941176470589],
    [0.10588235294117647, 0.5843137254901961, 0.8392156862745098],
    [0.10588235294117647, 0.5882352941176471, 0.8431372549019608],
    [0.10588235294117647, 0.5882352941176471, 0.8470588235294118],
    [0.10980392156862745, 0.592156862745098, 0.8509803921568627],
    [0.10980392156862745, 0.596078431372549, 0.8509803921568627],
    [0.10980392156862745, 0.596078431372549, 0.8549019607843137],
    [0.10980392156862745, 0.6, 0.8588235294117647],
    [0.10980392156862745, 0.6039215686274509, 0.8627450980392157],
    [0.10980392156862745, 0.6039215686274509, 0.8666666666666667],
    [0.10980392156862745, 0.6078431372549019, 0.8705882352941177],
    [0.10980392156862745, 0.611764705882353, 0.8745098039215686],
    [0.11372549019607843, 0.611764705882353, 0.8784313725490196],
    [0.11372549019607843, 0.615686274509804, 0.8823529411764706],
    [0.11372549019607843, 0.6196078431372549, 0.8862745098039215],
    [0.11372549019607843, 0.6196078431372549, 0.8901960784313725],
    [0.11372549019607843, 0.6235294117647059, 0.8941176470588236],
    [0.11372549019607843, 0.6274509803921569, 0.8980392156862745],
    [0.11372549019607843, 0.6274509803921569, 0.9019607843137255],
    [0.11372549019607843, 0.6313725490196078, 0.9058823529411765],
    [0.11764705882352941, 0.6352941176470588, 0.9098039215686274],
    [0.11764705882352941, 0.6352941176470588, 0.9137254901960784],
    [0.11764705882352941, 0.6392156862745098, 0.9176470588235294],
    [0.11764705882352941, 0.6431372549019608, 0.9215686274509803],
    [0.11764705882352941, 0.6431372549019608, 0.9254901960784314],
    [0.11764705882352941, 0.6470588235294118, 0.9294117647058824],
    [0.11764705882352941, 0.6509803921568628, 0.9333333333333333],
    [0.11764705882352941, 0.6509803921568628, 0.9372549019607843],
    [0.12156862745098039, 0.6549019607843137, 0.9411764705882353],
    [0.12156862745098039, 0.6588235294117647, 0.9450980392156862],
    [0.12156862745098039, 0.6588235294117647, 0.9490196078431372],
    [0.12156862745098039, 0.6627450980392157, 0.9529411764705882],
    [0.12156862745098039, 0.6666666666666666, 0.9568627450980393],
    [0.12156862745098039, 0.6666666666666666, 0.9607843137254902],
    [0.12156862745098039, 0.6705882352941176, 0.9647058823529412],
    [0.12549019607843137, 0.6784313725490196, 0.9725490196078431],
]


bop_orange = [
    [0.0, 0.0, 0.0],
    [0.0, 0.0, 0.0],
    [0.00392156862745098, 0.00392156862745098, 0.0],
    [0.00784313725490196, 0.00784313725490196, 0.0],
    [0.011764705882352941, 0.00784313725490196, 0.0],
    [0.01568627450980392, 0.011764705882352941, 0.0],
    [0.0196078431372549, 0.01568627450980392, 0.0],
    [0.023529411764705882, 0.01568627450980392, 0.0],
    [0.027450980392156862, 0.0196078431372549, 0.00392156862745098],
    [0.03137254901960784, 0.023529411764705882, 0.00392156862745098],
    [0.03529411764705882, 0.023529411764705882, 0.00392156862745098],
    [0.0392156862745098, 0.027450980392156862, 0.00392156862745098],
    [0.043137254901960784, 0.03137254901960784, 0.00392156862745098],
    [0.047058823529411764, 0.03137254901960784, 0.00392156862745098],
    [0.050980392156862744, 0.03529411764705882, 0.00392156862745098],
    [0.054901960784313725, 0.0392156862745098, 0.00392156862745098],
    [0.058823529411764705, 0.0392156862745098, 0.00784313725490196],
    [0.06274509803921569, 0.043137254901960784, 0.00784313725490196],
    [0.06666666666666667, 0.047058823529411764, 0.00784313725490196],
    [0.07058823529411765, 0.047058823529411764, 0.00784313725490196],
    [0.07450980392156863, 0.050980392156862744, 0.00784313725490196],
    [0.0784313725490196, 0.054901960784313725, 0.00784313725490196],
    [0.08235294117647059, 0.054901960784313725, 0.00784313725490196],
    [0.08627450980392157, 0.058823529411764705, 0.00784313725490196],
    [0.09019607843137255, 0.06274509803921569, 0.011764705882352941],
    [0.09411764705882353, 0.06274509803921569, 0.011764705882352941],
    [0.09803921568627451, 0.06666666666666667, 0.011764705882352941],
    [0.10196078431372549, 0.07058823529411765, 0.011764705882352941],
    [0.10588235294117647, 0.07058823529411765, 0.011764705882352941],
    [0.10980392156862745, 0.07450980392156863, 0.011764705882352941],
    [0.11372549019607843, 0.0784313725490196, 0.011764705882352941],
    [0.11764705882352941, 0.0784313725490196, 0.011764705882352941],
    [0.12156862745098039, 0.08235294117647059, 0.01568627450980392],
    [0.12156862745098039, 0.08627450980392157, 0.01568627450980392],
    [0.12549019607843137, 0.08627450980392157, 0.01568627450980392],
    [0.12941176470588237, 0.09019607843137255, 0.01568627450980392],
    [0.13333333333333333, 0.09411764705882353, 0.01568627450980392],
    [0.13725490196078433, 0.09803921568627451, 0.01568627450980392],
    [0.1411764705882353, 0.09803921568627451, 0.01568627450980392],
    [0.1450980392156863, 0.10196078431372549, 0.01568627450980392],
    [0.14901960784313725, 0.10588235294117647, 0.0196078431372549],
    [0.15294117647058825, 0.10588235294117647, 0.0196078431372549],
    [0.1568627450980392, 0.10980392156862745, 0.0196078431372549],
    [0.1607843137254902, 0.11372549019607843, 0.0196078431372549],
    [0.16470588235294117, 0.11372549019607843, 0.0196078431372549],
    [0.16862745098039217, 0.11764705882352941, 0.0196078431372549],
    [0.17254901960784313, 0.12156862745098039, 0.0196078431372549],
    [0.17647058823529413, 0.12156862745098039, 0.0196078431372549],
    [0.1803921568627451, 0.12549019607843137, 0.023529411764705882],
    [0.1843137254901961, 0.12941176470588237, 0.023529411764705882],
    [0.18823529411764706, 0.12941176470588237, 0.023529411764705882],
    [0.19215686274509805, 0.13333333333333333, 0.023529411764705882],
    [0.19607843137254902, 0.13725490196078433, 0.023529411764705882],
    [0.2, 0.13725490196078433, 0.023529411764705882],
    [0.20392156862745098, 0.1411764705882353, 0.023529411764705882],
    [0.20784313725490197, 0.1450980392156863, 0.023529411764705882],
    [0.21176470588235294, 0.1450980392156863, 0.027450980392156862],
    [0.21568627450980393, 0.14901960784313725, 0.027450980392156862],
    [0.2196078431372549, 0.15294117647058825, 0.027450980392156862],
    [0.2235294117647059, 0.15294117647058825, 0.027450980392156862],
    [0.22745098039215686, 0.1568627450980392, 0.027450980392156862],
    [0.23137254901960785, 0.1607843137254902, 0.027450980392156862],
    [0.23529411764705882, 0.1607843137254902, 0.027450980392156862],
    [0.23921568627450981, 0.16470588235294117, 0.027450980392156862],
    [0.24313725490196078, 0.16862745098039217, 0.03137254901960784],
    [0.24313725490196078, 0.16862745098039217, 0.03137254901960784],
    [0.24705882352941178, 0.17254901960784313, 0.03137254901960784],
    [0.25098039215686274, 0.17647058823529413, 0.03137254901960784],
    [0.2549019607843137, 0.17647058823529413, 0.03137254901960784],
    [0.25882352941176473, 0.1803921568627451, 0.03137254901960784],
    [0.2627450980392157, 0.1843137254901961, 0.03137254901960784],
    [0.26666666666666666, 0.1843137254901961, 0.03137254901960784],
    [0.27058823529411763, 0.18823529411764706, 0.03529411764705882],
    [0.27450980392156865, 0.19215686274509805, 0.03529411764705882],
    [0.2784313725490196, 0.19607843137254902, 0.03529411764705882],
    [0.2823529411764706, 0.19607843137254902, 0.03529411764705882],
    [0.28627450980392155, 0.2, 0.03529411764705882],
    [0.2901960784313726, 0.20392156862745098, 0.03529411764705882],
    [0.29411764705882354, 0.20392156862745098, 0.03529411764705882],
    [0.2980392156862745, 0.20784313725490197, 0.03529411764705882],
    [0.30196078431372547, 0.21176470588235294, 0.0392156862745098],
    [0.3058823529411765, 0.21176470588235294, 0.0392156862745098],
    [0.30980392156862746, 0.21568627450980393, 0.0392156862745098],
    [0.3137254901960784, 0.2196078431372549, 0.0392156862745098],
    [0.3176470588235294, 0.2196078431372549, 0.0392156862745098],
    [0.3215686274509804, 0.2235294117647059, 0.0392156862745098],
    [0.3254901960784314, 0.22745098039215686, 0.0392156862745098],
    [0.32941176470588235, 0.22745098039215686, 0.0392156862745098],
    [0.3333333333333333, 0.23137254901960785, 0.043137254901960784],
    [0.33725490196078434, 0.23529411764705882, 0.043137254901960784],
    [0.3411764705882353, 0.23529411764705882, 0.043137254901960784],
    [0.34509803921568627, 0.23921568627450981, 0.043137254901960784],
    [0.34901960784313724, 0.24313725490196078, 0.043137254901960784],
    [0.35294117647058826, 0.24313725490196078, 0.043137254901960784],
    [0.3568627450980392, 0.24705882352941178, 0.043137254901960784],
    [0.3607843137254902, 0.25098039215686274, 0.043137254901960784],
    [0.36470588235294116, 0.25098039215686274, 0.047058823529411764],
    [0.36470588235294116, 0.2549019607843137, 0.047058823529411764],
    [0.3686274509803922, 0.25882352941176473, 0.047058823529411764],
    [0.37254901960784315, 0.25882352941176473, 0.047058823529411764],
    [0.3764705882352941, 0.2627450980392157, 0.047058823529411764],
    [0.3803921568627451, 0.26666666666666666, 0.047058823529411764],
    [0.3843137254901961, 0.26666666666666666, 0.047058823529411764],
    [0.38823529411764707, 0.27058823529411763, 0.047058823529411764],
    [0.39215686274509803, 0.27450980392156865, 0.050980392156862744],
    [0.396078431372549, 0.27450980392156865, 0.050980392156862744],
    [0.4, 0.2784313725490196, 0.050980392156862744],
    [0.403921568627451, 0.2823529411764706, 0.050980392156862744],
    [0.40784313725490196, 0.2823529411764706, 0.050980392156862744],
    [0.4117647058823529, 0.28627450980392155, 0.050980392156862744],
    [0.41568627450980394, 0.2901960784313726, 0.050980392156862744],
    [0.4196078431372549, 0.29411764705882354, 0.050980392156862744],
    [0.4235294117647059, 0.29411764705882354, 0.054901960784313725],
    [0.42745098039215684, 0.2980392156862745, 0.054901960784313725],
    [0.43137254901960786, 0.30196078431372547, 0.054901960784313725],
    [0.43529411764705883, 0.30196078431372547, 0.054901960784313725],
    [0.4392156862745098, 0.3058823529411765, 0.054901960784313725],
    [0.44313725490196076, 0.30980392156862746, 0.054901960784313725],
    [0.4470588235294118, 0.30980392156862746, 0.054901960784313725],
    [0.45098039215686275, 0.3137254901960784, 0.054901960784313725],
    [0.4549019607843137, 0.3176470588235294, 0.058823529411764705],
    [0.4588235294117647, 0.3176470588235294, 0.058823529411764705],
    [0.4627450980392157, 0.3215686274509804, 0.058823529411764705],
    [0.4666666666666667, 0.3254901960784314, 0.058823529411764705],
    [0.47058823529411764, 0.3254901960784314, 0.058823529411764705],
    [0.4745098039215686, 0.32941176470588235, 0.058823529411764705],
    [0.47843137254901963, 0.3333333333333333, 0.058823529411764705],
    [0.4823529411764706, 0.3333333333333333, 0.058823529411764705],
    [0.48627450980392156, 0.33725490196078434, 0.06274509803921569],
    [0.48627450980392156, 0.3411764705882353, 0.06274509803921569],
    [0.49019607843137253, 0.3411764705882353, 0.06274509803921569],
    [0.49411764705882355, 0.34509803921568627, 0.06274509803921569],
    [0.4980392156862745, 0.34901960784313724, 0.06274509803921569],
    [0.5019607843137255, 0.34901960784313724, 0.06274509803921569],
    [0.5058823529411764, 0.35294117647058826, 0.06274509803921569],
    [0.5098039215686274, 0.3568627450980392, 0.06274509803921569],
    [0.5137254901960784, 0.3568627450980392, 0.06666666666666667],
    [0.5176470588235295, 0.3607843137254902, 0.06666666666666667],
    [0.5215686274509804, 0.36470588235294116, 0.06666666666666667],
    [0.5254901960784314, 0.36470588235294116, 0.06666666666666667],
    [0.5294117647058824, 0.3686274509803922, 0.06666666666666667],
    [0.5333333333333333, 0.37254901960784315, 0.06666666666666667],
    [0.5372549019607843, 0.37254901960784315, 0.06666666666666667],
    [0.5411764705882353, 0.3764705882352941, 0.06666666666666667],
    [0.5450980392156862, 0.3803921568627451, 0.07058823529411765],
    [0.5490196078431373, 0.3803921568627451, 0.07058823529411765],
    [0.5529411764705883, 0.3843137254901961, 0.07058823529411765],
    [0.5568627450980392, 0.38823529411764707, 0.07058823529411765],
    [0.5607843137254902, 0.39215686274509803, 0.07058823529411765],
    [0.5647058823529412, 0.39215686274509803, 0.07058823529411765],
    [0.5686274509803921, 0.396078431372549, 0.07058823529411765],
    [0.5725490196078431, 0.4, 0.07058823529411765],
    [0.5764705882352941, 0.4, 0.07450980392156863],
    [0.5803921568627451, 0.403921568627451, 0.07450980392156863],
    [0.5843137254901961, 0.40784313725490196, 0.07450980392156863],
    [0.5882352941176471, 0.40784313725490196, 0.07450980392156863],
    [0.592156862745098, 0.4117647058823529, 0.07450980392156863],
    [0.596078431372549, 0.41568627450980394, 0.07450980392156863],
    [0.6, 0.41568627450980394, 0.07450980392156863],
    [0.6039215686274509, 0.4196078431372549, 0.07450980392156863],
    [0.6078431372549019, 0.4235294117647059, 0.0784313725490196],
    [0.6078431372549019, 0.4235294117647059, 0.0784313725490196],
    [0.611764705882353, 0.42745098039215684, 0.0784313725490196],
    [0.615686274509804, 0.43137254901960786, 0.0784313725490196],
    [0.6196078431372549, 0.43137254901960786, 0.0784313725490196],
    [0.6235294117647059, 0.43529411764705883, 0.0784313725490196],
    [0.6274509803921569, 0.4392156862745098, 0.0784313725490196],
    [0.6313725490196078, 0.4392156862745098, 0.0784313725490196],
    [0.6352941176470588, 0.44313725490196076, 0.08235294117647059],
    [0.6392156862745098, 0.4470588235294118, 0.08235294117647059],
    [0.6431372549019608, 0.4470588235294118, 0.08235294117647059],
    [0.6470588235294118, 0.45098039215686275, 0.08235294117647059],
    [0.6509803921568628, 0.4549019607843137, 0.08235294117647059],
    [0.6549019607843137, 0.4549019607843137, 0.08235294117647059],
    [0.6588235294117647, 0.4588235294117647, 0.08235294117647059],
    [0.6627450980392157, 0.4627450980392157, 0.08235294117647059],
    [0.6666666666666666, 0.4627450980392157, 0.08627450980392157],
    [0.6705882352941176, 0.4666666666666667, 0.08627450980392157],
    [0.6745098039215687, 0.47058823529411764, 0.08627450980392157],
    [0.6784313725490196, 0.47058823529411764, 0.08627450980392157],
    [0.6823529411764706, 0.4745098039215686, 0.08627450980392157],
    [0.6862745098039216, 0.47843137254901963, 0.08627450980392157],
    [0.6901960784313725, 0.47843137254901963, 0.08627450980392157],
    [0.6941176470588235, 0.4823529411764706, 0.08627450980392157],
    [0.6980392156862745, 0.48627450980392156, 0.09019607843137255],
    [0.7019607843137254, 0.49019607843137253, 0.09019607843137255],
    [0.7058823529411765, 0.49019607843137253, 0.09019607843137255],
    [0.7098039215686275, 0.49411764705882355, 0.09019607843137255],
    [0.7137254901960784, 0.4980392156862745, 0.09019607843137255],
    [0.7176470588235294, 0.4980392156862745, 0.09019607843137255],
    [0.7215686274509804, 0.5019607843137255, 0.09019607843137255],
    [0.7254901960784313, 0.5058823529411764, 0.09019607843137255],
    [0.7294117647058823, 0.5058823529411764, 0.09411764705882353],
    [0.7294117647058823, 0.5098039215686274, 0.09411764705882353],
    [0.7333333333333333, 0.5137254901960784, 0.09411764705882353],
    [0.7372549019607844, 0.5137254901960784, 0.09411764705882353],
    [0.7411764705882353, 0.5176470588235295, 0.09411764705882353],
    [0.7450980392156863, 0.5215686274509804, 0.09411764705882353],
    [0.7490196078431373, 0.5215686274509804, 0.09411764705882353],
    [0.7529411764705882, 0.5254901960784314, 0.09411764705882353],
    [0.7568627450980392, 0.5294117647058824, 0.09803921568627451],
    [0.7607843137254902, 0.5294117647058824, 0.09803921568627451],
    [0.7647058823529411, 0.5333333333333333, 0.09803921568627451],
    [0.7686274509803922, 0.5372549019607843, 0.09803921568627451],
    [0.7725490196078432, 0.5372549019607843, 0.09803921568627451],
    [0.7764705882352941, 0.5411764705882353, 0.09803921568627451],
    [0.7803921568627451, 0.5450980392156862, 0.09803921568627451],
    [0.7843137254901961, 0.5450980392156862, 0.09803921568627451],
    [0.788235294117647, 0.5490196078431373, 0.10196078431372549],
    [0.792156862745098, 0.5529411764705883, 0.10196078431372549],
    [0.796078431372549, 0.5529411764705883, 0.10196078431372549],
    [0.8, 0.5568627450980392, 0.10196078431372549],
    [0.803921568627451, 0.5607843137254902, 0.10196078431372549],
    [0.807843137254902, 0.5607843137254902, 0.10196078431372549],
    [0.8117647058823529, 0.5647058823529412, 0.10196078431372549],
    [0.8156862745098039, 0.5686274509803921, 0.10196078431372549],
    [0.8196078431372549, 0.5686274509803921, 0.10588235294117647],
    [0.8235294117647058, 0.5725490196078431, 0.10588235294117647],
    [0.8274509803921568, 0.5764705882352941, 0.10588235294117647],
    [0.8313725490196079, 0.5764705882352941, 0.10588235294117647],
    [0.8352941176470589, 0.5803921568627451, 0.10588235294117647],
    [0.8392156862745098, 0.5843137254901961, 0.10588235294117647],
    [0.8431372549019608, 0.5882352941176471, 0.10588235294117647],
    [0.8470588235294118, 0.5882352941176471, 0.10588235294117647],
    [0.8509803921568627, 0.592156862745098, 0.10980392156862745],
    [0.8509803921568627, 0.596078431372549, 0.10980392156862745],
    [0.8549019607843137, 0.596078431372549, 0.10980392156862745],
    [0.8588235294117647, 0.6, 0.10980392156862745],
    [0.8627450980392157, 0.6039215686274509, 0.10980392156862745],
    [0.8666666666666667, 0.6039215686274509, 0.10980392156862745],
    [0.8705882352941177, 0.6078431372549019, 0.10980392156862745],
    [0.8745098039215686, 0.611764705882353, 0.10980392156862745],
    [0.8784313725490196, 0.611764705882353, 0.11372549019607843],
    [0.8823529411764706, 0.615686274509804, 0.11372549019607843],
    [0.8862745098039215, 0.6196078431372549, 0.11372549019607843],
    [0.8901960784313725, 0.6196078431372549, 0.11372549019607843],
    [0.8941176470588236, 0.6235294117647059, 0.11372549019607843],
    [0.8980392156862745, 0.6274509803921569, 0.11372549019607843],
    [0.9019607843137255, 0.6274509803921569, 0.11372549019607843],
    [0.9058823529411765, 0.6313725490196078, 0.11372549019607843],
    [0.9098039215686274, 0.6352941176470588, 0.11764705882352941],
    [0.9137254901960784, 0.6352941176470588, 0.11764705882352941],
    [0.9176470588235294, 0.6392156862745098, 0.11764705882352941],
    [0.9215686274509803, 0.6431372549019608, 0.11764705882352941],
    [0.9254901960784314, 0.6431372549019608, 0.11764705882352941],
    [0.9294117647058824, 0.6470588235294118, 0.11764705882352941],
    [0.9333333333333333, 0.6509803921568628, 0.11764705882352941],
    [0.9372549019607843, 0.6509803921568628, 0.11764705882352941],
    [0.9411764705882353, 0.6549019607843137, 0.12156862745098039],
    [0.9450980392156862, 0.6588235294117647, 0.12156862745098039],
    [0.9490196078431372, 0.6588235294117647, 0.12156862745098039],
    [0.9529411764705882, 0.6627450980392157, 0.12156862745098039],
    [0.9568627450980393, 0.6666666666666666, 0.12156862745098039],
    [0.9607843137254902, 0.6666666666666666, 0.12156862745098039],
    [0.9647058823529412, 0.6705882352941176, 0.12156862745098039],
    [0.9725490196078431, 0.6784313725490196, 0.12549019607843137],
]

bop_purple = [
    [0.0, 0.0, 0.0],
    [0.0, 0.0, 0.0],
    [0.00392156862745098, 0.0, 0.00392156862745098],
    [0.00392156862745098, 0.0, 0.00392156862745098],
    [0.00784313725490196, 0.0, 0.00784313725490196],
    [0.00784313725490196, 0.0, 0.00784313725490196],
    [0.011764705882352941, 0.0, 0.011764705882352941],
    [0.01568627450980392, 0.0, 0.01568627450980392],
    [0.01568627450980392, 0.00392156862745098, 0.01568627450980392],
    [0.0196078431372549, 0.00392156862745098, 0.0196078431372549],
    [0.0196078431372549, 0.00392156862745098, 0.0196078431372549],
    [0.023529411764705882, 0.00392156862745098, 0.023529411764705882],
    [0.023529411764705882, 0.00392156862745098, 0.023529411764705882],
    [0.027450980392156862, 0.00392156862745098, 0.027450980392156862],
    [0.03137254901960784, 0.00392156862745098, 0.03137254901960784],
    [0.03137254901960784, 0.00392156862745098, 0.03137254901960784],
    [0.03529411764705882, 0.00784313725490196, 0.03529411764705882],
    [0.03529411764705882, 0.00784313725490196, 0.03529411764705882],
    [0.0392156862745098, 0.00784313725490196, 0.0392156862745098],
    [0.0392156862745098, 0.00784313725490196, 0.0392156862745098],
    [0.043137254901960784, 0.00784313725490196, 0.043137254901960784],
    [0.047058823529411764, 0.00784313725490196, 0.047058823529411764],
    [0.047058823529411764, 0.00784313725490196, 0.047058823529411764],
    [0.050980392156862744, 0.00784313725490196, 0.050980392156862744],
    [0.050980392156862744, 0.011764705882352941, 0.050980392156862744],
    [0.054901960784313725, 0.011764705882352941, 0.054901960784313725],
    [0.058823529411764705, 0.011764705882352941, 0.058823529411764705],
    [0.058823529411764705, 0.011764705882352941, 0.058823529411764705],
    [0.06274509803921569, 0.011764705882352941, 0.06274509803921569],
    [0.06274509803921569, 0.011764705882352941, 0.06274509803921569],
    [0.06666666666666667, 0.011764705882352941, 0.06666666666666667],
    [0.06666666666666667, 0.011764705882352941, 0.06666666666666667],
    [0.07058823529411765, 0.01568627450980392, 0.07058823529411765],
    [0.07450980392156863, 0.01568627450980392, 0.07450980392156863],
    [0.07450980392156863, 0.01568627450980392, 0.07450980392156863],
    [0.0784313725490196, 0.01568627450980392, 0.0784313725490196],
    [0.0784313725490196, 0.01568627450980392, 0.0784313725490196],
    [0.08235294117647059, 0.01568627450980392, 0.08235294117647059],
    [0.08235294117647059, 0.01568627450980392, 0.08235294117647059],
    [0.08627450980392157, 0.01568627450980392, 0.08627450980392157],
    [0.09019607843137255, 0.0196078431372549, 0.09019607843137255],
    [0.09019607843137255, 0.0196078431372549, 0.09019607843137255],
    [0.09411764705882353, 0.0196078431372549, 0.09411764705882353],
    [0.09411764705882353, 0.0196078431372549, 0.09411764705882353],
    [0.09803921568627451, 0.0196078431372549, 0.09803921568627451],
    [0.10196078431372549, 0.0196078431372549, 0.10196078431372549],
    [0.10196078431372549, 0.0196078431372549, 0.10196078431372549],
    [0.10588235294117647, 0.0196078431372549, 0.10588235294117647],
    [0.10588235294117647, 0.023529411764705882, 0.10588235294117647],
    [0.10980392156862745, 0.023529411764705882, 0.10980392156862745],
    [0.10980392156862745, 0.023529411764705882, 0.10980392156862745],
    [0.11372549019607843, 0.023529411764705882, 0.11372549019607843],
    [0.11764705882352941, 0.023529411764705882, 0.11764705882352941],
    [0.11764705882352941, 0.023529411764705882, 0.11764705882352941],
    [0.12156862745098039, 0.023529411764705882, 0.12156862745098039],
    [0.12156862745098039, 0.023529411764705882, 0.12156862745098039],
    [0.12549019607843137, 0.027450980392156862, 0.12549019607843137],
    [0.12549019607843137, 0.027450980392156862, 0.12549019607843137],
    [0.12941176470588237, 0.027450980392156862, 0.12941176470588237],
    [0.13333333333333333, 0.027450980392156862, 0.13333333333333333],
    [0.13333333333333333, 0.027450980392156862, 0.13333333333333333],
    [0.13725490196078433, 0.027450980392156862, 0.13725490196078433],
    [0.13725490196078433, 0.027450980392156862, 0.13725490196078433],
    [0.1411764705882353, 0.027450980392156862, 0.1411764705882353],
    [0.1450980392156863, 0.03137254901960784, 0.1450980392156863],
    [0.1450980392156863, 0.03137254901960784, 0.1450980392156863],
    [0.14901960784313725, 0.03137254901960784, 0.14901960784313725],
    [0.14901960784313725, 0.03137254901960784, 0.14901960784313725],
    [0.15294117647058825, 0.03137254901960784, 0.15294117647058825],
    [0.15294117647058825, 0.03137254901960784, 0.15294117647058825],
    [0.1568627450980392, 0.03137254901960784, 0.1568627450980392],
    [0.1607843137254902, 0.03137254901960784, 0.1607843137254902],
    [0.1607843137254902, 0.03529411764705882, 0.1607843137254902],
    [0.16470588235294117, 0.03529411764705882, 0.16470588235294117],
    [0.16470588235294117, 0.03529411764705882, 0.16470588235294117],
    [0.16862745098039217, 0.03529411764705882, 0.16862745098039217],
    [0.16862745098039217, 0.03529411764705882, 0.16862745098039217],
    [0.17254901960784313, 0.03529411764705882, 0.17254901960784313],
    [0.17647058823529413, 0.03529411764705882, 0.17647058823529413],
    [0.17647058823529413, 0.03529411764705882, 0.17647058823529413],
    [0.1803921568627451, 0.0392156862745098, 0.1803921568627451],
    [0.1803921568627451, 0.0392156862745098, 0.1803921568627451],
    [0.1843137254901961, 0.0392156862745098, 0.1843137254901961],
    [0.1843137254901961, 0.0392156862745098, 0.1843137254901961],
    [0.18823529411764706, 0.0392156862745098, 0.18823529411764706],
    [0.19215686274509805, 0.0392156862745098, 0.19215686274509805],
    [0.19215686274509805, 0.0392156862745098, 0.19215686274509805],
    [0.19607843137254902, 0.0392156862745098, 0.19607843137254902],
    [0.19607843137254902, 0.043137254901960784, 0.19607843137254902],
    [0.2, 0.043137254901960784, 0.2],
    [0.20392156862745098, 0.043137254901960784, 0.20392156862745098],
    [0.20392156862745098, 0.043137254901960784, 0.20392156862745098],
    [0.20784313725490197, 0.043137254901960784, 0.20784313725490197],
    [0.20784313725490197, 0.043137254901960784, 0.20784313725490197],
    [0.21176470588235294, 0.043137254901960784, 0.21176470588235294],
    [0.21176470588235294, 0.043137254901960784, 0.21176470588235294],
    [0.21568627450980393, 0.047058823529411764, 0.21568627450980393],
    [0.2196078431372549, 0.047058823529411764, 0.2196078431372549],
    [0.2196078431372549, 0.047058823529411764, 0.2196078431372549],
    [0.2235294117647059, 0.047058823529411764, 0.2235294117647059],
    [0.2235294117647059, 0.047058823529411764, 0.2235294117647059],
    [0.22745098039215686, 0.047058823529411764, 0.22745098039215686],
    [0.22745098039215686, 0.047058823529411764, 0.22745098039215686],
    [0.23137254901960785, 0.047058823529411764, 0.23137254901960785],
    [0.23529411764705882, 0.050980392156862744, 0.23529411764705882],
    [0.23529411764705882, 0.050980392156862744, 0.23529411764705882],
    [0.23921568627450981, 0.050980392156862744, 0.23921568627450981],
    [0.23921568627450981, 0.050980392156862744, 0.23921568627450981],
    [0.24313725490196078, 0.050980392156862744, 0.24313725490196078],
    [0.24705882352941178, 0.050980392156862744, 0.24705882352941178],
    [0.24705882352941178, 0.050980392156862744, 0.24705882352941178],
    [0.25098039215686274, 0.050980392156862744, 0.25098039215686274],
    [0.25098039215686274, 0.054901960784313725, 0.25098039215686274],
    [0.2549019607843137, 0.054901960784313725, 0.2549019607843137],
    [0.2549019607843137, 0.054901960784313725, 0.2549019607843137],
    [0.25882352941176473, 0.054901960784313725, 0.25882352941176473],
    [0.2627450980392157, 0.054901960784313725, 0.2627450980392157],
    [0.2627450980392157, 0.054901960784313725, 0.2627450980392157],
    [0.26666666666666666, 0.054901960784313725, 0.26666666666666666],
    [0.26666666666666666, 0.054901960784313725, 0.26666666666666666],
    [0.27058823529411763, 0.058823529411764705, 0.27058823529411763],
    [0.27058823529411763, 0.058823529411764705, 0.27058823529411763],
    [0.27450980392156865, 0.058823529411764705, 0.27450980392156865],
    [0.2784313725490196, 0.058823529411764705, 0.2784313725490196],
    [0.2784313725490196, 0.058823529411764705, 0.2784313725490196],
    [0.2823529411764706, 0.058823529411764705, 0.2823529411764706],
    [0.2823529411764706, 0.058823529411764705, 0.2823529411764706],
    [0.28627450980392155, 0.058823529411764705, 0.28627450980392155],
    [0.2901960784313726, 0.06274509803921569, 0.2901960784313726],
    [0.2901960784313726, 0.06274509803921569, 0.2901960784313726],
    [0.29411764705882354, 0.06274509803921569, 0.29411764705882354],
    [0.29411764705882354, 0.06274509803921569, 0.29411764705882354],
    [0.2980392156862745, 0.06274509803921569, 0.2980392156862745],
    [0.2980392156862745, 0.06274509803921569, 0.2980392156862745],
    [0.30196078431372547, 0.06274509803921569, 0.30196078431372547],
    [0.3058823529411765, 0.06274509803921569, 0.3058823529411765],
    [0.3058823529411765, 0.06666666666666667, 0.3058823529411765],
    [0.30980392156862746, 0.06666666666666667, 0.30980392156862746],
    [0.30980392156862746, 0.06666666666666667, 0.30980392156862746],
    [0.3137254901960784, 0.06666666666666667, 0.3137254901960784],
    [0.3137254901960784, 0.06666666666666667, 0.3137254901960784],
    [0.3176470588235294, 0.06666666666666667, 0.3176470588235294],
    [0.3215686274509804, 0.06666666666666667, 0.3215686274509804],
    [0.3215686274509804, 0.06666666666666667, 0.3215686274509804],
    [0.3254901960784314, 0.07058823529411765, 0.3254901960784314],
    [0.3254901960784314, 0.07058823529411765, 0.3254901960784314],
    [0.32941176470588235, 0.07058823529411765, 0.32941176470588235],
    [0.32941176470588235, 0.07058823529411765, 0.32941176470588235],
    [0.3333333333333333, 0.07058823529411765, 0.3333333333333333],
    [0.33725490196078434, 0.07058823529411765, 0.33725490196078434],
    [0.33725490196078434, 0.07058823529411765, 0.33725490196078434],
    [0.3411764705882353, 0.07058823529411765, 0.3411764705882353],
    [0.3411764705882353, 0.07450980392156863, 0.3411764705882353],
    [0.34509803921568627, 0.07450980392156863, 0.34509803921568627],
    [0.34901960784313724, 0.07450980392156863, 0.34901960784313724],
    [0.34901960784313724, 0.07450980392156863, 0.34901960784313724],
    [0.35294117647058826, 0.07450980392156863, 0.35294117647058826],
    [0.35294117647058826, 0.07450980392156863, 0.35294117647058826],
    [0.3568627450980392, 0.07450980392156863, 0.3568627450980392],
    [0.3568627450980392, 0.07450980392156863, 0.3568627450980392],
    [0.3607843137254902, 0.0784313725490196, 0.3607843137254902],
    [0.36470588235294116, 0.0784313725490196, 0.36470588235294116],
    [0.36470588235294116, 0.0784313725490196, 0.36470588235294116],
    [0.3686274509803922, 0.0784313725490196, 0.3686274509803922],
    [0.3686274509803922, 0.0784313725490196, 0.3686274509803922],
    [0.37254901960784315, 0.0784313725490196, 0.37254901960784315],
    [0.37254901960784315, 0.0784313725490196, 0.37254901960784315],
    [0.3764705882352941, 0.0784313725490196, 0.3764705882352941],
    [0.3803921568627451, 0.08235294117647059, 0.3803921568627451],
    [0.3803921568627451, 0.08235294117647059, 0.3803921568627451],
    [0.3843137254901961, 0.08235294117647059, 0.3843137254901961],
    [0.3843137254901961, 0.08235294117647059, 0.3843137254901961],
    [0.38823529411764707, 0.08235294117647059, 0.38823529411764707],
    [0.39215686274509803, 0.08235294117647059, 0.39215686274509803],
    [0.39215686274509803, 0.08235294117647059, 0.39215686274509803],
    [0.396078431372549, 0.08235294117647059, 0.396078431372549],
    [0.396078431372549, 0.08627450980392157, 0.396078431372549],
    [0.4, 0.08627450980392157, 0.4],
    [0.4, 0.08627450980392157, 0.4],
    [0.403921568627451, 0.08627450980392157, 0.403921568627451],
    [0.40784313725490196, 0.08627450980392157, 0.40784313725490196],
    [0.40784313725490196, 0.08627450980392157, 0.40784313725490196],
    [0.4117647058823529, 0.08627450980392157, 0.4117647058823529],
    [0.4117647058823529, 0.08627450980392157, 0.4117647058823529],
    [0.41568627450980394, 0.09019607843137255, 0.41568627450980394],
    [0.41568627450980394, 0.09019607843137255, 0.41568627450980394],
    [0.4196078431372549, 0.09019607843137255, 0.4196078431372549],
    [0.4235294117647059, 0.09019607843137255, 0.4235294117647059],
    [0.4235294117647059, 0.09019607843137255, 0.4235294117647059],
    [0.42745098039215684, 0.09019607843137255, 0.42745098039215684],
    [0.42745098039215684, 0.09019607843137255, 0.42745098039215684],
    [0.43137254901960786, 0.09019607843137255, 0.43137254901960786],
    [0.43529411764705883, 0.09411764705882353, 0.43529411764705883],
    [0.43529411764705883, 0.09411764705882353, 0.43529411764705883],
    [0.4392156862745098, 0.09411764705882353, 0.4392156862745098],
    [0.4392156862745098, 0.09411764705882353, 0.4392156862745098],
    [0.44313725490196076, 0.09411764705882353, 0.44313725490196076],
    [0.44313725490196076, 0.09411764705882353, 0.44313725490196076],
    [0.4470588235294118, 0.09411764705882353, 0.4470588235294118],
    [0.45098039215686275, 0.09411764705882353, 0.45098039215686275],
    [0.45098039215686275, 0.09803921568627451, 0.45098039215686275],
    [0.4549019607843137, 0.09803921568627451, 0.4549019607843137],
    [0.4549019607843137, 0.09803921568627451, 0.4549019607843137],
    [0.4588235294117647, 0.09803921568627451, 0.4588235294117647],
    [0.4588235294117647, 0.09803921568627451, 0.4588235294117647],
    [0.4627450980392157, 0.09803921568627451, 0.4627450980392157],
    [0.4666666666666667, 0.09803921568627451, 0.4666666666666667],
    [0.4666666666666667, 0.09803921568627451, 0.4666666666666667],
    [0.47058823529411764, 0.10196078431372549, 0.47058823529411764],
    [0.47058823529411764, 0.10196078431372549, 0.47058823529411764],
    [0.4745098039215686, 0.10196078431372549, 0.4745098039215686],
    [0.4745098039215686, 0.10196078431372549, 0.4745098039215686],
    [0.47843137254901963, 0.10196078431372549, 0.47843137254901963],
    [0.4823529411764706, 0.10196078431372549, 0.4823529411764706],
    [0.4823529411764706, 0.10196078431372549, 0.4823529411764706],
    [0.48627450980392156, 0.10196078431372549, 0.48627450980392156],
    [0.48627450980392156, 0.10588235294117647, 0.48627450980392156],
    [0.49019607843137253, 0.10588235294117647, 0.49019607843137253],
    [0.49411764705882355, 0.10588235294117647, 0.49411764705882355],
    [0.49411764705882355, 0.10588235294117647, 0.49411764705882355],
    [0.4980392156862745, 0.10588235294117647, 0.4980392156862745],
    [0.4980392156862745, 0.10588235294117647, 0.4980392156862745],
    [0.5019607843137255, 0.10588235294117647, 0.5019607843137255],
    [0.5019607843137255, 0.10588235294117647, 0.5019607843137255],
    [0.5058823529411764, 0.10980392156862745, 0.5058823529411764],
    [0.5098039215686274, 0.10980392156862745, 0.5098039215686274],
    [0.5098039215686274, 0.10980392156862745, 0.5098039215686274],
    [0.5137254901960784, 0.10980392156862745, 0.5137254901960784],
    [0.5137254901960784, 0.10980392156862745, 0.5137254901960784],
    [0.5176470588235295, 0.10980392156862745, 0.5176470588235295],
    [0.5176470588235295, 0.10980392156862745, 0.5176470588235295],
    [0.5215686274509804, 0.10980392156862745, 0.5215686274509804],
    [0.5254901960784314, 0.11372549019607843, 0.5254901960784314],
    [0.5254901960784314, 0.11372549019607843, 0.5254901960784314],
    [0.5294117647058824, 0.11372549019607843, 0.5294117647058824],
    [0.5294117647058824, 0.11372549019607843, 0.5294117647058824],
    [0.5333333333333333, 0.11372549019607843, 0.5333333333333333],
    [0.5372549019607843, 0.11372549019607843, 0.5372549019607843],
    [0.5372549019607843, 0.11372549019607843, 0.5372549019607843],
    [0.5411764705882353, 0.11372549019607843, 0.5411764705882353],
    [0.5411764705882353, 0.11764705882352941, 0.5411764705882353],
    [0.5450980392156862, 0.11764705882352941, 0.5450980392156862],
    [0.5450980392156862, 0.11764705882352941, 0.5450980392156862],
    [0.5490196078431373, 0.11764705882352941, 0.5490196078431373],
    [0.5529411764705883, 0.11764705882352941, 0.5529411764705883],
    [0.5529411764705883, 0.11764705882352941, 0.5529411764705883],
    [0.5568627450980392, 0.11764705882352941, 0.5568627450980392],
    [0.5568627450980392, 0.11764705882352941, 0.5568627450980392],
    [0.5607843137254902, 0.12156862745098039, 0.5607843137254902],
    [0.5607843137254902, 0.12156862745098039, 0.5607843137254902],
    [0.5647058823529412, 0.12156862745098039, 0.5647058823529412],
    [0.5686274509803921, 0.12156862745098039, 0.5686274509803921],
    [0.5686274509803921, 0.12156862745098039, 0.5686274509803921],
    [0.5725490196078431, 0.12156862745098039, 0.5725490196078431],
    [0.5725490196078431, 0.12156862745098039, 0.5725490196078431],
    [0.5803921568627451, 0.12549019607843137, 0.5803921568627451],
]

bopd = {
    "bop blue": (trans._("bop blue"), bop_blue),
    "bop orange": (trans._("bop orange"), bop_orange),
    "bop purple": (trans._("bop purple"), bop_purple),
}
