/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MultiFileSplit;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;

@Deprecated
public abstract class MultiFileInputFormat<K, V>
extends FileInputFormat<K, V> {
    @Override
    public InputSplit[] getSplits(JobConf job, int numSplits) throws IOException {
        Path[] paths = FileUtil.stat2Paths(this.listStatus(job));
        ArrayList<MultiFileSplit> splits = new ArrayList<MultiFileSplit>(Math.min(numSplits, paths.length));
        if (paths.length != 0) {
            long[] lengths = new long[paths.length];
            long totLength = 0L;
            for (int i = 0; i < paths.length; ++i) {
                FileSystem fs = paths[i].getFileSystem(job);
                lengths[i] = fs.getContentSummary(paths[i]).getLength();
                totLength += lengths[i];
            }
            double avgLengthPerSplit = (double)totLength / (double)numSplits;
            long cumulativeLength = 0L;
            int startIndex = 0;
            for (int i = 0; i < numSplits; ++i) {
                int splitSize = this.findSize(i, avgLengthPerSplit, cumulativeLength, startIndex, lengths);
                if (splitSize == 0) continue;
                Path[] splitPaths = new Path[splitSize];
                long[] splitLengths = new long[splitSize];
                System.arraycopy(paths, startIndex, splitPaths, 0, splitSize);
                System.arraycopy(lengths, startIndex, splitLengths, 0, splitSize);
                splits.add(new MultiFileSplit(job, splitPaths, splitLengths));
                startIndex += splitSize;
                for (long l : splitLengths) {
                    cumulativeLength += l;
                }
            }
        }
        return splits.toArray(new MultiFileSplit[splits.size()]);
    }

    private int findSize(int splitIndex, double avgLengthPerSplit, long cumulativeLength, int startIndex, long[] lengths) {
        if (splitIndex == lengths.length - 1) {
            return lengths.length - startIndex;
        }
        long goalLength = (long)((double)(splitIndex + 1) * avgLengthPerSplit);
        long partialLength = 0L;
        for (int i = startIndex; i < lengths.length; ++i) {
            if ((partialLength += lengths[i]) + cumulativeLength < goalLength) continue;
            return i - startIndex + 1;
        }
        return lengths.length - startIndex;
    }

    @Override
    public abstract RecordReader<K, V> getRecordReader(InputSplit var1, JobConf var2, Reporter var3) throws IOException;
}

