/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#ifndef MvQKeyManager_H
#define MvQKeyManager_H

#include <iostream>
#include <map>
#include <vector>
#include <list>

#include <QtGlobal>
#include <QMap>
#include <QString>

//#if QT_VERSION < QT_VERSION_CHECK(6, 0, 0)
//#include <QtXmlPatterns/QXmlQuery>
//#else
//#include <QXmlQuery>
//#endif

using namespace std;

class MvKeyProfile;


class MvQKeyManager
{
public:
    enum KeyType
    {
        FrameType,
        GribType,
        BufrType,
        PlaceMarkType,
        LayerType,
        BookmarkType
    };

    MvQKeyManager(KeyType t, string fProfUser = string());
    MvQKeyManager(const MvQKeyManager&);
    ~MvQKeyManager();

    MvQKeyManager* clone();
    MvKeyProfile* addProfile(const string&);
    void addProfile(MvKeyProfile*);
    MvKeyProfile* addProfile(const string&, MvKeyProfile*);
    MvKeyProfile* addProfile(const string&, MvKeyProfile*, KeyType);
    void changeProfile(const string&, MvKeyProfile*);
    KeyType keyType() { return keyType_; }
    QString keyTypeName(KeyType t) const;
    const string& profilePath() const { return fProfUser_; }

    const vector<MvKeyProfile*>& data() const { return data_; }
    MvKeyProfile* findProfile(string);
    bool isEmpty() { return (data_.size() == 0) ? true : false; }
    void update(MvQKeyManager*);
    void deleteProfile(int);
    void loadProfiles();
    bool loadProfiles(string, vector<MvKeyProfile*>&);
    void loadAllKeys(vector<MvKeyProfile*>&);
    void saveProfiles();
    void clear();
    QString findUniqueProfileName(QString);
    //void getAttributes(QXmlQuery &,QXmlItem &,QMap<QString,QString>&);
    bool predefinedKeysOnly() { return predefinedKeysOnly_; }

private:
    void createDefaultProfile(MvKeyProfile*);

    string fProfDefault_;
    string fProfAll_;
    string fProfUser_;

    vector<MvKeyProfile*> data_;
    vector<MvKeyProfile*> dataAll_;

    KeyType keyType_;
    static QMap<KeyType, QString> keyTypeName_;
    bool systemProfOnly_;
    bool predefinedKeysOnly_;
};

#endif
