/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#include <X11/X.h>
#include <X11/cursorfont.h>
#include <Xm/Xm.h>

/*----------------------------------------------------

	Set the cursor to a watch shape. 
	Usualy pass the Top Shell as argument.

----------------------------------------------------*/

void xec_SetWatchCursor(w)
Widget w;
{
	static Cursor watch = NULL;

	if(!watch)
		watch = XCreateFontCursor(XtDisplay(w),XC_watch);

	XDefineCursor(XtDisplay(w),XtWindow(w),watch);
	XmUpdateDisplay(w);
}

/*----------------------------------------------------

	Reset the cursor to its default shape. 
	Usualy pass the Top Shell as argument.

----------------------------------------------------*/

void xec_ResetCursor(w)
Widget w;
{
	XUndefineCursor(XtDisplay(w),XtWindow(w));
	XmUpdateDisplay(w);
}

