/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#ifndef SPECTRA_H
#define SPECTRA_H

#include "Metview.h"

class SpectraF : public MvService {

public:

   SpectraF(char* a) : MvService(a) {}
   ~SpectraF() {}
   void serve(MvRequest&,MvRequest&);

   virtual bool getInputParameters(MvRequest&) = 0;
   bool getDataGen(MvRequest&);
   bool computeSpectra(MvRequest&);
   virtual bool createOutputRequest(MvRequest&,MvRequest&) = 0;
   virtual void BuildAxis(MvRequest&,MvRequest&,MvRequest&) = 0;
   string getTitle(MvRequest&);

protected :

   string      ncFileName_; // netcdf file name
   string      actionMode_; // "examine"/"save"/"execute"/...
   int         Stype_;      // SPECGRAPH or SPECCONTOUR
   int         Sdc_;        // subtracts out the diurnal cycle: TRUE or FALSE
   int         Snl24int_;   // plots only every 24 hours: TRUE or FALSE
   int         Sntmin_;     // axis lower value
   int         Sntlim_;     // axis upper value
   float       Smtrunc_;    // highest wavenumber in plots of spectra
   MvFieldSet  Sfset_;      // field set
};

class Specgraph : public SpectraF
{

public :

   Specgraph(char* a) : SpectraF(a) {}
   virtual bool getInputParameters(MvRequest&);
   virtual bool createOutputRequest(MvRequest&,MvRequest&);
   virtual void BuildAxis(MvRequest&,MvRequest&,MvRequest&);
   void BuildCurveLineParam(MvRequest&,int,int);

private:

   string    Stension_;     // interpolation for smoothing curves
   int       Ssmooth_;      // allows the curves to be smoothed: TRUE or FALSE
};

class Speccontour : public SpectraF
{

public :

   Speccontour(char* a) : SpectraF(a) {}
   virtual bool getInputParameters(MvRequest&);
   virtual bool createOutputRequest(MvRequest&,MvRequest&);
   virtual void BuildAxis(MvRequest&,MvRequest&,MvRequest&);

private:

   double Shilorad_;      // searchs radius for plotting of high/low markers
};

#endif
