/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#include "MvQFileDialog.h"

#include <QDebug>
#include <QDesktopServices>
#include <QFileSystemModel>
#include <QUrl>

#include "MvQPixmapCache.h"

//===========================
// MvQFileIconProvider
//===========================

MvQFileIconProvider::MvQFileIconProvider()
{
	char *iconHome=getenv("METVIEW_DIR_SHARE");

 	if (iconHome == 0)  
	{
		return;	
	}
	
	path_= QString(iconHome);
	path_.append("/icons/");
	
	pixCache_=new MvQPixmapCache(QPixmap());
	
	
	char *mv=getenv("METVIEW_USER_DIRECTORY");
	if(mv)
	  	mvHome_=QString(mv);
}

QIcon MvQFileIconProvider::icon(const QFileInfo& info) const
{
	if(info.isDir())
	{
		QString pixName="FOLDER";
		
		if(!mvHome_.isEmpty() && info.filePath() == mvHome_)
		{
			pixName="HOME";  	
		}
	
	  	QPixmap pix=pixCache_->pixmap(pixName);
		if(pix.isNull())
		{
		  	pix=QPixmap(path_ + pixName + ".svg");
		  	if(!pix.isNull())
			  	pixCache_->add(pixName,pix);
		}
		
		return QIcon(pix);		
	}	  	

	return QFileIconProvider::icon(info);
}

//===========================
// MvQFileDialogFilterModel 
//===========================

MvQFileDialogFilterModel::MvQFileDialogFilterModel(QObject *parent) :  
   QSortFilterProxyModel(parent)
{
}

bool MvQFileDialogFilterModel::filterAcceptsRow(int sourceRow, const QModelIndex &sourceParent) const
{
	QModelIndex index = sourceModel()->index(sourceRow, 0, sourceParent);
    	QFileSystemModel* fsModel = qobject_cast<QFileSystemModel*>(sourceModel());

	if(!fsModel) 
		return false;
	
	QString fileName=fsModel->fileName(index);
	
    	if(fsModel->isDir(index))
    	{
        	if(fileName.endsWith("#") == false)
			return true;
		else
			return false;  
	}
	
	if(fileName.startsWith(".") == false && 
	   fileName.startsWith("..") == false)
	{
		return true;	
	}
	
	return false;
}

bool MvQFileDialogFilterModel::lessThan(const QModelIndex &left,const QModelIndex &right) const
{
    	QFileSystemModel* fsModel = qobject_cast<QFileSystemModel*>(sourceModel());

	if(!fsModel) 
		return false;
	
	if(fsModel->isDir(right))
	{
	  	if(!fsModel->isDir(left))
		  	return false;
	}
	else
	{
	  	if(fsModel->isDir(left))
		  	return true;
	}
	
	return QSortFilterProxyModel::lessThan(left,right);
}
	
//===========================
// MvQFileDialog
//===========================

MvQFileDialog::MvQFileDialog(QString startDir,QString title,QWidget *parent): QFileDialog(parent)
{
  	setWindowTitle(title);
  
  	setOptions(QFileDialog::DontUseNativeDialog);
	
	//url sidebar
	QList<QUrl> urlLst;
	
	urlLst << QUrl("file:");

#ifndef METVIEW_QT5	
	urlLst << QUrl::fromLocalFile(QDesktopServices::storageLocation(QDesktopServices::HomeLocation));
#endif
	
	if(char *mvDir=getenv("METVIEW_USER_DIRECTORY"))		
  	{ 	
		urlLst <<  QUrl::fromLocalFile(QString(mvDir));
	}
	/*if(char *scratchDir=getenv("SCRATCH"))
	{	  
		urlLst <<  QUrl::fromLocalFile(QString(scratchDir));
	}*/
	
	setSidebarUrls(urlLst);
	
	//Filter model
	MvQFileDialogFilterModel *proxy=new MvQFileDialogFilterModel(this);	
	setProxyModel(proxy);
	
	//Dir
	setDirectory(startDir);
	
	//Icons
	MvQFileIconProvider *iconProvider=new MvQFileIconProvider;
	setIconProvider(iconProvider);	
	
}	
  


