/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

// File IconHolder.h
// Baudouin Raoult - ECMWF Jul 99

#ifndef IconHolder_H
#define IconHolder_H

#ifndef UIIconLine_H
#include "UIIconLine.h"
#endif

#ifndef RequestPanelLine_H
#include "RequestPanelLine.h"
#endif

#ifndef DragWindow_H
#include "DragWindow.h"
#endif

#ifndef IconObserver_H
#include "IconObserver.h"
#endif


class IconHolder : public DragWindow, public IconObserver {
public:

// -- Exceptions
	// None

// -- Contructors

	IconHolder();

// -- Destructor

	virtual ~IconHolder(); // Change to virtual if base class

// -- Convertors
	// None

// -- Operators
	// None

// -- Methods


// -- Overridden methods
	// None

// -- Class members
	// None

protected:

// -- Members
	vector<IconObjectH> icons_;


// -- Methods
	void install(Widget); 
	void add(IconObject*);
	void clear();
	void clear(IconObject*);
	void clearCurrent(); 

	
	// void print(ostream&) const; // Change to virtual if base class	

// -- Overridden methods
	// None 


// -- Class members
	// None

// -- Class methods
	// None

private:

// No copy allowed

	IconHolder(const IconHolder&);
	IconHolder& operator=(const IconHolder&);

// -- Members


// -- Methods
	// None
	virtual bool accept(IconObject*) = 0;
	virtual bool unique();

// -- Overridden methods

	// From DragWindow
	virtual void doubleClick(IconObject*) ; 
	virtual void move(IconObject*,int,int,IconObject*);
	virtual void rename(IconObject*,const string&);


	// From IconObserver 
	virtual void changed(IconObject*);
	virtual void edited(IconObject*);
	virtual void closed(IconObject*);

// -- Class members
	// None

// -- Class methods
	// None

// -- Friends

	//friend ostream& operator<<(ostream& s,const IconHolder& p)
	//	{ p.print(s); return s; }

};

inline void destroy(IconHolder**) {}

// If persistent, uncomment, otherwise remove
//#ifdef _ODI_OSSG_
//OS_MARK_SCHEMA_TYPE(IconHolder);
//#endif

#endif
