require("munit")

editor = moo.Editor.instance()
doc = editor.new_doc()

tassert(doc.get_text() == '')
doc.insert_text("a")
doc.insert_text("b")
tassert(doc.get_text() == 'ab')
tassert(doc.get_text(1) == 'ab')
tassert(doc.get_text(1,3) == 'ab')
tassert(doc.get_text(1,2) == 'a')
tassert(doc.get_text(1,1) == '')

tassert_eq(doc.get_cursor_pos().get_offset(), 3)
tassert_eq(doc.get_cursor_pos(), doc.get_selection_end_pos())
tassert_eq(doc.get_selection_start_pos(), doc.get_selection_end_pos())
tassert_eq(doc.get_selected_text(), '')
doc.select_range(1, 3)
tassert_eq(doc.get_cursor_pos().get_offset(), 1)
tassert_eq(doc.get_selection_start_pos().get_offset(), 1)
tassert_eq(doc.get_selection_end_pos().get_offset(), 3)
tassert_eq(doc.get_selected_text(), 'ab')
doc.select_range(1, 2)
tassert_eq(doc.get_cursor_pos().get_offset(), 1)
tassert_eq(doc.get_selection_start_pos().get_offset(), 1)
tassert_eq(doc.get_selection_end_pos().get_offset(), 2)
tassert_eq(doc.get_selected_text(), 'a')
doc.select_range(2, 1)
tassert_eq(doc.get_cursor_pos().get_offset(), 2)
tassert_eq(doc.get_selection_start_pos().get_offset(), 1)
tassert_eq(doc.get_selection_end_pos().get_offset(), 2)
tassert_eq(doc.get_selected_text(), 'a')

doc.set_text('abcdef')
tassert_eq(doc.get_text(), 'abcdef')
doc.select_range(3, 5)
tassert_eq(doc.get_selected_text(), 'cd')
doc.delete_selected_text()
tassert_eq(doc.get_selected_text(), '')
tassert_eq(doc.get_text(), 'abef')
tassert_eq(doc.get_cursor_pos().get_offset(), 3)

doc.delete_text(3, 5)
tassert_eq(doc.get_selected_text(), '')
tassert_eq(doc.get_text(), 'ab')
tassert_eq(doc.get_cursor_pos().get_offset(), 3)
doc.set_text('abcdef')
doc.set_cursor_pos(3)
doc.delete_text(2, 6)
tassert_eq(doc.get_selected_text(), '')
tassert_eq(doc.get_text(), 'af')
tassert_eq(doc.get_cursor_pos().get_offset(), 2)

doc.set_text('abcdef')
doc.select_range(2, 6)
doc.replace_selected_text('BCDE')
tassert_eq(doc.get_text(), 'aBCDEf')
doc.set_cursor_pos(1)
doc.insert_text('A')
tassert_eq(doc.get_text(), 'AaBCDEf')
doc.insert_text('A', 8)
tassert_eq(doc.get_text(), 'AaBCDEfA')

doc.set_text('abcdef')
tassert_eq(doc.get_text(1, 2), 'a')
tassert_eq(doc.get_text(1), 'abcdef')
doc.delete_text(doc.get_start_pos(), doc.get_end_pos())
tassert_eq(doc.get_start_pos(), doc.get_end_pos(), '')
tassert_eq(doc.get_text(1), '')
tassert_eq(doc.get_text(), '')

doc.set_text('')
tassert_eq(doc.get_char_count(), 0)
tassert_eq(doc.get_line_count(), 1)
tassert_eq(doc.get_pos_at_line(1).get_offset(), 1)
tassert_eq(doc.get_pos_at_line_end(1).get_offset(), 1)
tassert_eq(doc.get_line_at_pos(1), 1)
tassert_eq(doc.get_line_at_cursor(), 1)
tassert_eq(doc.get_line_text(), '')
tassert_eq(doc.get_line_text(1), '')

doc.set_text('abcdef')
doc.set_cursor_pos(3)
tassert_eq(doc.get_char_count(), 6)
tassert_eq(doc.get_line_count(), 1)
tassert_eq(doc.get_pos_at_line(1).get_offset(), 1)
tassert_eq(doc.get_pos_at_line_end(1).get_offset(), 7)
tassert_eq(doc.get_line_at_pos(1), 1)
tassert_eq(doc.get_line_at_cursor(), 1)
tassert_eq(doc.get_line_text(), 'abcdef')
tassert_eq(doc.get_line_text(1), 'abcdef')

doc.set_text('abcdef\nghijk')
tassert_eq(doc.get_char_count(), 12)
tassert_eq(doc.get_line_count(), 2)
tassert_eq(doc.get_pos_at_line(1).get_offset(), 1)
tassert_eq(doc.get_pos_at_line_end(1).get_offset(), 7)
tassert_eq(doc.get_line_at_pos(1), 1)
tassert_eq(doc.get_pos_at_line(2).get_offset(), 8)
tassert_eq(doc.get_pos_at_line_end(2).get_offset(), 13)
tassert_eq(doc.get_line_at_pos(8), 2)
tassert_eq(doc.get_line_at_pos(11), 2)
tassert_eq(doc.get_line_at_pos(12), 2)
tassert_eq(doc.get_line_text(1), 'abcdef')
tassert_eq(doc.get_line_text(2), 'ghijk')
doc.set_cursor_pos(3)
tassert_eq(doc.get_line_at_cursor(), 1)
tassert_eq(doc.get_line_text(), 'abcdef')
doc.set_cursor_pos(9)
tassert_eq(doc.get_line_at_cursor(), 2)
tassert_eq(doc.get_line_text(), 'ghijk')

doc.set_text('abcdef\n')
tassert_eq(doc.get_char_count(), 7)
tassert_eq(doc.get_line_count(), 2)
tassert_eq(doc.get_pos_at_line(1).get_offset(), 1)
tassert_eq(doc.get_pos_at_line_end(1).get_offset(), 7)
tassert_eq(doc.get_line_at_pos(1), 1)
tassert_eq(doc.get_pos_at_line(2).get_offset(), 8)
tassert_eq(doc.get_pos_at_line_end(2).get_offset(), 8)
tassert_eq(doc.get_line_at_pos(8), 2)
tassert_eq(doc.get_line_text(1), 'abcdef')
tassert_eq(doc.get_line_text(2), '')
doc.set_cursor_pos(3)
tassert_eq(doc.get_line_at_cursor(), 1)
tassert_eq(doc.get_line_text(), 'abcdef')
doc.set_cursor_pos(8)
tassert_eq(doc.get_line_at_cursor(), 2)
tassert_eq(doc.get_line_text(), '')

doc.set_text('a\r\nb\n')
tassert_eq(doc.get_char_count(), 5)
tassert_eq(doc.get_line_count(), 3)
tassert_eq(doc.get_line_at_pos(1), 1)
tassert_eq(doc.get_line_at_pos(2), 1)
tassert_eq(doc.get_line_at_pos(3), 1)
tassert_eq(doc.get_line_at_pos(4), 2)
tassert_eq(doc.get_line_at_pos(5), 2)
tassert_eq(doc.get_line_at_pos(6), 3)
tassert_eq(doc.get_pos_at_line(1).get_offset(), 1)
tassert_eq(doc.get_pos_at_line_end(1).get_offset(), 2)
tassert_eq(doc.get_pos_at_line(2).get_offset(), 4)
tassert_eq(doc.get_pos_at_line_end(2).get_offset(), 5)
tassert_eq(doc.get_pos_at_line(3).get_offset(), 6)
tassert_eq(doc.get_pos_at_line_end(3).get_offset(), 6)
tassert_eq(doc.get_line_text(1), 'a')
tassert_eq(doc.get_line_text(2), 'b')
tassert_eq(doc.get_line_text(3), '')

-- doc.set_text('a\r\nb\n')
-- tassert_eq(doc.next_pos(1), 2)
-- tassert_eq(doc.next_pos(2), 4)
-- tassert_eq(doc.next_pos(4), 5)
-- tassert_eq(doc.next_pos(5), 6)
-- tassert_eq(doc.prev_pos(2), 1)
-- tassert_eq(doc.prev_pos(4), 2)
-- tassert_eq(doc.prev_pos(5), 4)
-- tassert_eq(doc.prev_pos(6), 5)
-- tassert_eq(doc.is_cursor_pos(1), true)
-- tassert_eq(doc.is_cursor_pos(2), true)
-- tassert_eq(doc.is_cursor_pos(3), false)
-- tassert_eq(doc.is_cursor_pos(4), true)
-- tassert_eq(doc.is_cursor_pos(5), true)
-- tassert_eq(doc.is_cursor_pos(6), false)
-- tassert_eq(doc.is_end_pos(4), false)
-- tassert_eq(doc.is_end_pos(6), true)
-- tassert_eq(doc.get_end_pos(), 6)

-- doc.set_text('ÀAA\204\128')
-- tassert_eq(doc.next_pos(1), 2)
-- tassert_eq(doc.next_pos(2), 3)
-- tassert_eq(doc.next_pos(3), 5)
-- tassert_eq(doc.prev_pos(5), 3)
-- tassert_eq(doc.prev_pos(3), 2)
-- tassert_eq(doc.prev_pos(2), 1)
-- tassert_eq(doc.is_cursor_pos(1), true)
-- tassert_eq(doc.is_cursor_pos(2), true)
-- tassert_eq(doc.is_cursor_pos(3), true)
-- tassert_eq(doc.is_cursor_pos(4), false)
-- tassert_eq(doc.is_end_pos(4), false)
-- tassert_eq(doc.is_end_pos(5), true)
-- tassert_eq(doc.get_end_pos(), 5)

doc.set_modified(false)
doc.close()
