/*
 * Copyright (C) 2013 Canonical, Ltd.
 *
 * Authors:
 *    Jussi Pakkanen <jussi.pakkanen@canonical.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef MEDIASTORE_HH_
#define MEDIASTORE_HH_

#include"scannercore.hh"
#include<vector>
#include<string>

namespace mediascanner {

struct MediaStorePrivate;
class MediaFile;
class Album;

enum OpenType {
    MS_READ_ONLY,
    MS_READ_WRITE
};

class MediaStore final {
private:
    MediaStorePrivate *p;

public:
    MediaStore(OpenType access, const std::string &retireprefix="");
    MediaStore(const std::string &filename, OpenType access, const std::string &retireprefix="");
    MediaStore(const MediaStore &other) = delete;
    MediaStore operator=(const MediaStore &other) = delete;
    ~MediaStore();

    void insert(const MediaFile &m) const;
    void remove(const std::string &fname) const;
    MediaFile lookup(const std::string &filename) const;
    std::vector<MediaFile> query(const std::string &q, MediaType type, int limit=-1) const;
    std::vector<Album> queryAlbums(const std::string &core_term, int limit=-1) const;
    std::vector<MediaFile> getAlbumSongs(const Album& album) const;
    std::string getETag(const std::string &filename) const;
    std::vector<MediaFile> listSongs(const std::string& artist="", const std::string& album="", const std::string& album_artist="", int limit=-1) const;
    std::vector<Album> listAlbums(const std::string& artist="", const std::string& album_artist="", int limit=-1) const;
    std::vector<std::string> listArtists(bool album_artists, int limit=-1);

    size_t size() const;
    void pruneDeleted();
    void archiveItems(const std::string &prefix);
    void restoreItems(const std::string &prefix);
};

}

#endif
