# Find ESRI SDE
#
# If it's found it sets SDE_FOUND to TRUE
# and following variables are set:
#    SDE_INCLUDE_DIRS
#    SDE_LIBRARIES


FIND_PATH(SDE_INCLUDE_DIR sdetype.h
    PATHS ${SDE_DIR}
    PATH_SUFFIXES include arcsde/coverages/include
)

if(SDE_VERSION STREQUAL "91")
  FIND_LIBRARY(SDE_LIBRARY NAMES sde91 PATHS ${SDE_DIR} PATH_SUFFIXES lib lib64)
  FIND_LIBRARY(PE_LIBRARY NAMES pe91 PATHS ${SDE_DIR} PATH_SUFFIXES lib lib64)
  FIND_LIBRARY(SG_LIBRARY NAMES sg91 PATHS ${SDE_DIR} PATH_SUFFIXES lib lib64)
else(SDE_VERSION STREQUAL "91")
  FIND_LIBRARY(SDE_LIBRARY NAMES sde PATHS ${SDE_DIR} PATH_SUFFIXES lib lib64)
  FIND_LIBRARY(PE_LIBRARY NAMES pe PATHS ${SDE_DIR} PATH_SUFFIXES lib lib64)
  FIND_LIBRARY(SG_LIBRARY NAMES sg PATHS ${SDE_DIR} PATH_SUFFIXES lib lib64)
endif(SDE_VERSION STREQUAL "91")

FIND_LIBRARY(SDE_DL_LIBRARY NAMES dl)
FIND_LIBRARY(SDE_SOCKET_LIBRARY NAMES socket)
FIND_LIBRARY(SDE_PTHREAD_LIBRARY NAMES pthread)

set(SDE_LIBRARIES ${SDE_LIBRARY} ${PE_LIBRARY} ${SG_LIBRARY})
if(SDE_DL_LIBRARY)
  set(SDE_LIBRARIES ${SDE_LIBRARIES} dl)
endif(SDE_DL_LIBRARY)
if(SDE_SOCKET_LIBRARY)
  set(SDE_LIBRARIES ${SDE_LIBRARIES} socket)
endif(SDE_SOCKET_LIBRARY)
if(SDE_PTHREAD_LIBRARY)
  set(SDE_LIBRARIES ${SDE_LIBRARIES} pthread)
endif(SDE_PTHREAD_LIBRARY)

set(SDE_INCLUDE_DIRS ${SDE_INCLUDE_DIR})

include(FindPackageHandleStandardArgs)
find_package_handle_standard_args(SDE DEFAULT_MSG SDE_LIBRARIES SDE_INCLUDE_DIRS)
mark_as_advanced(SDE_LIBRARIES SDE_INCLUDE_DIRS)
