# coding: utf-8

"""
Copyright 2015 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.
"""

from pprint import pformat
from six import iteritems


class V1ObjectMeta(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        Swagger model

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'name': 'str',
            'generate_name': 'str',
            'namespace': 'str',
            'self_link': 'str',
            'uid': 'str',
            'resource_version': 'str',
            'generation': 'int',
            'creation_timestamp': 'str',
            'deletion_timestamp': 'str',
            'labels': 'str',
            'annotations': 'str'
        }

        self.attribute_map = {
            'name': 'name',
            'generate_name': 'generateName',
            'namespace': 'namespace',
            'self_link': 'selfLink',
            'uid': 'uid',
            'resource_version': 'resourceVersion',
            'generation': 'generation',
            'creation_timestamp': 'creationTimestamp',
            'deletion_timestamp': 'deletionTimestamp',
            'labels': 'labels',
            'annotations': 'annotations'
        }

        self._name = None
        self._generate_name = None
        self._namespace = None
        self._self_link = None
        self._uid = None
        self._resource_version = None
        self._generation = None
        self._creation_timestamp = None
        self._deletion_timestamp = None
        self._labels = None
        self._annotations = None

    @property
    def name(self):
        """
        Gets the name of this V1ObjectMeta.
        string that identifies an object. Must be unique within a namespace; cannot be updated; see http://releases.k8s.io/v1.0.4/docs/identifiers.md#names

        :return: The name of this V1ObjectMeta.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this V1ObjectMeta.
        string that identifies an object. Must be unique within a namespace; cannot be updated; see http://releases.k8s.io/v1.0.4/docs/identifiers.md#names

        :param name: The name of this V1ObjectMeta.
        :type: str
        """
        self._name = name

    @property
    def generate_name(self):
        """
        Gets the generate_name of this V1ObjectMeta.
        an optional prefix to use to generate a unique name; has the same validation rules as name; optional, and is applied only name if is not specified; see http://releases.k8s.io/v1.0.4/docs/api-conventions.md#idempotency

        :return: The generate_name of this V1ObjectMeta.
        :rtype: str
        """
        return self._generate_name

    @generate_name.setter
    def generate_name(self, generate_name):
        """
        Sets the generate_name of this V1ObjectMeta.
        an optional prefix to use to generate a unique name; has the same validation rules as name; optional, and is applied only name if is not specified; see http://releases.k8s.io/v1.0.4/docs/api-conventions.md#idempotency

        :param generate_name: The generate_name of this V1ObjectMeta.
        :type: str
        """
        self._generate_name = generate_name

    @property
    def namespace(self):
        """
        Gets the namespace of this V1ObjectMeta.
        namespace of the object; must be a DNS_LABEL; cannot be updated; see http://releases.k8s.io/v1.0.4/docs/namespaces.md

        :return: The namespace of this V1ObjectMeta.
        :rtype: str
        """
        return self._namespace

    @namespace.setter
    def namespace(self, namespace):
        """
        Sets the namespace of this V1ObjectMeta.
        namespace of the object; must be a DNS_LABEL; cannot be updated; see http://releases.k8s.io/v1.0.4/docs/namespaces.md

        :param namespace: The namespace of this V1ObjectMeta.
        :type: str
        """
        self._namespace = namespace

    @property
    def self_link(self):
        """
        Gets the self_link of this V1ObjectMeta.
        URL for the object; populated by the system, read-only

        :return: The self_link of this V1ObjectMeta.
        :rtype: str
        """
        return self._self_link

    @self_link.setter
    def self_link(self, self_link):
        """
        Sets the self_link of this V1ObjectMeta.
        URL for the object; populated by the system, read-only

        :param self_link: The self_link of this V1ObjectMeta.
        :type: str
        """
        self._self_link = self_link

    @property
    def uid(self):
        """
        Gets the uid of this V1ObjectMeta.
        unique UUID across space and time; populated by the system; read-only; see http://releases.k8s.io/v1.0.4/docs/identifiers.md#uids

        :return: The uid of this V1ObjectMeta.
        :rtype: str
        """
        return self._uid

    @uid.setter
    def uid(self, uid):
        """
        Sets the uid of this V1ObjectMeta.
        unique UUID across space and time; populated by the system; read-only; see http://releases.k8s.io/v1.0.4/docs/identifiers.md#uids

        :param uid: The uid of this V1ObjectMeta.
        :type: str
        """
        self._uid = uid

    @property
    def resource_version(self):
        """
        Gets the resource_version of this V1ObjectMeta.
        string that identifies the internal version of this object that can be used by clients to determine when objects have changed; populated by the system, read-only; value must be treated as opaque by clients and passed unmodified back to the server: http://releases.k8s.io/v1.0.4/docs/api-conventions.md#concurrency-control-and-consistency

        :return: The resource_version of this V1ObjectMeta.
        :rtype: str
        """
        return self._resource_version

    @resource_version.setter
    def resource_version(self, resource_version):
        """
        Sets the resource_version of this V1ObjectMeta.
        string that identifies the internal version of this object that can be used by clients to determine when objects have changed; populated by the system, read-only; value must be treated as opaque by clients and passed unmodified back to the server: http://releases.k8s.io/v1.0.4/docs/api-conventions.md#concurrency-control-and-consistency

        :param resource_version: The resource_version of this V1ObjectMeta.
        :type: str
        """
        self._resource_version = resource_version

    @property
    def generation(self):
        """
        Gets the generation of this V1ObjectMeta.
        a sequence number representing a specific generation of the desired state; populated by the system; read-only

        :return: The generation of this V1ObjectMeta.
        :rtype: int
        """
        return self._generation

    @generation.setter
    def generation(self, generation):
        """
        Sets the generation of this V1ObjectMeta.
        a sequence number representing a specific generation of the desired state; populated by the system; read-only

        :param generation: The generation of this V1ObjectMeta.
        :type: int
        """
        self._generation = generation

    @property
    def creation_timestamp(self):
        """
        Gets the creation_timestamp of this V1ObjectMeta.
        RFC 3339 date and time at which the object was created; populated by the system, read-only; null for lists; see http://releases.k8s.io/v1.0.4/docs/api-conventions.md#metadata

        :return: The creation_timestamp of this V1ObjectMeta.
        :rtype: str
        """
        return self._creation_timestamp

    @creation_timestamp.setter
    def creation_timestamp(self, creation_timestamp):
        """
        Sets the creation_timestamp of this V1ObjectMeta.
        RFC 3339 date and time at which the object was created; populated by the system, read-only; null for lists; see http://releases.k8s.io/v1.0.4/docs/api-conventions.md#metadata

        :param creation_timestamp: The creation_timestamp of this V1ObjectMeta.
        :type: str
        """
        self._creation_timestamp = creation_timestamp

    @property
    def deletion_timestamp(self):
        """
        Gets the deletion_timestamp of this V1ObjectMeta.
        RFC 3339 date and time at which the object will be deleted; populated by the system when a graceful deletion is requested, read-only; if not set, graceful deletion of the object has not been requested; see http://releases.k8s.io/v1.0.4/docs/api-conventions.md#metadata

        :return: The deletion_timestamp of this V1ObjectMeta.
        :rtype: str
        """
        return self._deletion_timestamp

    @deletion_timestamp.setter
    def deletion_timestamp(self, deletion_timestamp):
        """
        Sets the deletion_timestamp of this V1ObjectMeta.
        RFC 3339 date and time at which the object will be deleted; populated by the system when a graceful deletion is requested, read-only; if not set, graceful deletion of the object has not been requested; see http://releases.k8s.io/v1.0.4/docs/api-conventions.md#metadata

        :param deletion_timestamp: The deletion_timestamp of this V1ObjectMeta.
        :type: str
        """
        self._deletion_timestamp = deletion_timestamp

    @property
    def labels(self):
        """
        Gets the labels of this V1ObjectMeta.
        map of string keys and values that can be used to organize and categorize objects; may match selectors of replication controllers and services; see http://releases.k8s.io/v1.0.4/docs/labels.md

        :return: The labels of this V1ObjectMeta.
        :rtype: str
        """
        return self._labels

    @labels.setter
    def labels(self, labels):
        """
        Sets the labels of this V1ObjectMeta.
        map of string keys and values that can be used to organize and categorize objects; may match selectors of replication controllers and services; see http://releases.k8s.io/v1.0.4/docs/labels.md

        :param labels: The labels of this V1ObjectMeta.
        :type: str
        """
        self._labels = labels

    @property
    def annotations(self):
        """
        Gets the annotations of this V1ObjectMeta.
        map of string keys and values that can be used by external tooling to store and retrieve arbitrary metadata about objects; see http://releases.k8s.io/v1.0.4/docs/annotations.md

        :return: The annotations of this V1ObjectMeta.
        :rtype: str
        """
        return self._annotations

    @annotations.setter
    def annotations(self, annotations):
        """
        Sets the annotations of this V1ObjectMeta.
        map of string keys and values that can be used by external tooling to store and retrieve arbitrary metadata about objects; see http://releases.k8s.io/v1.0.4/docs/annotations.md

        :param annotations: The annotations of this V1ObjectMeta.
        :type: str
        """
        self._annotations = annotations

    def to_dict(self):
        """
        Return model properties dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Return model properties str
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()
