
/******************************  LICENSE  *******************************

 * (C) Copyright 1996-2017 ECMWF.
 *
 * This software is licensed under the terms of the Apache Licence Version 2.0
 * which can be obtained at http://www.apache.org/licenses/LICENSE-2.0.
 * In applying this licence, ECMWF does not waive the privileges and immunities
 * granted to it by virtue of its status as an intergovernmental organisation nor
 * does it submit to any jurisdiction.

 *******************************  LICENSE  *******************************/

/*! \\file PostScriptDriverAttributes.h
    \\brief Definition of PostScriptDriver Attributes class.

    This file is automatically generated.
    Do Not Edit!

*/

#include "MagRequest.h"
#include "PostScriptDriverWrapper.h"
#include "MagicsParameter.h"
#include "Factory.h"
#include "MagTranslator.h"
#include "MagicsGlobal.h"

using namespace magics;



PostScriptDriverWrapper::PostScriptDriverWrapper(): postscriptdriver_(new PostScriptDriver())


{


	
	BaseDriverWrapper::object(postscriptdriver_);
	

}
PostScriptDriverWrapper::PostScriptDriverWrapper(PostScriptDriver* postscriptdriver): postscriptdriver_(postscriptdriver)
{

	
	BaseDriverWrapper::object(postscriptdriver_);
	
}

PostScriptDriverWrapper::~PostScriptDriverWrapper()
{

}

void PostScriptDriverWrapper::set(const MagRequest& request)
{

	

	BaseDriverWrapper::set(request);
	

	if  (request.countValues("OUTPUT_PS_COLOUR_MODEL") ) {
		string colour_model_value = request("OUTPUT_PS_COLOUR_MODEL");
		postscriptdriver_->colour_model_ = colour_model_value;
		}
	if  (request.countValues("OUTPUT_PS_SCALE") ) {
		double scale_value = request("OUTPUT_PS_SCALE");
		postscriptdriver_->scale_ = scale_value;
		}
	if  (request.countValues("OUTPUT_PS_SPLIT") ) {
		string split_value = request("OUTPUT_PS_SPLIT");
		
		postscriptdriver_->split_ = MagTranslator<string, bool>()(split_value);
		
		}
	
	
}

void PostScriptDriverWrapper::print(ostream& out)  const
{
	out << "PostScriptDriverWrapper[]";
}


