
/*******************************  LICENSE  *******************************

 * (C) Copyright 1996-2016 ECMWF.
 * 
 * This software is licensed under the terms of the Apache Licence Version 2.0
 * which can be obtained at http://www.apache.org/licenses/LICENSE-2.0. 
 * In applying this licence, ECMWF does not waive the privileges and immunities 
 * granted to it by virtue of its status as an intergovernmental organisation nor
 * does it submit to any jurisdiction.

 *******************************  LICENSE  *******************************/

/*! \fileCitiesAttributes.h
    \brief Definition of Cities Attributes class.

    This file is automatically generated.
    Do Not Edit!

    Generated: 
*/
   

#ifndef CitiesAttributes_H
#define CitiesAttributes_H

#include "magics.h"
#include "Colour.h"
namespace magics {

class XmlNode;
class CitiesAttributes 
{
public:
//  --  constructor
    CitiesAttributes();
    
//  --  destructor
    virtual ~CitiesAttributes();
    
    virtual void set(const std::map<std::string, std::string>&);
    virtual void set(const XmlNode&);
    virtual void copy(const CitiesAttributes&);
    virtual bool accept(const std::string&);

    void setTag(const std::string& tag) { tag_ = tag; }

public:
	//  --  method
	virtual void print(std::ostream&) const;
	virtual void toxml(std::ostream& out) const;
	//  --  members:
	string tag_;
	string unit_;
	string font_name_;
	string font_style_;
	bool blanking_;
	double font_size_;
	string position_;
	string marker_;
	double marker_height_;
	unique_ptr<Colour> font_colour_;
	unique_ptr<Colour> marker_colour_;
	 

private:
	friend ostream& operator<<(ostream& s,const CitiesAttributes& p)
	{ p.print(s); return s; }
};

} // namespace magics

#endif

