/*
    VLDocking Framework 2.1
    Copyright VLSOLUTIONS, 2004-2006

    email : info@vlsolutions.com
------------------------------------------------------------------------
This software is distributed under the CeCILL license, a GNU GPL-compatible
license adapted to french law.
French and English license headers are provided at the begining of
the source files of this software application.
------------------------------------------------------------------------
LICENCE CeCILL (FRENCH VERSION).
------------------------------------------------------------------------
Ce logiciel est un programme informatique servant  amliorer les interfaces
homme-machine d'applications Java bases sur Swing, en leur apportant un
ensemble de fonctions relatives au dockage des composants.

Ce logiciel est rgi par la licence CeCILL soumise au droit franais et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL telle que diffuse par le CEA, le CNRS et l'INRIA
sur le site "http://www.cecill.info".

En contrepartie de l'accessibilit au code source et des droits de copie,
de modification et de redistribution accords par cette licence, il n'est
offert aux utilisateurs qu'une garantie limite.  Pour les mmes raisons,
seule une responsabilit restreinte pse sur l'auteur du programme,  le
titulaire des droits patrimoniaux et les concdants successifs.

A cet gard  l'attention de l'utilisateur est attire sur les risques
associs au chargement,   l'utilisation,   la modification et/ou au
dveloppement et  la reproduction du logiciel par l'utilisateur tant
donn sa spcificit de logiciel libre, qui peut le rendre complexe 
manipuler et qui le rserve donc  des dveloppeurs et des professionnels
avertis possdant  des  connaissances  informatiques approfondies.  Les
utilisateurs sont donc invits  charger  et  tester  l'adquation  du
logiciel  leurs besoins dans des conditions permettant d'assurer la
scurit de leurs systmes et ou de leurs donnes et, plus gnralement,
 l'utiliser et l'exploiter dans les mmes conditions de scurit.

Le fait que vous puissiez accder  cet en-tte signifie que vous avez
pris connaissance de la licence CeCILL, et que vous en avez accept les
termes.

------------------------------------------------------------------------
CeCILL License (ENGLISH VERSION)
------------------------------------------------------------------------

This software is a computer program whose purpose is to enhance Human-Computer
Interfaces written in Java with the Swing framework, providing them a set of
functions related to component docking.

This software is governed by the CeCILL  license under French law and
abiding by the rules of distribution of free software.  You can  use,
modify and/ or redistribute the software under the terms of the CeCILL
license as circulated by CEA, CNRS and INRIA at the following URL
"http://www.cecill.info".

As a counterpart to the access to the source code and  rights to copy,
modify and redistribute granted by the license, users are provided only
with a limited warranty  and the software's author,  the holder of the
economic rights,  and the successive licensors  have only  limited
liability.

In this respect, the user's attention is drawn to the risks associated
with loading,  using,  modifying and/or developing or reproducing the
software by the user in light of its specific status of free software,
that may mean  that it is complicated to manipulate,  and  that  also
therefore means  that it is reserved for developers  and  experienced
professionals having in-depth computer knowledge. Users are therefore
encouraged to load and test the software's suitability as regards their
requirements in conditions enabling the security of their systems and/or
data to be ensured and,  more generally, to use and operate it in the
same conditions as regards security.

The fact that you are presently reading this means that you have had
knowledge of the CeCILL license and that you accept its terms.

*/


package com.vlsolutions.swing.docking;

import javax.swing.*;
import javax.swing.border.Border;
import java.awt.event.ActionEvent;
import java.awt.Font;
import java.awt.event.MouseListener;
import java.awt.event.ActionListener;
import java.awt.Component;
import java.awt.Insets;
import java.awt.Graphics2D;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.FontMetrics;
import java.awt.Color;
import java.beans.*;

/** The button used to show Dockables in auto-hide borders.
 * <p>
 * This component displays the label, tooltip and icon properties of a
 * <code>Dockable</code>'s DockKey, with a custom look and feel.
 *
 *
 * @author Lilian Chamontin, vlsolutions.
 * @version 1.0
 */
public class AutoHideButton extends JLabel {
  
  /** property name associated to the "zone" (border) property */
  public static final String PROPERTY_ZONE = "autohide.zone";
  
  public static final String uiClassID = "AutoHideButtonUI";


  private boolean selected = false;
  private DockKey key;
  private Dockable dockable;


  private int zone; // the border used

  private boolean isNotification = false;
  private Timer notificationTimer; // blinking timer
  private int blinkCount = 0;
  private int MAX_BLINKS = UIManager.getInt("DockingDesktop.notificationBlinkCount");
  

  private PropertyChangeListener keyListener =  new PropertyChangeListener(){
    // this is a DockKey listener, not a KeyEvent listener...
    public void propertyChange(PropertyChangeEvent e) {
      if (e.getPropertyName().equals(DockKey.PROPERTY_NAME)){
        setText((String)e.getNewValue());
      } else if (e.getPropertyName().equals(DockKey.PROPERTY_TOOLTIP)){
        setToolTipText((String)e.getNewValue());
      } else if (e.getPropertyName().equals(DockKey.PROPERTY_ICON)){
        setIcon((Icon) e.getNewValue());
      } else if (e.getPropertyName().equals(DockKey.PROPERTY_NOTIFICATION)){
        boolean isOn = ((Boolean)e.getNewValue()).booleanValue();
        if (isOn){

          if (notificationTimer == null){
           notificationTimer = new Timer(1000,
                new ActionListener() {
              public void actionPerformed(ActionEvent actionEvent) {
                setNotification(!isNotification);
                if (!isNotification){
                  blinkCount ++;
                  if (blinkCount >= MAX_BLINKS){
                    blinkCount = 0;
                    notificationTimer.stop(); // enough blinking
                  }
                }
                repaint();
              }
            });
          }

          setNotification(true);
          notificationTimer.restart();
        } else {
          if (notificationTimer != null){
            notificationTimer.stop();
            blinkCount = 0;
          }
          setNotification(false);
        }
      }
    }
  };

  public AutoHideButton() {
  }

  /** Sets the background color according to the <code>notification</code> boolean */
  private void setNotification(boolean notification){
    this.isNotification = notification;
    if (notification){
      setBackground(UIManager.getColor("DockingDesktop.notificationColor")); 
      setOpaque(true);
    } else {
      setOpaque(false);
    }
    repaint();
  }

  /** Returns the dockable this button is for */
  public Dockable getDockable(){
    return dockable;
  }

  /** Returns the key of the dockable */
  public DockKey getKey(){
    return key;
  }


  /** Initialize the button for a Dockable and a border zone  */
  public void init(Dockable dockable, int zone){
    DockKey key = dockable.getDockKey();
    this.dockable = dockable;
    this.key = key;

    int oldZone = this.zone;
    this.zone = zone;    
    firePropertyChange("autohide.zone", oldZone, zone);

    key.addPropertyChangeListener(keyListener);

    setText(key.getName());
    setToolTipText(key.getTooltip());
    if (key.getIcon() != null) {
      setIcon(key.getIcon());
    }

    setFocusable(true);

    setOpaque(false);

    setIconTextGap(4);
    setAlignmentY(1);
  }


  public Dimension getPreferredSize() {
    if (zone == DockingConstants.INT_HIDE_TOP
        || zone == DockingConstants.INT_HIDE_BOTTOM) {
      return super.getPreferredSize();
    } else {
      Dimension d = super.getPreferredSize();
      Insets i = getInsets();
      return new Dimension(d.height - i.top - i.bottom + i.left + i.right,
          d.width - i.left - i.right + i.top + i.bottom); // rotate the shape
    }
  }

  public Dimension getMaximumSize() {
    if (zone == DockingConstants.INT_HIDE_TOP
        || zone == DockingConstants.INT_HIDE_BOTTOM) {
      return super.getMaximumSize();
    } else {
      Insets i = getInsets();
      Dimension d = super.getMaximumSize();
      return new Dimension(d.height - i.top - i.bottom + i.left + i.right,
          d.width - i.left - i.right + i.top + i.bottom); // rotate the shape
    }
  }

  public Dimension getMinimumSize() {
    if (zone == DockingConstants.INT_HIDE_TOP
        || zone == DockingConstants.INT_HIDE_BOTTOM) {
      return super.getMinimumSize();
    } else {
      Insets i = getInsets();
      Dimension d = super.getMinimumSize();
      return new Dimension(d.height - i.top - i.bottom + i.left + i.right,
          d.width - i.left - i.right + i.top + i.bottom); // rotate the shape
    }
  }

  

  /** Returns the border zone of this button*/
  public int getZone(){
    return zone;
  }

  /** True when the button is currently selected. */
  public boolean isSelected(){
    return selected;
  }

  /** Selects or unselects the button */
  public void setSelected(boolean selected){
    this.selected = selected;
    setOpaque(selected);
    repaint();
    if (selected){
      key.setNotification(false); // in case we were in notification mode
    }
  }

  public String getUIClassID() {
    return uiClassID;
  }
  



}
