/* ***************************************************************************
 *
 * Pico Technology USB Device Driver
 *
 *//**
 * \file      PicoDownloader_Linux.h 
 * \brief     Background firmware downloader for Pico products: Linux-specific implementation
 **//*
 *
 * Copyright (c) 2007, Pico Technology.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *  * The name of Pico Technology may not be used to endorse or promote
 *    products derived from this software without specific prior written
 *    permission.
 *
 * THIS SOFTWARE IS PROVIDED BY PICO TECHNOLOGY "AS IS" AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL PICO TECHNOLOGY BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * Version $Id: PicoDownloader_Linux.h,v 1.4 2008/02/13 20:14:49 douglas Exp $
 *
 *************************************************************************** */

/* Determine OS type */
#include "PicoPortability.h"

/* Ignore this header if we are not compiling for Linux */
#ifdef PICO_OS_LINUX

/* Avoid including this header more than once */
#ifndef PICODOWNLOADER_LINUX_H
#define PICODOWNLOADER_LINUX_H

#include <unistd.h>
#include <pthread.h>

#include "IntelHexRecord.h"
#include "PicoDownloader.h"
////////////////////////////////////////////////////////////////////////////////
/// A Linux-specific implementation of the PicoDownloader interface. There is 
/// no device-attachment notification facility on Linux so we poll continually 
/// for new devices and download firmware, all using libusb.
////////////////////////////////////////////////////////////////////////////////
class PicoDownloader_Linux : PicoDownloader
{
public:
	PicoDownloader_Linux(std::vector<DeviceSpec *> devices);
	int InitialDeviceCount(void);
	~PicoDownloader_Linux(void);
private:
	std::vector<DeviceSpec *> devicelist;

	/// Interval in microseconds at which to poll for new devices.
	/// Suggest about 500000 (0.5s) as a reasonble compromise between 
	/// responsivity and CPU usage.
	static const unsigned long pollInterval = 500000;

	/// Thread in which we will poll for new devices
	pthread_t * thread;
	/// Flag to indicate to the downloader thread that it should terminate
	bool threadStop;
	/// Flag to indicate to the calling thread that the downloader is exiting
	bool threadStopping;
	/// Mutex to protect the threading flags
	pthread_mutex_t *threadStopMutex;

	/// Flag indicating whether we have finished downloading firmware to 
	/// all matching devices which were found in the first poll after startup
	bool initialized;
	/// Count of the devices to which we downloaded firmware in the first poll
	/// after startup. Only valid once initialized is true.
	int initialDevices;
	/// Mutex to protect the initial device variables
	pthread_mutex_t *initialDeviceMutex;

	// Private functions
	/// Function started in new thread by constructor. Just calls DownloadThread()
	static void *threadProc(void *args);
	/// The polling-for-devices function
	void DownloadThread(void);
};

#endif /* not defined PICODOWNLOADER_LINUX_H */

#endif /* not defined PICO_OS_LINUX */
