/** @file cmdline.h
 *  @brief The header file for the command line option parser
 *  generated by GNU Gengetopt version 2.23
 *  http://www.gnu.org/software/gengetopt.
 *  DO NOT modify this file, since it can be overwritten
 *  @author GNU Gengetopt */

#ifndef CMDLINE_H
#define CMDLINE_H

/* If we use autoconf.  */
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h> /* for FILE */

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#ifndef CMDLINE_PARSER_PACKAGE
/** @brief the program name (used for printing errors) */
#define CMDLINE_PARSER_PACKAGE PACKAGE
#endif

#ifndef CMDLINE_PARSER_PACKAGE_NAME
/** @brief the complete program name (used for help and version) */
#ifdef PACKAGE_NAME
#define CMDLINE_PARSER_PACKAGE_NAME PACKAGE_NAME
#else
#define CMDLINE_PARSER_PACKAGE_NAME PACKAGE
#endif
#endif

#ifndef CMDLINE_PARSER_VERSION
/** @brief the program version */
#define CMDLINE_PARSER_VERSION VERSION
#endif

/** @brief Where the command line options are stored */
struct gengetopt_args_info
{
  const char *help_help; /**< @brief Print help and exit help description.  */
  const char *version_help; /**< @brief Print version and exit help description.  */
  char * fipid_arg;	/**< @brief FI partner identifier (looks up fid, org & url from partner server).  */
  char * fipid_orig;	/**< @brief FI partner identifier (looks up fid, org & url from partner server) original value given at command line.  */
  const char *fipid_help; /**< @brief FI partner identifier (looks up fid, org & url from partner server) help description.  */
  char * fid_arg;	/**< @brief FI identifier.  */
  char * fid_orig;	/**< @brief FI identifier original value given at command line.  */
  const char *fid_help; /**< @brief FI identifier help description.  */
  char * org_arg;	/**< @brief FI org tag.  */
  char * org_orig;	/**< @brief FI org tag original value given at command line.  */
  const char *org_help; /**< @brief FI org tag help description.  */
  char * bank_arg;	/**< @brief IBAN bank identifier.  */
  char * bank_orig;	/**< @brief IBAN bank identifier original value given at command line.  */
  const char *bank_help; /**< @brief IBAN bank identifier help description.  */
  char * broker_arg;	/**< @brief Broker identifier.  */
  char * broker_orig;	/**< @brief Broker identifier original value given at command line.  */
  const char *broker_help; /**< @brief Broker identifier help description.  */
  char * user_arg;	/**< @brief User name.  */
  char * user_orig;	/**< @brief User name original value given at command line.  */
  const char *user_help; /**< @brief User name help description.  */
  char * pass_arg;	/**< @brief Password.  */
  char * pass_orig;	/**< @brief Password original value given at command line.  */
  const char *pass_help; /**< @brief Password help description.  */
  char * acct_arg;	/**< @brief Account ID.  */
  char * acct_orig;	/**< @brief Account ID original value given at command line.  */
  const char *acct_help; /**< @brief Account ID help description.  */
  int type_arg;	/**< @brief Account Type 1=checking 2=invest 3=ccard.  */
  char * type_orig;	/**< @brief Account Type 1=checking 2=invest 3=ccard original value given at command line.  */
  const char *type_help; /**< @brief Account Type 1=checking 2=invest 3=ccard help description.  */
  long past_arg;	/**< @brief How far back to look from today (in days).  */
  char * past_orig;	/**< @brief How far back to look from today (in days) original value given at command line.  */
  const char *past_help; /**< @brief How far back to look from today (in days) help description.  */
  char * url_arg;	/**< @brief Url to POST the data to (otherwise goes to stdout).  */
  char * url_orig;	/**< @brief Url to POST the data to (otherwise goes to stdout) original value given at command line.  */
  const char *url_help; /**< @brief Url to POST the data to (otherwise goes to stdout) help description.  */
  int trid_arg;	/**< @brief Transaction id.  */
  char * trid_orig;	/**< @brief Transaction id original value given at command line.  */
  const char *trid_help; /**< @brief Transaction id help description.  */
  const char *statement_req_help; /**< @brief Request for a statement help description.  */
  const char *accountinfo_req_help; /**< @brief Request for a list of accounts help description.  */
  const char *payment_req_help; /**< @brief Request to make a payment help description.  */
  const char *paymentinquiry_req_help; /**< @brief Request to inquire about the status of a payment help description.  */
  const char *bank_list_help; /**< @brief List all known banks help description.  */
  const char *bank_fipid_help; /**< @brief List all fipids for a given bank help description.  */
  const char *bank_services_help; /**< @brief List supported services for a given fipid help description.  */
  const char *allsupport_help; /**< @brief List all banks which support online banking help description.  */
  
  unsigned int help_given ;	/**< @brief Whether help was given.  */
  unsigned int version_given ;	/**< @brief Whether version was given.  */
  unsigned int fipid_given ;	/**< @brief Whether fipid was given.  */
  unsigned int fid_given ;	/**< @brief Whether fid was given.  */
  unsigned int org_given ;	/**< @brief Whether org was given.  */
  unsigned int bank_given ;	/**< @brief Whether bank was given.  */
  unsigned int broker_given ;	/**< @brief Whether broker was given.  */
  unsigned int user_given ;	/**< @brief Whether user was given.  */
  unsigned int pass_given ;	/**< @brief Whether pass was given.  */
  unsigned int acct_given ;	/**< @brief Whether acct was given.  */
  unsigned int type_given ;	/**< @brief Whether type was given.  */
  unsigned int past_given ;	/**< @brief Whether past was given.  */
  unsigned int url_given ;	/**< @brief Whether url was given.  */
  unsigned int trid_given ;	/**< @brief Whether trid was given.  */
  unsigned int statement_req_given ;	/**< @brief Whether statement-req was given.  */
  unsigned int accountinfo_req_given ;	/**< @brief Whether accountinfo-req was given.  */
  unsigned int payment_req_given ;	/**< @brief Whether payment-req was given.  */
  unsigned int paymentinquiry_req_given ;	/**< @brief Whether paymentinquiry-req was given.  */
  unsigned int bank_list_given ;	/**< @brief Whether bank-list was given.  */
  unsigned int bank_fipid_given ;	/**< @brief Whether bank-fipid was given.  */
  unsigned int bank_services_given ;	/**< @brief Whether bank-services was given.  */
  unsigned int allsupport_given ;	/**< @brief Whether allsupport was given.  */

  char **inputs ; /**< @brief unnamed options (options without names) */
  unsigned inputs_num ; /**< @brief unnamed options number */
  int command_group_counter; /**< @brief Counter for group command */
} ;

/** @brief The additional parameters to pass to parser functions */
struct cmdline_parser_params
{
  int override; /**< @brief whether to override possibly already present options (default 0) */
  int initialize; /**< @brief whether to initialize the option structure gengetopt_args_info (default 1) */
  int check_required; /**< @brief whether to check that all required options were provided (default 1) */
  int check_ambiguity; /**< @brief whether to check for options already specified in the option structure gengetopt_args_info (default 0) */
  int print_errors; /**< @brief whether getopt_long should print an error message for a bad option (default 1) */
} ;

/** @brief the purpose string of the program */
extern const char *gengetopt_args_info_purpose;
/** @brief the usage string of the program */
extern const char *gengetopt_args_info_usage;
/** @brief the description string of the program */
extern const char *gengetopt_args_info_description;
/** @brief all the lines making the help output */
extern const char *gengetopt_args_info_help[];

/**
 * The command line parser
 * @param argc the number of command line options
 * @param argv the command line options
 * @param args_info the structure where option information will be stored
 * @return 0 if everything went fine, NON 0 if an error took place
 */
int cmdline_parser (int argc, char **argv,
  struct gengetopt_args_info *args_info);

/**
 * The command line parser (version with additional parameters - deprecated)
 * @param argc the number of command line options
 * @param argv the command line options
 * @param args_info the structure where option information will be stored
 * @param override whether to override possibly already present options
 * @param initialize whether to initialize the option structure my_args_info
 * @param check_required whether to check that all required options were provided
 * @return 0 if everything went fine, NON 0 if an error took place
 * @deprecated use cmdline_parser_ext() instead
 */
int cmdline_parser2 (int argc, char **argv,
  struct gengetopt_args_info *args_info,
  int override, int initialize, int check_required);

/**
 * The command line parser (version with additional parameters)
 * @param argc the number of command line options
 * @param argv the command line options
 * @param args_info the structure where option information will be stored
 * @param params additional parameters for the parser
 * @return 0 if everything went fine, NON 0 if an error took place
 */
int cmdline_parser_ext (int argc, char **argv,
  struct gengetopt_args_info *args_info,
  struct cmdline_parser_params *params);

/**
 * Save the contents of the option struct into an already open FILE stream.
 * @param outfile the stream where to dump options
 * @param args_info the option struct to dump
 * @return 0 if everything went fine, NON 0 if an error took place
 */
int cmdline_parser_dump(FILE *outfile,
  struct gengetopt_args_info *args_info);

/**
 * Save the contents of the option struct into a (text) file.
 * This file can be read by the config file parser (if generated by gengetopt)
 * @param filename the file where to save
 * @param args_info the option struct to save
 * @return 0 if everything went fine, NON 0 if an error took place
 */
int cmdline_parser_file_save(const char *filename,
  struct gengetopt_args_info *args_info);

/**
 * Print the help
 */
void cmdline_parser_print_help(void);
/**
 * Print the version
 */
void cmdline_parser_print_version(void);

/**
 * Initializes all the fields a cmdline_parser_params structure 
 * to their default values
 * @param params the structure to initialize
 */
void cmdline_parser_params_init(struct cmdline_parser_params *params);

/**
 * Allocates dynamically a cmdline_parser_params structure and initializes
 * all its fields to their default values
 * @return the created and initialized cmdline_parser_params structure
 */
struct cmdline_parser_params *cmdline_parser_params_create(void);

/**
 * Initializes the passed gengetopt_args_info structure's fields
 * (also set default values for options that have a default)
 * @param args_info the structure to initialize
 */
void cmdline_parser_init (struct gengetopt_args_info *args_info);
/**
 * Deallocates the string fields of the gengetopt_args_info structure
 * (but does not deallocate the structure itself)
 * @param args_info the structure to deallocate
 */
void cmdline_parser_free (struct gengetopt_args_info *args_info);

/**
 * Checks that all the required options were specified
 * @param args_info the structure to check
 * @param prog_name the name of the program that will be used to print
 *   possible errors
 * @return
 */
int cmdline_parser_required (struct gengetopt_args_info *args_info,
  const char *prog_name);


#ifdef __cplusplus
}
#endif /* __cplusplus */
#endif /* CMDLINE_H */
