/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008, 2010 Oracle and/or its affiliates. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */
package org.odftoolkit.odfdom.dom.element.table;

import org.odftoolkit.odfdom.pkg.OdfElement;
import org.odftoolkit.odfdom.pkg.ElementVisitor;
import org.odftoolkit.odfdom.pkg.OdfFileDom;
import org.odftoolkit.odfdom.pkg.OdfName;
import org.odftoolkit.odfdom.dom.OdfDocumentNamespace;
import org.odftoolkit.odfdom.dom.DefaultElementVisitor;
import org.odftoolkit.odfdom.dom.attribute.table.TableEndPositionAttribute;
import org.odftoolkit.odfdom.dom.attribute.table.TablePositionAttribute;
import org.odftoolkit.odfdom.dom.attribute.table.TableStartPositionAttribute;

/**
 * DOM implementation of OpenDocument element  {@odf.element table:movement-cut-off}.
 *
 */
public class TableMovementCutOffElement extends OdfElement {

	public static final OdfName ELEMENT_NAME = OdfName.newName(OdfDocumentNamespace.TABLE, "movement-cut-off");

	/**
	 * Create the instance of <code>TableMovementCutOffElement</code>
	 *
	 * @param  ownerDoc     The type is <code>OdfFileDom</code>
	 */
	public TableMovementCutOffElement(OdfFileDom ownerDoc) {
		super(ownerDoc, ELEMENT_NAME);
	}

	/**
	 * Get the element name
	 *
	 * @return  return   <code>OdfName</code> the name of element {@odf.element table:movement-cut-off}.
	 */
	public OdfName getOdfName() {
		return ELEMENT_NAME;
	}

	/**
	 * Receives the value of the ODFDOM attribute representation <code>TableEndPositionAttribute</code> , See {@odf.attribute table:end-position}
	 *
	 * @return - the <code>Integer</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public Integer getTableEndPositionAttribute() {
		TableEndPositionAttribute attr = (TableEndPositionAttribute) getOdfAttribute(OdfDocumentNamespace.TABLE, "end-position");
		if (attr != null) {
			return Integer.valueOf(attr.intValue());
		}
		return null;
	}

	/**
	 * Sets the value of ODFDOM attribute representation <code>TableEndPositionAttribute</code> , See {@odf.attribute table:end-position}
	 *
	 * @param tableEndPositionValue   The type is <code>Integer</code>
	 */
	public void setTableEndPositionAttribute(Integer tableEndPositionValue) {
		TableEndPositionAttribute attr = new TableEndPositionAttribute((OdfFileDom) this.ownerDocument);
		setOdfAttribute(attr);
		attr.setIntValue(tableEndPositionValue.intValue());
	}

	/**
	 * Receives the value of the ODFDOM attribute representation <code>TablePositionAttribute</code> , See {@odf.attribute table:position}
	 *
	 * @return - the <code>Integer</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public Integer getTablePositionAttribute() {
		TablePositionAttribute attr = (TablePositionAttribute) getOdfAttribute(OdfDocumentNamespace.TABLE, "position");
		if (attr != null) {
			return Integer.valueOf(attr.intValue());
		}
		return null;
	}

	/**
	 * Sets the value of ODFDOM attribute representation <code>TablePositionAttribute</code> , See {@odf.attribute table:position}
	 *
	 * @param tablePositionValue   The type is <code>Integer</code>
	 */
	public void setTablePositionAttribute(Integer tablePositionValue) {
		TablePositionAttribute attr = new TablePositionAttribute((OdfFileDom) this.ownerDocument);
		setOdfAttribute(attr);
		attr.setIntValue(tablePositionValue.intValue());
	}

	/**
	 * Receives the value of the ODFDOM attribute representation <code>TableStartPositionAttribute</code> , See {@odf.attribute table:start-position}
	 *
	 * @return - the <code>Integer</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public Integer getTableStartPositionAttribute() {
		TableStartPositionAttribute attr = (TableStartPositionAttribute) getOdfAttribute(OdfDocumentNamespace.TABLE, "start-position");
		if (attr != null) {
			return Integer.valueOf(attr.intValue());
		}
		return null;
	}

	/**
	 * Sets the value of ODFDOM attribute representation <code>TableStartPositionAttribute</code> , See {@odf.attribute table:start-position}
	 *
	 * @param tableStartPositionValue   The type is <code>Integer</code>
	 */
	public void setTableStartPositionAttribute(Integer tableStartPositionValue) {
		TableStartPositionAttribute attr = new TableStartPositionAttribute((OdfFileDom) this.ownerDocument);
		setOdfAttribute(attr);
		attr.setIntValue(tableStartPositionValue.intValue());
	}

	@Override
	public void accept(ElementVisitor visitor) {
		if (visitor instanceof DefaultElementVisitor) {
			DefaultElementVisitor defaultVisitor = (DefaultElementVisitor) visitor;
			defaultVisitor.visit(this);
		} else {
			visitor.visit(this);
		}
	}
}
