package Locales::DB::Language::sw;

use strict;
use warnings;

# Auto generated from CLDR

$Locales::DB::Language::sw::VERSION = '0.09';

$Locales::DB::Language::sw::cldr_version = '2.0';

%Locales::DB::Language::sw::misc_info = (
    'characters'   => { 'more_information' => "\?" },
    'cldr_formats' => {
        '_decimal_format_decimal' => "\.",
        '_decimal_format_group'   => "\,",
        '_percent_format_percent' => "\%",
        'decimal'                 => "\#\,\#\#0\.\#\#\#",
        'ellipsis'                => {
            'final'   => "\{0\}…",
            'initial' => "…\{0\}",
            'medial'  => "\{0\}…\{1\}"
        },
        'language' => "Language\:\ \{0\}",
        'list'     => {
            2        => "\{0\}\ na\ \{1\}",
            'end'    => "\{0\}\,\ na\ \{1\}",
            'middle' => "\{0\}\,\ \{1\}",
            'start'  => "\{0\}\,\ \{1\}"
        },
        'locale'    => "\{0\}\ \(\{1\}\)",
        'percent'   => "\#\,\#\#0\%",
        'territory' => "Region\:\ \{0\}"
    },
    'delimiters' => {
        'alternate_quotation_end'   => "\'",
        'alternate_quotation_start' => "\'",
        'quotation_end'             => "\'",
        'quotation_start'           => "\'"
    },
    'fallback'    => [],
    'orientation' => {
        'characters' => "left\-to\-right",
        'lines'      => "top\-to\-bottom"
    },
    'plural_forms' => {
        'category_list' => [
            'one',
            'other'
        ],
        'category_rules'          => { 'one' => "n\ is\ 1" },
        'category_rules_compiled' => {
            'one' => sub {
                if ( ( ( $_[0] == 1 ) ) ) { return 'one'; }
                return;
              }
        }
    },
    'posix' => {
        'nostr'  => "Hapana\:H",
        'yesstr' => "Ndiyo\:N"
    },
);

%Locales::DB::Language::sw::code_to_name = (
    'aa'     => 'Afar',
    'ab'     => 'Kiabkhazi',
    'ace'    => 'Achinese',
    'ach'    => 'Acoli',
    'ada'    => 'Adangme',
    'ady'    => 'Adyghe',
    'ae'     => 'Avestan',
    'af'     => 'Kiafrikana',
    'afa'    => "Afro\-Asiatic\ Language",
    'afh'    => 'Afrihili',
    'agq'    => 'Aghem',
    'ain'    => 'Ainu',
    'ak'     => 'Kiakan',
    'akk'    => 'Akkadian',
    'ale'    => 'Aleut',
    'alg'    => "Algonquian\ Language",
    'alt'    => "Southern\ Altai",
    'am'     => 'Kiamhari',
    'an'     => 'Aragonese',
    'ang'    => "Old\ English",
    'anp'    => 'Angika',
    'apa'    => "Apache\ Language",
    'ar'     => 'Kiarabu',
    'arc'    => 'Aramaic',
    'arn'    => 'Araucanian',
    'arp'    => 'Arapaho',
    'art'    => "Artificial\ Language",
    'arw'    => 'Arawak',
    'as'     => 'Kiassam',
    'asa'    => 'Kipare',
    'ast'    => 'Asturian',
    'ath'    => "Athapascan\ Language",
    'aus'    => "Australian\ Language",
    'av'     => 'Avaric',
    'awa'    => 'Awadhi',
    'ay'     => 'Aimara',
    'az'     => 'Kiazeri',
    'ba'     => 'Bashkir',
    'bad'    => 'Banda',
    'bai'    => "Bamileke\ Language",
    'bal'    => 'Baluchi',
    'ban'    => 'Balinese',
    'bas'    => 'Basaa',
    'bat'    => "Baltic\ Language",
    'be'     => 'Kibelarusi',
    'bej'    => 'Beja',
    'bem'    => 'Bemba',
    'ber'    => 'Berber',
    'bez'    => 'Kibena',
    'bg'     => 'Kibulgaria',
    'bh'     => 'kibihari',
    'bho'    => 'Bhojpuri',
    'bi'     => 'Bislama',
    'bik'    => 'Bikol',
    'bin'    => 'Bini',
    'bla'    => 'Siksika',
    'bm'     => 'Bambara',
    'bn'     => 'Kibangla',
    'bnt'    => 'Bantu',
    'bo'     => 'Kitibeti',
    'br'     => 'kibreton',
    'bra'    => 'Braj',
    'brx'    => 'Bodo',
    'bs'     => 'Kibosnia',
    'btk'    => 'Batak',
    'bua'    => 'Buriat',
    'bug'    => 'Buginese',
    'byn'    => 'Blin',
    'ca'     => 'Kikatalani',
    'cad'    => 'Caddo',
    'cai'    => "Central\ American\ Indian\ Language",
    'car'    => 'Carib',
    'cau'    => "Caucasian\ Language",
    'cay'    => 'Cayuga',
    'cch'    => 'Atsam',
    'ce'     => 'Chechen',
    'ceb'    => 'Cebuano',
    'cel'    => "Celtic\ Language",
    'cgg'    => 'Chiga',
    'ch'     => 'Chamorro',
    'chb'    => 'Chibcha',
    'chg'    => 'Chagatai',
    'chk'    => 'Chuukese',
    'chm'    => 'Mari',
    'chn'    => "Chinook\ Jargon",
    'cho'    => 'Choctaw',
    'chp'    => 'Chipewyan',
    'chr'    => 'Cherokee',
    'chy'    => 'Cheyenne',
    'cmc'    => "Chamic\ Language",
    'co'     => 'Corsican',
    'cop'    => 'Coptic',
    'cpe'    => "English\-based\ Creole\ or\ Pidgin",
    'cpf'    => "French\-based\ Creole\ or\ Pidgin",
    'cpp'    => "Portuguese\-based\ Creole\ or\ Pidgin",
    'cr'     => 'Cree',
    'crh'    => "Crimean\ Turkish",
    'crp'    => "Creole\ or\ Pidgin",
    'cs'     => 'Kicheki',
    'csb'    => 'Kashubian',
    'cu'     => "Church\ Slavic",
    'cus'    => "Cushitic\ Language",
    'cv'     => 'Chuvash',
    'cy'     => 'Kiwelisi',
    'da'     => 'Kidenmaki',
    'dak'    => 'Dakota',
    'dar'    => 'Dargwa',
    'dav'    => 'Taita',
    'day'    => 'Dayak',
    'de'     => 'Kijerumani',
    'de_at'  => "Kijerumani\ cha\ Austria",
    'de_ch'  => "Kijerumani\ cha\ Juu\ cha\ Uswisi",
    'del'    => 'Delaware',
    'den'    => 'Slave',
    'dgr'    => 'Dogrib',
    'din'    => 'Dinka',
    'dje'    => 'Zarma',
    'doi'    => 'Dogri',
    'dra'    => "Dravidian\ Language",
    'dsb'    => "Lower\ Sorbian",
    'dua'    => 'Duala',
    'dum'    => "Middle\ Dutch",
    'dv'     => 'Kidivehi',
    'dyo'    => "Jola\-Fonyi",
    'dyu'    => 'Dyula',
    'dz'     => 'Kizongkha',
    'ebu'    => 'Embu',
    'ee'     => 'Ewe',
    'efi'    => 'Kiefiki',
    'egy'    => "Ancient\ Egyptian",
    'eka'    => 'Ekajuk',
    'el'     => 'Kigiriki',
    'elx'    => 'Elamite',
    'en'     => 'Kiingereza',
    'en_au'  => "Kiingereza\ cha\ Australia",
    'en_ca'  => "Kiingereza\ cha\ Kanada",
    'en_gb'  => "Kiingereza\ cha\ Uingereza",
    'en_us'  => "Kiingereza\ cha\ Marekani",
    'enm'    => "Middle\ English",
    'eo'     => 'Kiesperanto',
    'es'     => 'Kihispania',
    'es_419' => "Kihispania\ cha\ Amerika\ ya\ Kilatinini",
    'es_es'  => "Kihispania\ cha\ Iberia",
    'et'     => 'Kiestonia',
    'eu'     => 'Kibasque',
    'ewo'    => 'Ewondo',
    'fa'     => 'Kiajemi',
    'fan'    => 'Fang',
    'fat'    => 'Fanti',
    'ff'     => 'Fulah',
    'fi'     => 'Kifinlandi',
    'fil'    => 'Kifilipino',
    'fiu'    => "Finno\-Ugrian\ Language",
    'fj'     => 'Kifiji',
    'fo'     => 'Kifaroe',
    'fon'    => 'Fon',
    'fr'     => 'Kifaransa',
    'fr_ca'  => "Kifaransa\ cha\ Kanada",
    'fr_ch'  => "Kifaransa\ cha\ Uswisi",
    'frm'    => "Middle\ French",
    'fro'    => "Old\ French",
    'frr'    => "Northern\ Frisian",
    'frs'    => "Eastern\ Frisian",
    'fur'    => 'Friulian',
    'fy'     => "Kifrisia\ cha\ Magharibi",
    'ga'     => 'Kiayalandi',
    'gaa'    => 'Ga',
    'gay'    => 'Gayo',
    'gba'    => 'Gbaya',
    'gd'     => "Kigaeli\ cha\ Uskoti",
    'gem'    => "Germanic\ Language",
    'gez'    => 'Geez',
    'gil'    => 'Gilbertese',
    'gl'     => 'Kigalisia',
    'gmh'    => "Middle\ High\ German",
    'gn'     => 'Kiguarani',
    'goh'    => "Old\ High\ German",
    'gon'    => 'Gondi',
    'gor'    => 'Gorontalo',
    'got'    => 'Gothic',
    'grb'    => 'Grebo',
    'grc'    => "Ancient\ Greek",
    'gsw'    => "Kijerumani\ cha\ Uswisi",
    'gu'     => 'Kigujarati',
    'guz'    => 'Gusii',
    'gv'     => 'Manx',
    'gwi'    => "Gwich\Ê\¼in",
    'ha'     => 'Kihausa',
    'hai'    => 'Haida',
    'haw'    => 'Kihawai',
    'he'     => 'Kiebrania',
    'hi'     => 'Kihindi',
    'hil'    => 'Hiligaynon',
    'him'    => 'Himachali',
    'hit'    => 'Hittite',
    'hmn'    => 'Hmong',
    'ho'     => "Hiri\ Motu",
    'hr'     => 'Kroeshia',
    'hsb'    => "Upper\ Sorbian",
    'ht'     => 'Kihaiti',
    'hu'     => 'Kihungari',
    'hup'    => 'Hupa',
    'hy'     => 'Kiarmenia',
    'hz'     => 'Herero',
    'ia'     => 'kiinterlingua',
    'iba'    => 'Iban',
    'id'     => 'Kiindonesia',
    'ie'     => "lugha\ ya\ kisayansi",
    'ig'     => 'Kiigbo',
    'ii'     => "Sichuan\ Yi",
    'ijo'    => 'Ijo',
    'ik'     => 'Inupiaq',
    'ilo'    => 'Iloko',
    'inc'    => "Indic\ Language",
    'ine'    => "Indo\-European\ Language",
    'inh'    => 'Ingush',
    'io'     => 'Ido',
    'ira'    => "Iranian\ Language",
    'iro'    => "Iroquoian\ Language",
    'is'     => 'Kiaisilandi',
    'it'     => 'Kiitaliano',
    'iu'     => 'Inuktitut',
    'ja'     => 'Kijapani',
    'jbo'    => 'Lojban',
    'jmc'    => 'Machame',
    'jpr'    => "Judeo\-Persian",
    'jrb'    => "Judeo\-Arabic",
    'jv'     => 'Kijava',
    'ka'     => 'Kijojia',
    'kaa'    => "Kara\-Kalpak",
    'kab'    => 'Kabyle',
    'kac'    => 'Kachin',
    'kaj'    => 'Jju',
    'kam'    => 'Kamba',
    'kar'    => 'Karen',
    'kaw'    => 'Kawi',
    'kbd'    => 'Kabardian',
    'kcg'    => 'Tyap',
    'kde'    => 'Makonde',
    'kea'    => 'Kabuverdianu',
    'kfo'    => 'Koro',
    'kg'     => 'Kongo',
    'kha'    => 'Khasi',
    'khi'    => "Khoisan\ Language",
    'kho'    => 'Khotanese',
    'khq'    => "Koyra\ Chiini",
    'ki'     => 'Kikuyu',
    'kj'     => 'Kuanyama',
    'kk'     => 'Kikazaki',
    'kl'     => 'Kalaallisut',
    'kln'    => 'Kalenjin',
    'km'     => 'Kikambodia',
    'kmb'    => 'Kimbundu',
    'kn'     => 'Kikannada',
    'ko'     => 'Kikorea',
    'kok'    => 'Konkani',
    'kos'    => 'Kosraean',
    'kpe'    => 'Kpelle',
    'kr'     => 'Kanuri',
    'krc'    => "Karachay\-Balkar",
    'krl'    => 'Karelian',
    'kro'    => 'Kru',
    'kru'    => 'Kurukh',
    'ks'     => 'Kashmiri',
    'ksb'    => 'Shambala',
    'ksf'    => 'Bafia',
    'ksh'    => 'Colognian',
    'ku'     => 'Kikurdi',
    'kum'    => 'Kumyk',
    'kut'    => 'Kutenai',
    'kv'     => 'Komi',
    'kw'     => 'Cornish',
    'ky'     => 'Kirigizi',
    'la'     => 'Kilatini',
    'lad'    => 'Ladino',
    'lag'    => 'Langi',
    'lah'    => 'Lahnda',
    'lam'    => 'Lamba',
    'lb'     => 'Kilasembagi',
    'lez'    => 'Lezghian',
    'lg'     => 'Ganda',
    'li'     => 'Limburgish',
    'ln'     => 'Kilingala',
    'lo'     => 'Kilaosi',
    'lol'    => 'Mongo',
    'loz'    => 'Lozi',
    'lt'     => 'Kilithuania',
    'lu'     => "Luba\-Katanga",
    'lua'    => "Luba\-Lulua",
    'lui'    => 'Luiseno',
    'lun'    => 'Lunda',
    'luo'    => 'Luo',
    'lus'    => 'Lushai',
    'luy'    => 'Luyia',
    'lv'     => 'Kilatvia',
    'mad'    => 'Madurese',
    'mag'    => 'Magahi',
    'mai'    => 'Maithili',
    'mak'    => 'Makasar',
    'man'    => 'Mandingo',
    'map'    => "Austronesian\ Language",
    'mas'    => 'Masai',
    'mdf'    => 'Moksha',
    'mdr'    => 'Mandar',
    'men'    => 'Mende',
    'mer'    => 'Meru',
    'mfe'    => 'Morisyen',
    'mg'     => 'Malagasi',
    'mga'    => "Middle\ Irish",
    'mgh'    => "Makhuwa\-Meetto",
    'mh'     => 'Marshallese',
    'mi'     => 'Maori',
    'mic'    => 'Micmac',
    'min'    => 'Minangkabau',
    'mis'    => "Miscellaneous\ Language",
    'mk'     => 'Kimasedonia',
    'mkh'    => "Mon\-Khmer\ Language",
    'ml'     => 'Kimalayalam',
    'mn'     => 'Mongolia',
    'mnc'    => 'Manchu',
    'mni'    => 'Manipuri',
    'mno'    => "Manobo\ Language",
    'mo'     => 'Moldavian',
    'moh'    => 'Mohawk',
    'mos'    => 'Mossi',
    'mr'     => 'Kimarathi',
    'ms'     => 'Kimalesia',
    'mt'     => 'Kimalta',
    'mua'    => 'Mundang',
    'mul'    => "lugha\ nyingi",
    'mun'    => "Munda\ Language",
    'mus'    => 'Creek',
    'mwl'    => 'Mirandese',
    'mwr'    => 'Marwari',
    'my'     => 'Kiburma',
    'myn'    => "Mayan\ Language",
    'myv'    => 'Erzya',
    'na'     => 'Nauru',
    'nah'    => 'Nahuatl',
    'nai'    => "North\ American\ Indian\ Language",
    'nap'    => 'Neapolitan',
    'naq'    => 'Nama',
    'nb'     => "Kibokmal\ cha\ Norwe",
    'nd'     => "Kindebele\ cha\ Kaskazini",
    'nds'    => "Low\ German",
    'ne'     => 'Kinepali',
    'new'    => 'Newari',
    'ng'     => 'Ndonga',
    'nia'    => 'Nias',
    'nic'    => "Niger\-Kordofanian\ Language",
    'niu'    => 'Niuean',
    'nl'     => 'Kiholanzi',
    'nl_be'  => 'Kiflemi',
    'nmg'    => 'Kwasio',
    'nn'     => "Kinorwe\ Kipya",
    'no'     => 'kinorwei',
    'nog'    => 'Nogai',
    'non'    => "Old\ Norse",
    'nqo'    => "N\â\\Ko",
    'nr'     => "South\ Ndebele",
    'nso'    => "Kisotho\ cha\ Kaskazini",
    'nub'    => "Nubian\ Language",
    'nus'    => 'Nuer',
    'nv'     => 'Navajo',
    'nwc'    => "Classical\ Newari",
    'ny'     => 'Kinyanja',
    'nym'    => 'Nyamwezi',
    'nyn'    => 'Nyankole',
    'nyo'    => 'Nyoro',
    'nzi'    => 'Nzima',
    'oc'     => 'kiositani',
    'oj'     => 'Ojibwa',
    'om'     => 'Oromo',
    'or'     => 'Kioriya',
    'os'     => 'Kiosetia',
    'osa'    => 'Osage',
    'ota'    => "Ottoman\ Turkish",
    'oto'    => "Otomian\ Language",
    'pa'     => 'Kipunjabi',
    'paa'    => "Papuan\ Language",
    'pag'    => 'Pangasinan',
    'pal'    => 'Pahlavi',
    'pam'    => 'Pampanga',
    'pap'    => 'Papiamento',
    'pau'    => 'Palauan',
    'peo'    => "Old\ Persian",
    'phi'    => "Philippine\ Language",
    'phn'    => 'Phoenician',
    'pi'     => 'Pali',
    'pl'     => 'Kipolandi',
    'pon'    => 'Pohnpeian',
    'pra'    => "Prakrit\ Language",
    'pro'    => "Old\ Proven\Ã\§al",
    'ps'     => 'Kipushto',
    'pt'     => 'Kireno',
    'pt_br'  => "Kireno\ cha\ Brazil",
    'pt_pt'  => "Kireno\ cha\ Iberia",
    'qu'     => 'Quechua',
    'raj'    => 'Rajasthani',
    'rap'    => 'Rapanui',
    'rar'    => 'Rarotongan',
    'rm'     => 'Kiromanshi',
    'rn'     => 'Kirundi',
    'ro'     => 'Kiromania',
    'roa'    => "Romance\ Language",
    'rof'    => 'Rombo',
    'rom'    => 'Romany',
    'ru'     => 'Kirusi',
    'rup'    => 'Aromanian',
    'rw'     => 'Kinyarwanda',
    'rwk'    => 'Kirwo',
    'sa'     => 'Kisanskriti',
    'sad'    => 'Sandawe',
    'sah'    => 'Sakha',
    'sai'    => "South\ American\ Indian\ Language",
    'sal'    => "Salishan\ Language",
    'sam'    => "Samaritan\ Aramaic",
    'saq'    => 'Samburu',
    'sas'    => 'Sasak',
    'sat'    => 'Santali',
    'sbp'    => 'Sangu',
    'sc'     => 'Sardinian',
    'scn'    => 'Sicilian',
    'sco'    => 'Scots',
    'sd'     => 'Kisindhi',
    'se'     => "Kisami\ cha\ Kaskazini",
    'see'    => 'Seneca',
    'seh'    => 'Sena',
    'sel'    => 'Selkup',
    'sem'    => "Semitic\ Language",
    'ses'    => "Koyraboro\ Senni",
    'sg'     => 'Kisango',
    'sga'    => "Old\ Irish",
    'sgn'    => "Sign\ Language",
    'sh'     => "kiserbia\-kroeshia",
    'shi'    => 'Tachelhit',
    'shn'    => 'Shan',
    'si'     => 'Kisinhala',
    'sid'    => 'Sidamo',
    'sio'    => "Siouan\ Language",
    'sit'    => "Sino\-Tibetan\ Language",
    'sk'     => 'Kislovakia',
    'sl'     => 'Kislovenia',
    'sla'    => "Slavic\ Language",
    'sm'     => 'Kisamoa',
    'sma'    => "Southern\ Sami",
    'smi'    => "Sami\ Language",
    'smj'    => "Lule\ Sami",
    'smn'    => "Inari\ Sami",
    'sms'    => "Skolt\ Sami",
    'sn'     => 'Kishona',
    'snk'    => 'Soninke',
    'so'     => 'Kisomali',
    'sog'    => 'Sogdien',
    'son'    => 'Songhai',
    'sq'     => 'Kialbania',
    'sr'     => 'Kiserbia',
    'srn'    => "Sranan\ Tongo",
    'srr'    => 'Serer',
    'ss'     => 'Kiswati',
    'ssa'    => "Nilo\-Saharan\ Language",
    'ssy'    => 'Saho',
    'st'     => "Kisotho\ cha\ Kusini",
    'su'     => 'Kisunda',
    'suk'    => 'Sukuma',
    'sus'    => 'Susu',
    'sux'    => 'Sumerian',
    'sv'     => 'Kiswidi',
    'sw'     => 'Kiswahili',
    'swb'    => 'Comorian',
    'swc'    => "Congo\ Swahili",
    'syc'    => "Classical\ Syriac",
    'syr'    => 'Syriac',
    'ta'     => 'Kitamil',
    'tai'    => "Tai\ Language",
    'te'     => 'Kitelugu',
    'tem'    => 'Timne',
    'teo'    => 'Teso',
    'ter'    => 'Tereno',
    'tet'    => 'Kitetum',
    'tg'     => 'Tajiki',
    'th'     => 'Kitailandi',
    'ti'     => 'Kitigrinya',
    'tig'    => 'Tigre',
    'tiv'    => 'Tiv',
    'tk'     => 'Kiturukimeni',
    'tkl'    => 'Tokelau',
    'tl'     => 'Tagalog',
    'tlh'    => 'kiklingon',
    'tli'    => 'Tlingit',
    'tmh'    => 'Tamashek',
    'tn'     => 'Kitswana',
    'to'     => 'Tonga',
    'tog'    => "Nyasa\ Tonga",
    'tpi'    => 'Kitokpisin',
    'tr'     => 'Kituruki',
    'trv'    => 'Taroko',
    'ts'     => 'Kitsonga',
    'tsi'    => 'Tsimshian',
    'tt'     => 'Kitatari',
    'tum'    => 'Tumbuka',
    'tup'    => "Tupi\ Language",
    'tut'    => "Altaic\ Language",
    'tvl'    => 'Tuvalu',
    'tw'     => 'kitwii',
    'twq'    => 'Tasawaq',
    'ty'     => 'Kitahiti',
    'tyv'    => 'Tuvinian',
    'tzm'    => "Central\ Morocco\ Tamazight",
    'udm'    => 'Udmurt',
    'ug'     => 'Kiuiguri',
    'uga'    => 'Ugaritic',
    'uk'     => 'Kiukrania',
    'umb'    => 'Umbundu',
    'und'    => "Lugha\ Isiyojulikana",
    'ur'     => 'Kiurdu',
    'uz'     => 'Kiuzbeki',
    'vai'    => 'Vai',
    've'     => 'Kivenda',
    'vi'     => 'Kivietinamu',
    'vo'     => "Volap\Ã\¼k",
    'vot'    => 'Votic',
    'vun'    => 'Vunjo',
    'wa'     => 'Walloon',
    'wae'    => 'Walser',
    'wak'    => "Wakashan\ Language",
    'wal'    => 'Walamo',
    'war'    => 'Waray',
    'was'    => 'Washo',
    'wen'    => "Sorbian\ Language",
    'wo'     => 'Wolof',
    'xal'    => 'Kalmyk',
    'xh'     => 'Kixhosa',
    'xog'    => 'Soga',
    'yao'    => 'Yao',
    'yap'    => 'Yapese',
    'yav'    => 'Yangben',
    'yi'     => 'kiyidish',
    'yo'     => 'Kiyoruba',
    'ypk'    => "Yupik\ Language",
    'yue'    => 'Cantonese',
    'za'     => 'Zhuang',
    'zap'    => 'Zapotec',
    'zbl'    => 'Blissymbols',
    'zen'    => 'Zenaga',
    'zh'     => 'Kichina',
    'znd'    => 'Zande',
    'zu'     => 'Kizulu',
    'zun'    => 'Zuni',
    'zxx'    => "Hakuna\ maudhui\ ya\ lugha",
    'zza'    => 'Zaza',
);

%Locales::DB::Language::sw::name_to_code = (
    'achinese'                         => 'ace',
    'acoli'                            => 'ach',
    'adangme'                          => 'ada',
    'adyghe'                           => 'ady',
    'afar'                             => 'aa',
    'afrihili'                         => 'afh',
    'afroasiaticlanguage'              => 'afa',
    'aghem'                            => 'agq',
    'aimara'                           => 'ay',
    'ainu'                             => 'ain',
    'akkadian'                         => 'akk',
    'aleut'                            => 'ale',
    'algonquianlanguage'               => 'alg',
    'altaiclanguage'                   => 'tut',
    'ancientegyptian'                  => 'egy',
    'ancientgreek'                     => 'grc',
    'angika'                           => 'anp',
    'apachelanguage'                   => 'apa',
    'aragonese'                        => 'an',
    'aramaic'                          => 'arc',
    'arapaho'                          => 'arp',
    'araucanian'                       => 'arn',
    'arawak'                           => 'arw',
    'aromanian'                        => 'rup',
    'artificiallanguage'               => 'art',
    'asturian'                         => 'ast',
    'athapascanlanguage'               => 'ath',
    'atsam'                            => 'cch',
    'australianlanguage'               => 'aus',
    'austronesianlanguage'             => 'map',
    'avaric'                           => 'av',
    'avestan'                          => 'ae',
    'awadhi'                           => 'awa',
    'bafia'                            => 'ksf',
    'balinese'                         => 'ban',
    'balticlanguage'                   => 'bat',
    'baluchi'                          => 'bal',
    'bambara'                          => 'bm',
    'bamilekelanguage'                 => 'bai',
    'banda'                            => 'bad',
    'bantu'                            => 'bnt',
    'basaa'                            => 'bas',
    'bashkir'                          => 'ba',
    'batak'                            => 'btk',
    'beja'                             => 'bej',
    'bemba'                            => 'bem',
    'berber'                           => 'ber',
    'bhojpuri'                         => 'bho',
    'bikol'                            => 'bik',
    'bini'                             => 'bin',
    'bislama'                          => 'bi',
    'blin'                             => 'byn',
    'blissymbols'                      => 'zbl',
    'bodo'                             => 'brx',
    'braj'                             => 'bra',
    'buginese'                         => 'bug',
    'buriat'                           => 'bua',
    'caddo'                            => 'cad',
    'cantonese'                        => 'yue',
    'carib'                            => 'car',
    'caucasianlanguage'                => 'cau',
    'cayuga'                           => 'cay',
    'cebuano'                          => 'ceb',
    'celticlanguage'                   => 'cel',
    'centralamericanindianlanguage'    => 'cai',
    'centralmoroccotamazight'          => 'tzm',
    'chagatai'                         => 'chg',
    'chamiclanguage'                   => 'cmc',
    'chamorro'                         => 'ch',
    'chechen'                          => 'ce',
    'cherokee'                         => 'chr',
    'cheyenne'                         => 'chy',
    'chibcha'                          => 'chb',
    'chiga'                            => 'cgg',
    'chinookjargon'                    => 'chn',
    'chipewyan'                        => 'chp',
    'choctaw'                          => 'cho',
    'churchslavic'                     => 'cu',
    'chuukese'                         => 'chk',
    'chuvash'                          => 'cv',
    'classicalnewari'                  => 'nwc',
    'classicalsyriac'                  => 'syc',
    'colognian'                        => 'ksh',
    'comorian'                         => 'swb',
    'congoswahili'                     => 'swc',
    'coptic'                           => 'cop',
    'cornish'                          => 'kw',
    'corsican'                         => 'co',
    'cree'                             => 'cr',
    'creek'                            => 'mus',
    'creoleorpidgin'                   => 'crp',
    'crimeanturkish'                   => 'crh',
    'cushiticlanguage'                 => 'cus',
    'dakota'                           => 'dak',
    'dargwa'                           => 'dar',
    'dayak'                            => 'day',
    'delaware'                         => 'del',
    'dinka'                            => 'din',
    'dogri'                            => 'doi',
    'dogrib'                           => 'dgr',
    'dravidianlanguage'                => 'dra',
    'duala'                            => 'dua',
    'dyula'                            => 'dyu',
    'easternfrisian'                   => 'frs',
    'ekajuk'                           => 'eka',
    'elamite'                          => 'elx',
    'embu'                             => 'ebu',
    'englishbasedcreoleorpidgin'       => 'cpe',
    'erzya'                            => 'myv',
    'ewe'                              => 'ee',
    'ewondo'                           => 'ewo',
    'fang'                             => 'fan',
    'fanti'                            => 'fat',
    'finnougrianlanguage'              => 'fiu',
    'fon'                              => 'fon',
    'frenchbasedcreoleorpidgin'        => 'cpf',
    'friulian'                         => 'fur',
    'fulah'                            => 'ff',
    'ga'                               => 'gaa',
    'ganda'                            => 'lg',
    'gayo'                             => 'gay',
    'gbaya'                            => 'gba',
    'geez'                             => 'gez',
    'germaniclanguage'                 => 'gem',
    'gilbertese'                       => 'gil',
    'gondi'                            => 'gon',
    'gorontalo'                        => 'gor',
    'gothic'                           => 'got',
    'grebo'                            => 'grb',
    'gusii'                            => 'guz',
    "gwich\Ê\¼in"                    => 'gwi',
    'haida'                            => 'hai',
    'hakunamaudhuiyalugha'             => 'zxx',
    'herero'                           => 'hz',
    'hiligaynon'                       => 'hil',
    'himachali'                        => 'him',
    'hirimotu'                         => 'ho',
    'hittite'                          => 'hit',
    'hmong'                            => 'hmn',
    'hupa'                             => 'hup',
    'iban'                             => 'iba',
    'ido'                              => 'io',
    'ijo'                              => 'ijo',
    'iloko'                            => 'ilo',
    'inarisami'                        => 'smn',
    'indiclanguage'                    => 'inc',
    'indoeuropeanlanguage'             => 'ine',
    'ingush'                           => 'inh',
    'inuktitut'                        => 'iu',
    'inupiaq'                          => 'ik',
    'iranianlanguage'                  => 'ira',
    'iroquoianlanguage'                => 'iro',
    'jju'                              => 'kaj',
    'jolafonyi'                        => 'dyo',
    'judeoarabic'                      => 'jrb',
    'judeopersian'                     => 'jpr',
    'kabardian'                        => 'kbd',
    'kabuverdianu'                     => 'kea',
    'kabyle'                           => 'kab',
    'kachin'                           => 'kac',
    'kalaallisut'                      => 'kl',
    'kalenjin'                         => 'kln',
    'kalmyk'                           => 'xal',
    'kamba'                            => 'kam',
    'kanuri'                           => 'kr',
    'karachaybalkar'                   => 'krc',
    'karakalpak'                       => 'kaa',
    'karelian'                         => 'krl',
    'karen'                            => 'kar',
    'kashmiri'                         => 'ks',
    'kashubian'                        => 'csb',
    'kawi'                             => 'kaw',
    'khasi'                            => 'kha',
    'khoisanlanguage'                  => 'khi',
    'khotanese'                        => 'kho',
    'kiabkhazi'                        => 'ab',
    'kiafrikana'                       => 'af',
    'kiaisilandi'                      => 'is',
    'kiajemi'                          => 'fa',
    'kiakan'                           => 'ak',
    'kialbania'                        => 'sq',
    'kiamhari'                         => 'am',
    'kiarabu'                          => 'ar',
    'kiarmenia'                        => 'hy',
    'kiassam'                          => 'as',
    'kiayalandi'                       => 'ga',
    'kiazeri'                          => 'az',
    'kibangla'                         => 'bn',
    'kibasque'                         => 'eu',
    'kibelarusi'                       => 'be',
    'kibena'                           => 'bez',
    'kibihari'                         => 'bh',
    'kibokmalchanorwe'                 => 'nb',
    'kibosnia'                         => 'bs',
    'kibreton'                         => 'br',
    'kibulgaria'                       => 'bg',
    'kiburma'                          => 'my',
    'kicheki'                          => 'cs',
    'kichina'                          => 'zh',
    'kidenmaki'                        => 'da',
    'kidivehi'                         => 'dv',
    'kiebrania'                        => 'he',
    'kiefiki'                          => 'efi',
    'kiesperanto'                      => 'eo',
    'kiestonia'                        => 'et',
    'kifaransa'                        => 'fr',
    'kifaransachakanada'               => 'fr_ca',
    'kifaransachauswisi'               => 'fr_ch',
    'kifaroe'                          => 'fo',
    'kifiji'                           => 'fj',
    'kifilipino'                       => 'fil',
    'kifinlandi'                       => 'fi',
    'kiflemi'                          => 'nl_be',
    'kifrisiachamagharibi'             => 'fy',
    'kigaelichauskoti'                 => 'gd',
    'kigalisia'                        => 'gl',
    'kigiriki'                         => 'el',
    'kiguarani'                        => 'gn',
    'kigujarati'                       => 'gu',
    'kihaiti'                          => 'ht',
    'kihausa'                          => 'ha',
    'kihawai'                          => 'haw',
    'kihindi'                          => 'hi',
    'kihispania'                       => 'es',
    'kihispaniachaamerikayakilatinini' => 'es_419',
    'kihispaniachaiberia'              => 'es_es',
    'kiholanzi'                        => 'nl',
    'kihungari'                        => 'hu',
    'kiigbo'                           => 'ig',
    'kiindonesia'                      => 'id',
    'kiingereza'                       => 'en',
    'kiingerezachaaustralia'           => 'en_au',
    'kiingerezachakanada'              => 'en_ca',
    'kiingerezachamarekani'            => 'en_us',
    'kiingerezachauingereza'           => 'en_gb',
    'kiinterlingua'                    => 'ia',
    'kiitaliano'                       => 'it',
    'kijapani'                         => 'ja',
    'kijava'                           => 'jv',
    'kijerumani'                       => 'de',
    'kijerumanichaaustria'             => 'de_at',
    'kijerumanichajuuchauswisi'        => 'de_ch',
    'kijerumanichauswisi'              => 'gsw',
    'kijojia'                          => 'ka',
    'kikambodia'                       => 'km',
    'kikannada'                        => 'kn',
    'kikatalani'                       => 'ca',
    'kikazaki'                         => 'kk',
    'kiklingon'                        => 'tlh',
    'kikorea'                          => 'ko',
    'kikurdi'                          => 'ku',
    'kikuyu'                           => 'ki',
    'kilaosi'                          => 'lo',
    'kilasembagi'                      => 'lb',
    'kilatini'                         => 'la',
    'kilatvia'                         => 'lv',
    'kilingala'                        => 'ln',
    'kilithuania'                      => 'lt',
    'kimalayalam'                      => 'ml',
    'kimalesia'                        => 'ms',
    'kimalta'                          => 'mt',
    'kimarathi'                        => 'mr',
    'kimasedonia'                      => 'mk',
    'kimbundu'                         => 'kmb',
    'kindebelechakaskazini'            => 'nd',
    'kinepali'                         => 'ne',
    'kinorwei'                         => 'no',
    'kinorwekipya'                     => 'nn',
    'kinyanja'                         => 'ny',
    'kinyarwanda'                      => 'rw',
    'kioriya'                          => 'or',
    'kiosetia'                         => 'os',
    'kiositani'                        => 'oc',
    'kipare'                           => 'asa',
    'kipolandi'                        => 'pl',
    'kipunjabi'                        => 'pa',
    'kipushto'                         => 'ps',
    'kireno'                           => 'pt',
    'kirenochabrazil'                  => 'pt_br',
    'kirenochaiberia'                  => 'pt_pt',
    'kirigizi'                         => 'ky',
    'kiromania'                        => 'ro',
    'kiromanshi'                       => 'rm',
    'kirundi'                          => 'rn',
    'kirusi'                           => 'ru',
    'kirwo'                            => 'rwk',
    'kisamichakaskazini'               => 'se',
    'kisamoa'                          => 'sm',
    'kisango'                          => 'sg',
    'kisanskriti'                      => 'sa',
    'kiserbia'                         => 'sr',
    'kiserbiakroeshia'                 => 'sh',
    'kishona'                          => 'sn',
    'kisindhi'                         => 'sd',
    'kisinhala'                        => 'si',
    'kislovakia'                       => 'sk',
    'kislovenia'                       => 'sl',
    'kisomali'                         => 'so',
    'kisothochakaskazini'              => 'nso',
    'kisothochakusini'                 => 'st',
    'kisunda'                          => 'su',
    'kiswahili'                        => 'sw',
    'kiswati'                          => 'ss',
    'kiswidi'                          => 'sv',
    'kitahiti'                         => 'ty',
    'kitailandi'                       => 'th',
    'kitamil'                          => 'ta',
    'kitatari'                         => 'tt',
    'kitelugu'                         => 'te',
    'kitetum'                          => 'tet',
    'kitibeti'                         => 'bo',
    'kitigrinya'                       => 'ti',
    'kitokpisin'                       => 'tpi',
    'kitsonga'                         => 'ts',
    'kitswana'                         => 'tn',
    'kituruki'                         => 'tr',
    'kiturukimeni'                     => 'tk',
    'kitwii'                           => 'tw',
    'kiuiguri'                         => 'ug',
    'kiukrania'                        => 'uk',
    'kiurdu'                           => 'ur',
    'kiuzbeki'                         => 'uz',
    'kivenda'                          => 've',
    'kivietinamu'                      => 'vi',
    'kiwelisi'                         => 'cy',
    'kixhosa'                          => 'xh',
    'kiyidish'                         => 'yi',
    'kiyoruba'                         => 'yo',
    'kizongkha'                        => 'dz',
    'kizulu'                           => 'zu',
    'komi'                             => 'kv',
    'kongo'                            => 'kg',
    'konkani'                          => 'kok',
    'koro'                             => 'kfo',
    'kosraean'                         => 'kos',
    'koyraborosenni'                   => 'ses',
    'koyrachiini'                      => 'khq',
    'kpelle'                           => 'kpe',
    'kroeshia'                         => 'hr',
    'kru'                              => 'kro',
    'kuanyama'                         => 'kj',
    'kumyk'                            => 'kum',
    'kurukh'                           => 'kru',
    'kutenai'                          => 'kut',
    'kwasio'                           => 'nmg',
    'ladino'                           => 'lad',
    'lahnda'                           => 'lah',
    'lamba'                            => 'lam',
    'langi'                            => 'lag',
    'lezghian'                         => 'lez',
    'limburgish'                       => 'li',
    'lojban'                           => 'jbo',
    'lowersorbian'                     => 'dsb',
    'lowgerman'                        => 'nds',
    'lozi'                             => 'loz',
    'lubakatanga'                      => 'lu',
    'lubalulua'                        => 'lua',
    'lughaisiyojulikana'               => 'und',
    'lughanyingi'                      => 'mul',
    'lughayakisayansi'                 => 'ie',
    'luiseno'                          => 'lui',
    'lulesami'                         => 'smj',
    'lunda'                            => 'lun',
    'luo'                              => 'luo',
    'lushai'                           => 'lus',
    'luyia'                            => 'luy',
    'machame'                          => 'jmc',
    'madurese'                         => 'mad',
    'magahi'                           => 'mag',
    'maithili'                         => 'mai',
    'makasar'                          => 'mak',
    'makhuwameetto'                    => 'mgh',
    'makonde'                          => 'kde',
    'malagasi'                         => 'mg',
    'manchu'                           => 'mnc',
    'mandar'                           => 'mdr',
    'mandingo'                         => 'man',
    'manipuri'                         => 'mni',
    'manobolanguage'                   => 'mno',
    'manx'                             => 'gv',
    'maori'                            => 'mi',
    'mari'                             => 'chm',
    'marshallese'                      => 'mh',
    'marwari'                          => 'mwr',
    'masai'                            => 'mas',
    'mayanlanguage'                    => 'myn',
    'mende'                            => 'men',
    'meru'                             => 'mer',
    'micmac'                           => 'mic',
    'middledutch'                      => 'dum',
    'middleenglish'                    => 'enm',
    'middlefrench'                     => 'frm',
    'middlehighgerman'                 => 'gmh',
    'middleirish'                      => 'mga',
    'minangkabau'                      => 'min',
    'mirandese'                        => 'mwl',
    'miscellaneouslanguage'            => 'mis',
    'mohawk'                           => 'moh',
    'moksha'                           => 'mdf',
    'moldavian'                        => 'mo',
    'mongo'                            => 'lol',
    'mongolia'                         => 'mn',
    'monkhmerlanguage'                 => 'mkh',
    'morisyen'                         => 'mfe',
    'mossi'                            => 'mos',
    'mundalanguage'                    => 'mun',
    'mundang'                          => 'mua',
    'nahuatl'                          => 'nah',
    'nama'                             => 'naq',
    'nauru'                            => 'na',
    'navajo'                           => 'nv',
    'ndonga'                           => 'ng',
    'neapolitan'                       => 'nap',
    'newari'                           => 'new',
    'nias'                             => 'nia',
    'nigerkordofanianlanguage'         => 'nic',
    'nilosaharanlanguage'              => 'ssa',
    'niuean'                           => 'niu',
    'nogai'                            => 'nog',
    'northamericanindianlanguage'      => 'nai',
    'northernfrisian'                  => 'frr',
    'nubianlanguage'                   => 'nub',
    'nuer'                             => 'nus',
    'nyamwezi'                         => 'nym',
    'nyankole'                         => 'nyn',
    'nyasatonga'                       => 'tog',
    'nyoro'                            => 'nyo',
    'nzima'                            => 'nzi',
    "n\â\\ko"                     => 'nqo',
    'ojibwa'                           => 'oj',
    'oldenglish'                       => 'ang',
    'oldfrench'                        => 'fro',
    'oldhighgerman'                    => 'goh',
    'oldirish'                         => 'sga',
    'oldnorse'                         => 'non',
    'oldpersian'                       => 'peo',
    "oldproven\Ã\§al"                => 'pro',
    'oromo'                            => 'om',
    'osage'                            => 'osa',
    'otomianlanguage'                  => 'oto',
    'ottomanturkish'                   => 'ota',
    'pahlavi'                          => 'pal',
    'palauan'                          => 'pau',
    'pali'                             => 'pi',
    'pampanga'                         => 'pam',
    'pangasinan'                       => 'pag',
    'papiamento'                       => 'pap',
    'papuanlanguage'                   => 'paa',
    'philippinelanguage'               => 'phi',
    'phoenician'                       => 'phn',
    'pohnpeian'                        => 'pon',
    'portuguesebasedcreoleorpidgin'    => 'cpp',
    'prakritlanguage'                  => 'pra',
    'quechua'                          => 'qu',
    'rajasthani'                       => 'raj',
    'rapanui'                          => 'rap',
    'rarotongan'                       => 'rar',
    'romancelanguage'                  => 'roa',
    'romany'                           => 'rom',
    'rombo'                            => 'rof',
    'saho'                             => 'ssy',
    'sakha'                            => 'sah',
    'salishanlanguage'                 => 'sal',
    'samaritanaramaic'                 => 'sam',
    'samburu'                          => 'saq',
    'samilanguage'                     => 'smi',
    'sandawe'                          => 'sad',
    'sangu'                            => 'sbp',
    'santali'                          => 'sat',
    'sardinian'                        => 'sc',
    'sasak'                            => 'sas',
    'scots'                            => 'sco',
    'selkup'                           => 'sel',
    'semiticlanguage'                  => 'sem',
    'sena'                             => 'seh',
    'seneca'                           => 'see',
    'serer'                            => 'srr',
    'shambala'                         => 'ksb',
    'shan'                             => 'shn',
    'sichuanyi'                        => 'ii',
    'sicilian'                         => 'scn',
    'sidamo'                           => 'sid',
    'signlanguage'                     => 'sgn',
    'siksika'                          => 'bla',
    'sinotibetanlanguage'              => 'sit',
    'siouanlanguage'                   => 'sio',
    'skoltsami'                        => 'sms',
    'slave'                            => 'den',
    'slaviclanguage'                   => 'sla',
    'soga'                             => 'xog',
    'sogdien'                          => 'sog',
    'songhai'                          => 'son',
    'soninke'                          => 'snk',
    'sorbianlanguage'                  => 'wen',
    'southamericanindianlanguage'      => 'sai',
    'southernaltai'                    => 'alt',
    'southernsami'                     => 'sma',
    'southndebele'                     => 'nr',
    'sranantongo'                      => 'srn',
    'sukuma'                           => 'suk',
    'sumerian'                         => 'sux',
    'susu'                             => 'sus',
    'syriac'                           => 'syr',
    'tachelhit'                        => 'shi',
    'tagalog'                          => 'tl',
    'tailanguage'                      => 'tai',
    'taita'                            => 'dav',
    'tajiki'                           => 'tg',
    'tamashek'                         => 'tmh',
    'taroko'                           => 'trv',
    'tasawaq'                          => 'twq',
    'tereno'                           => 'ter',
    'teso'                             => 'teo',
    'tigre'                            => 'tig',
    'timne'                            => 'tem',
    'tiv'                              => 'tiv',
    'tlingit'                          => 'tli',
    'tokelau'                          => 'tkl',
    'tonga'                            => 'to',
    'tsimshian'                        => 'tsi',
    'tumbuka'                          => 'tum',
    'tupilanguage'                     => 'tup',
    'tuvalu'                           => 'tvl',
    'tuvinian'                         => 'tyv',
    'tyap'                             => 'kcg',
    'udmurt'                           => 'udm',
    'ugaritic'                         => 'uga',
    'umbundu'                          => 'umb',
    'uppersorbian'                     => 'hsb',
    'vai'                              => 'vai',
    "volap\Ã\¼k"                     => 'vo',
    'votic'                            => 'vot',
    'vunjo'                            => 'vun',
    'wakashanlanguage'                 => 'wak',
    'walamo'                           => 'wal',
    'walloon'                          => 'wa',
    'walser'                           => 'wae',
    'waray'                            => 'war',
    'washo'                            => 'was',
    'wolof'                            => 'wo',
    'yangben'                          => 'yav',
    'yao'                              => 'yao',
    'yapese'                           => 'yap',
    'yupiklanguage'                    => 'ypk',
    'zande'                            => 'znd',
    'zapotec'                          => 'zap',
    'zarma'                            => 'dje',
    'zaza'                             => 'zza',
    'zenaga'                           => 'zen',
    'zhuang'                           => 'za',
    'zuni'                             => 'zun',
);

1;
