/*
 * Decompiled with CFR 0.152.
 */
package org.jgraph.util;

import java.awt.Point;
import java.awt.geom.Point2D;

public class Bezier {
    private static final float AP = 0.5f;
    private Point2D[] bPoints;

    public Bezier(Point2D[] point2DArray) {
        int n = point2DArray.length;
        if (n < 3) {
            return;
        }
        this.bPoints = new Point[2 * (n - 2)];
        double d = point2DArray[0].getX();
        double d2 = point2DArray[0].getY();
        double d3 = point2DArray[1].getX();
        double d4 = point2DArray[1].getY();
        for (int i = 0; i < n - 2; ++i) {
            double d5;
            double d6;
            double d7 = d;
            double d8 = d2;
            d = d3;
            d2 = d4;
            d3 = point2DArray[i + 2].getX();
            d4 = point2DArray[i + 2].getY();
            double d9 = d - d7;
            double d10 = d2 - d8;
            double d11 = d3 - d7;
            double d12 = d4 - d8;
            d6 = (d6 = d9 * (d11 /= (d5 = Math.sqrt(d11 * d11 + d12 * d12))) + d10 * (d12 /= d5)) < 0.0 ? -d6 : d6;
            double d13 = d6 * d11;
            double d14 = d6 * d12;
            double d15 = d - 0.5 * d13;
            double d16 = d2 - 0.5 * d14;
            this.bPoints[2 * i] = new Point((int)d15, (int)d16);
            d11 = -d11;
            d12 = -d12;
            double d17 = d - d3;
            double d18 = d2 - d4;
            d6 = d17 * d11 + d18 * d12;
            d6 = d6 < 0.0 ? -d6 : d6;
            d13 = d6 * d11;
            d14 = d6 * d12;
            double d19 = d - 0.5 * d13;
            double d20 = d2 - 0.5 * d14;
            this.bPoints[2 * i + 1] = new Point((int)d19, (int)d20);
        }
    }

    public Point2D[] getPoints() {
        return this.bPoints;
    }

    public int getPointCount() {
        return this.bPoints.length;
    }

    public Point2D getPoint(int n) {
        return this.bPoints[n];
    }
}

