/*
* JBoss, Home of Professional Open Source
* Copyright 2005, JBoss Inc., and individual contributors as indicated
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/

package org.jboss.profiler.jvmti;

import java.lang.ref.WeakReference;

/**
 * Used to return quantity of instances and bytes per class 
 *  */
public class InventoryDataPoint implements Comparable 
{
	
	public InventoryDataPoint(Class clazz)
	{
		this.clazz = new WeakReference(clazz);
	}
	
	public InventoryDataPoint(Class clazz, int instances)
	{
		this.clazz = new WeakReference(clazz);
		this.instances=instances;
	}
	
	WeakReference clazz;
	int instances;
	long bytes;
	
	
	public long getBytes() {
		return bytes;
	}
	public void setBytes(long bytes) {
		this.bytes = bytes;
	}
	public Class getClazz() {
		return (Class)clazz.get();
	}
	public void setClazz(Class clazz) {
		this.clazz = new WeakReference(clazz);
	}
	public int getInstances() {
		return instances;
	}
	public void setInstances(int instances) {
		this.instances = instances;
	}

	public int compareTo(Object o) {
		InventoryDataPoint that = (InventoryDataPoint)o;
		long result = that.bytes - this.bytes;
		if (result==0) return 0;
		else if (result>0) return 1;
		else return -1;
	}
	
	
	
}
