/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2008, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.jca.spi;

import java.io.Serializable;

/**
 * The ActivationConfigProperty - similar to the javax.ejb annotation
 * 
 * @author <a href="mailto:adrian@jboss.org">Adrian Brock</a>
 * @author <a href="mailto:jesper.pedersen@jboss.org">Jesper Pedersen</a>
 * @version $Revision: $
 */
public class ActivationConfigProperty implements Serializable
{
   /** Serial UID */
   static final long serialVersionUID = 4504308146998800021L;

   /** The name */
   private String name;

   /** The value */
   private String value;

   /**
    * Constructor
    */
   public ActivationConfigProperty()
   {
   }

   /**
    * Constructor
    * @param name The name
    * @param value The value
    */
   public ActivationConfigProperty(String name, String value)
   {
      setName(name);
      setValue(value);
   }

   /**
    * Get the name
    * @return The name
    */
   public String getName()
   {
      return name;
   }

   /**
    * Set the name
    * @param name The name
    */
   public void setName(String name)
   {
      this.name = name;
   }

   /**
    * Get the value
    * @return The value
    */
   public String getValue()
   {
      return value;
   }

   /**
    * Set the value
    * @param value The value
    */
   public void setValue(String value)
   {
      this.value = value;
   }

   /**
    * String representation
    * @return The representation
    */
   public String toString()
   {
      StringBuffer sb = new StringBuffer(ActivationConfigProperty.class.getName());
      sb = sb.append("{");
      sb = sb.append("name=" + name);
      sb = sb.append(", ");
      sb = sb.append("value=" + value);
      sb = sb.append("}");
      return sb.toString();
   }
}
