package org.jboss.cache.marshall;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class NodeDataExceptionMarker extends NodeData
{

   private static final long serialVersionUID = 240199474174502551L;
   private Throwable cause;
   private Object cacheNodeIdentity;

   public NodeDataExceptionMarker()
   {
      super();
   }

   public NodeDataExceptionMarker(Throwable t, Object node)
   {
      cause = t;
      cacheNodeIdentity = node;
   }

   public Throwable getCause()
   {
      return cause;
   }

   public Object getCacheNodeIdentity()
   {
      return cacheNodeIdentity;
   }

   @Override
   public boolean isExceptionMarker()
   {
      return true;
   }

   @Override
   public void writeExternal(ObjectOutput out) throws IOException
   {
      super.writeExternal(out);
      out.writeObject(cause);
      out.writeObject(cacheNodeIdentity);
   }

   @Override
   public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException
   {
      super.readExternal(in);
      cause = (Throwable) in.readObject();
      cacheNodeIdentity = in.readObject();
   }

   @Override
   public String toString()
   {
      return "NodeDataExceptionMarker";
   }
}
