/**************************************************************************\
 ibtk (Insomnia's Basic ToolKit)

  By Insomnia (Steaphan Greene)
  (insomnia@core.binghamton.edu)

  Copyright (C) 1999 Steaphan Greene

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.

\**************************************************************************/

#ifndef ISLIDER_H
#define ISLIDER_H

#include <X11/X.h>   
#include <X11/Xlib.h>
#include "idodad.h"
#include "iwindow.h"

class ISlider : public IDoDad  {
public:
  ISlider(char *t, IWindow *w, int xp, int yp, int xs, int ys);
  virtual ~ISlider();
  virtual int Type()  { return DODAD_SLIDER; };
  virtual void Redraw();
  virtual void Rebuild();
  virtual int Press(int b, int x, int y);
  virtual int Drag(int x, int y);
  int Value() { return value; };
  int Max() { return max; };
  int Min() { return min; };
  void SetValue(int v);
  void SetMax(int m) { max = m; if(value>m) value=m; Redraw(); };
  void SetMin(int m) { min = m; if(value<m) value=m; Redraw(); };
  void SetChangeCallback(void (*cb)(IDoDad *, IDoDad *, int));
  void Disable();
  void Enable();
protected:
  ISlider() {};
  void Init(char *t, IWindow *w, int xp, int yp, int xs, int ys);
  Pixmap Img[2], Wrk[2];
  int xpos, ypos, xsize, ysize;
  int value, max, min;
  int disabled;
  char *text;
  void (*changecallback)(IDoDad *, IDoDad *, int);
  };

#endif
