with Ada.Directories; use Ada.Directories;

with GNATCOLL.Projects; use GNATCOLL.Projects;
with GNATCOLL.VFS; use GNATCOLL.VFS;

with GPR.Opt;

with Ada.Text_IO; use Ada.Text_IO;

procedure Main is
   Env                 : Project_Environment_Access;
   Source_Project_Tree : GNATCOLL.Projects.Project_Tree;
   Success             : Boolean;

   F : Ada.Text_IO.File_Type;
begin
   Copy_File ("main-src.gpr", "main.gpr");
   Initialize (Env);
   Source_Project_Tree.Load (GNATCOLL.VFS.Create (+"main.gpr"), Env);
   Success := Source_Project_Tree.Root_Project.Save (Force => True);

   Open (F, In_File, "main.gpr");
   while not End_Of_File (F) loop
      Put_Line (Get_Line (F));
   end loop;
end Main;
