with GNATCOLL.Projects; use GNATCOLL.Projects;
with GNATCOLL.VFS;      use GNATCOLL.VFS;
with Ada.Text_IO;       use Ada.Text_IO;

procedure Iter is
   generic
      with procedure Action (Proj : Project_Tree; File : Virtual_File);
   procedure Iter_Project_Source_Files (Proj : Project_Tree);
   --  Iterate over all source files of a project.

   procedure Print_Single_File (Proj : Project_Tree; File : Virtual_File);
   --  Print the name of a single file

   -------------------------------
   -- Iter_Project_Source_Files --
   -------------------------------

   procedure Iter_Project_Source_Files (Proj : Project_Tree)
   is
      Proj_Type : constant Project_Type := Root_Project (Proj);
      File_List : constant File_Array_Access := Source_Files (Proj_Type);
   begin
      for Index in File_List'Range loop
         declare
            Inf : constant File_Info := Info (Proj, File_List (Index));
         begin
            case Unit_Part (Inf) is
               when Unit_Body =>
                  Action (Proj, File_List (Index));

               when Unit_Spec =>
                  if File_From_Unit
                     (Proj_Type,
                      Unit_Name (Inf),
                      Unit_Body,
                      "ada") = ""
                  then
                     Action (Proj, File_List (Index));
                  end if;

               when others =>
                  null;

            end case;

         end;
      end loop;
   end Iter_Project_Source_Files;

   procedure Print_Single_File (Proj : Project_Tree; File : Virtual_File)
   is
      pragma Unreferenced (Proj);
      Name : constant String := +Base_Name (File);
   begin
      Put_Line (Name);
   end Print_Single_File;

   procedure Print_Files is
      new Iter_Project_Source_Files (Print_Single_File);

   Tree      : Project_Tree;

   --  Beginning of processing for Iter
begin
   Tree.Load (GNATCOLL.VFS.Create ("test.gpr"));
   Print_Files (Tree);
end Iter;
