import unittest
from support import GNATCOLL_TestCase, chdir, pathsep


class Test(GNATCOLL_TestCase):
    @chdir("fill1")
    def setUp(self):
        self.gprbuild()

    @chdir("fill1")
    def test_greedy(self):
        self.runexec(["obj/fill_ada_comments", "--greedy", "sem_ch3.adb"],
                      "sem_ch3.adb.greedy.known-good")

    @chdir("fill1")
    def test_knuth(self):
        self.runexec(["obj/fill_ada_comments", "--knuth", "sem_ch3.adb"],
                      "sem_ch3.adb.knuth.known-good")

    @chdir("fill1")
    def test_knuth_with_prefix(self):
        self.runexec(["obj/fill_ada_comments", "--knuth", "sem_ch3.adb",
                      "--prefix=##"],
                      "sem_ch3.adb.knuth_prefix.known-good")

    @chdir("fill1")
    def test_pretty(self):
        self.runexec(["obj/fill_ada_comments", "--pretty", "sem_ch3.adb"],
                      "sem_ch3.adb.pretty.known-good")
