------------------------------------------------------------------------------
--                              G N A T L I B                               --
--                                                                          --
--                     Copyright (C) 2006-2017, AdaCore                     --
--                                                                          --
-- This library is free software;  you can redistribute it and/or modify it --
-- under terms of the  GNU General Public License  as published by the Free --
-- Software  Foundation;  either version 3,  or (at your  option) any later --
-- version. This library is distributed in the hope that it will be useful, --
-- but WITHOUT ANY WARRANTY;  without even the implied warranty of MERCHAN- --
-- TABILITY or FITNESS FOR A PARTICULAR PURPOSE.                            --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
-- You should have received a copy of the GNU General Public License and    --
-- a copy of the GCC Runtime Library Exception along with this program;     --
-- see the files COPYING3 and COPYING.RUNTIME respectively.  If not, see    --
-- <http://www.gnu.org/licenses/>.                                          --
--                                                                          --
------------------------------------------------------------------------------

with Ada.Strings.Fixed;     use Ada.Strings, Ada.Strings.Fixed;
with Ada.Strings.Unbounded; use Ada.Strings.Unbounded;
with Ada.Text_IO;           use Ada.Text_IO;
with GNATCOLL.Email.Parser;     use GNATCOLL.Email, GNATCOLL.Email.Parser;
with GNATCOLL.Email.Mailboxes;  use GNATCOLL.Email.Mailboxes;
with GNATCOLL.VFS;              use GNATCOLL.VFS;

procedure Test_Email5 is
   Box     : Mbox;
   Stored  : Stored_Mailbox;
   Stored2 : Stored_Mailbox;
   Stored3 : Stored_Mailbox;
   Stored4 : Stored_Mailbox;
   Stored5 : Stored_Mailbox;

   procedure Dump (Stored : in out Stored_Mailbox);
   procedure Dump (Stored : in out Stored_Mailbox) is
      Iter       : Stored_Mailbox_Cursor;
      Level      : Integer;
      Nb         : Integer := 1;
      Date, From, Subject : Unbounded_String;
      Short_Date : String (1 .. 26);
      Short_From : String (1 .. 20);
      Msg        : Message;
   begin
      Iter := Stored_Mailbox_Cursor (First (Stored, Recurse => True));
      while Has_Element (Iter) loop
         Level := Get_Thread_Level (Iter);
         Get_Message (Iter, Stored, Msg);
         if Msg /= Null_Message then
            To_String (Get_Header (Msg, "Date"), Result => Date,
                       Show_Header_Name => False);
            Move (To_String (Date), Short_Date, Drop => Right);
            To_String (Get_Header (Msg, "From"), Result => From,
                       Show_Header_Name => False);
            Move ((Level * ' ') & To_String (From), Short_From, Drop => Right);
            To_String (Get_Header (Msg, "Subject"),
                       Max_Line_Len => 120, Result => Subject,
                       Show_Header_Name => False);
            Put_Line
              (Nb'Img & ASCII.HT & Level'Img & ASCII.HT & Short_Date &
               "  " & Short_From & "  " & To_String (Subject));
         end if;

         Next (Iter, Stored);
         Nb := Nb + 1;
      end loop;
   end Dump;
begin
   Open (Box, Filename => Create (+"../email_data/F831-014"));
   Store (Stored, Box, Factory  => Parse_No_Payload'Access);
   Thread_Messages (Stored);
   Sort_By_Date (Stored);
   Put_Line ("------ Stored ------");
   Dump (Stored);

   --  This used to end in an infinite loop (see G417-009)

   Open (Box, Filename => Create (+"../email_data/G328_007"));
   Store (Stored2, Box, Factory  => Parse_No_Payload'Access);
   Thread_Messages (Stored2);

   --  We are missing some messages in threaded mode (see G418-004)

   Open (Box, Filename => Create (+"../email_data/G326_009"));
   Store (Stored3, Box, Factory  => Parse_No_Payload'Access);
   Sort_By_Date (Stored3);
   Thread_Messages (Stored3);
   Put_Line ("------ Stored 3 ------");
   Dump (Stored3);

   --  Inifinite loop (see FC04-019 and G612-005)

   Open (Box, Filename => Create (+"../email_data/FC04-019"));
   Store (Stored4, Box, Factory => Parse_No_Payload'Access);
   Thread_Messages (Stored4);
   Put_Line ("------ Stored 4 ------");
   Dump (Stored4);

   Open (Box, Filename => Create (+"../email_data/G615-008"));
   Store (Stored5, Box, Factory => Parse_No_Payload'Access);
   Thread_Messages (Stored5);
   Sort_By_Date (Stored5);
   Put_Line ("------ Stored 5 ------");
   Dump (Stored5);
end Test_Email5;
