--         ******************************
--         *
-- SPEC    *    ILSS_DB_Accounts
--         *
--         ******************************
package P is
--!
--! Purpose
--!   Initialisiert und verwaltet die ILGD User.
--!
--! Initialisation Exceptions
--!   keine
--!
--! Notes
--!   keine
--!

   type T_SQL_CONNECTION_POOL is new Integer;
   type T_DB_INFO is new Integer;
   type T_ILTIS_USER_KIND is new Integer;


   --         ******************************
   --         *
   -- SPEC    *    Set_Db_Info
   --         *
   --         ******************************
   procedure Set_Db_Info
      (Sql_Connection_Pool : in out T_SQL_CONNECTION_POOL;
       Db_Info             : in     T_DB_INFO);
   --!
   --! Purpose
   --!   Setzt die DB-Info des Connection-Pools.
   --!
   --! Exceptions
   --!   keine
   --!
   --! Notes
   --!   Die DB-Info muss vor dem ersten Aufruf von Get_connection
   --!   gesetzt werden.
   --!

   --         ******************************
   --         *
   -- SPEC    *    Is_User_Defined
   --         *
   --         ******************************
   function Is_User_Defined (Kind   : in     T_ILTIS_USER_KIND;
                             Master : in     BOOLEAN := FALSE)
      return BOOLEAN;
   --!
   --! Purpose
   --!   Gibt zurueck, ob ein entsprechender ILTIS USER defniniert wurde.
   --!
   --! Exceptions
   --!   keine
   --!
   --! Notes
   --!   keine
   --!

   --  Invalid
   procedure Foo
      (A : Integer; --  some parameter
       B : Integer);
   --  comments for Foo

   --  comments for Foo2
   procedure Foo2
      (A : Integer; --  some parameter
       B : Integer);

   --  Invalid
   procedure Bar
      (A : Integer;
       --  some parameter

       B : Integer);
   --  comments for Bar

       
end P;
