------------------------------------------------------------------------------
--                             G N A T C O L L                              --
--                                                                          --
--                     Copyright (C) 2010-2014, AdaCore                     --
--                                                                          --
-- This library is free software;  you can redistribute it and/or modify it --
-- under terms of the  GNU General Public License  as published by the Free --
-- Software  Foundation;  either version 3,  or (at your  option) any later --
-- version. This library is distributed in the hope that it will be useful, --
-- but WITHOUT ANY WARRANTY;  without even the implied warranty of MERCHAN- --
-- TABILITY or FITNESS FOR A PARTICULAR PURPOSE.                            --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
-- You should have received a copy of the GNU General Public License and    --
-- a copy of the GCC Runtime Library Exception along with this program;     --
-- see the files COPYING3 and COPYING.RUNTIME respectively.  If not, see    --
-- <http://www.gnu.org/licenses/>.                                          --
--                                                                          --
------------------------------------------------------------------------------

with Ada.Exceptions;            use Ada.Exceptions;
with Ada.Text_IO;               use Ada.Text_IO;
with GNATCOLL.Refcount.Weakref;
with Test_Refcount_Support;     use Test_Refcount_Support;

procedure Test_Refcount is
   procedure Test_Refs;
   procedure Test_Weak_Refs;

   procedure Test_Refs is
      use Refs;
      A : Ref;
   begin
      Put_Line ("===== Test_Refs =====");
      Set (A, Create (1));

      Put_Line ("Will free 1, create 3");
      Set (A, Create (3));

      declare
         B : Ref;
      begin
         Set (B, Create (2));
         Put_Line ("Will free 2");
      end;

      Put_Line ("Will free 3");
   end Test_Refs;

   WA, WB : Weak_Refs.Weak_Ref;

   procedure Test_Weak_Refs is
      use Weak_Refs;
      A : Ref;
   begin
      Put_Line ("===== Test_Weak_Refs =====");
      Set (A, Create (3));
      WA := Get_Weak_Ref (A);

      declare
         B : Ref;
      begin
         Set (B, Create (4));
         WB := Get_Weak_Ref (B);
         Put_Line ("Will free 4");
      end;

      Put_Line ("A'Weak_Ref exists ? "
                & Boolean'Image (Get (WA) /= Null_Ref));
      Put_Line ("B'Weak_Ref exists ? "
                & Boolean'Image (Get (WB) /= Null_Ref));

      Put_Line ("Will free 3");

   exception
      when E : others =>
         Put_Line ("Unexpected exception: " & Exception_Information (E));
   end Test_Weak_Refs;

   use Weak_Refs;
begin
   Test_Refs;
   Test_Weak_Refs;
   Put_Line ("A'Weak_Ref exists ? "
             & Boolean'Image (Get (WA) /= Null_Ref));
   Put_Line ("B'Weak_Ref exists ? "
             & Boolean'Image (Get (WB) /= Null_Ref));

end Test_Refcount;
